/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.forms;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.enums.forms.FormAttributes;
import com.pixelmonmod.pixelmon.enums.forms.ICosmeticForm;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public enum EnumClobbopus implements IEnumForm,
ICosmeticForm
{
    NORMAL,
    IRISH,
    DIAMONDS,
    CLUBS,
    MARTIAN,
    STARRY,
    YELLOW_RINGED,
    RED_RINGED,
    ALIEN;

    public static Pair<EnumClobbopus, Integer>[] OLD_ROD_WEIGHTS;

    public static EnumClobbopus getWeightedRodForm(int rodQuality) {
        int randomIndex;
        int availableForms = 1;
        switch (rodQuality) {
            case 6: {
                availableForms = 9;
                break;
            }
            case 5: {
                availableForms = 8;
                break;
            }
            case 4: {
                availableForms = 6;
                break;
            }
            case 3: {
                availableForms = 5;
                break;
            }
            case 2: {
                availableForms = 4;
                break;
            }
            case 1: {
                availableForms = 2;
            }
        }
        double totalWeight = 0.0;
        for (int i = 0; i < availableForms; ++i) {
            totalWeight += (double)((Integer)OLD_ROD_WEIGHTS[i].getRight()).intValue();
        }
        double random = Math.random() * totalWeight;
        for (randomIndex = 0; randomIndex < OLD_ROD_WEIGHTS.length && !((random -= (double)((Integer)OLD_ROD_WEIGHTS[randomIndex].getRight()).intValue()) <= 0.0); ++randomIndex) {
        }
        return (EnumClobbopus)OLD_ROD_WEIGHTS[randomIndex].getLeft();
    }

    public static EnumClobbopus getFromIndex(int index) {
        try {
            return EnumClobbopus.values()[index];
        }
        catch (IndexOutOfBoundsException e) {
            return NORMAL;
        }
    }

    @Override
    public byte getForm() {
        return (byte)this.ordinal();
    }

    @Override
    public boolean isDefaultForm() {
        return this == NORMAL;
    }

    @Override
    public String getUnlocalizedName() {
        return "pixelmon.clobbopus.form." + this.name().toLowerCase();
    }

    @Override
    public String getFormSuffix(boolean shiny) {
        if (shiny) {
            return "";
        }
        return this.getFormSuffix();
    }

    @Override
    public String getFormSuffix() {
        return "-" + this.name().toLowerCase();
    }

    @Override
    public boolean isCosmetic() {
        return this != NORMAL;
    }

    @Override
    public Set<FormAttributes> getFormAttributes() {
        if (this != NORMAL) {
            return Sets.immutableEnumSet((Enum)FormAttributes.COSMETIC, (Enum[])new FormAttributes[0]);
        }
        return IEnumForm.super.getFormAttributes();
    }

    @Override
    @Nonnull
    public IEnumForm getBaseFromCosmetic(Pokemon pokemon) {
        return NORMAL;
    }

    @Override
    public String getName() {
        return this.name();
    }

    static {
        OLD_ROD_WEIGHTS = new Pair[]{ImmutablePair.of((Object)NORMAL, (Object)120), ImmutablePair.of((Object)IRISH, (Object)60), ImmutablePair.of((Object)DIAMONDS, (Object)60), ImmutablePair.of((Object)CLUBS, (Object)60), ImmutablePair.of((Object)MARTIAN, (Object)40), ImmutablePair.of((Object)STARRY, (Object)40), ImmutablePair.of((Object)YELLOW_RINGED, (Object)20), ImmutablePair.of((Object)RED_RINGED, (Object)15), ImmutablePair.of((Object)ALIEN, (Object)5)};
    }
}

