/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.forms;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.enums.forms.FormAttributes;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.Set;

public enum EnumDarmanitan implements IEnumForm
{
    STANDARD,
    ZEN,
    GALAR_STANDARD,
    GALAR_ZEN;


    @Override
    public String getFormSuffix() {
        return "-" + this.name().toLowerCase().replace("_", "-");
    }

    @Override
    public byte getForm() {
        return (byte)this.ordinal();
    }

    @Override
    public boolean isDefaultForm() {
        return this == STANDARD || this == GALAR_STANDARD;
    }

    @Override
    public boolean isTemporary() {
        return this == ZEN || this == GALAR_ZEN;
    }

    @Override
    public IEnumForm getDefaultFromTemporary(Pokemon pokemon) {
        if (pokemon.getFormEnum() == ZEN) {
            return STANDARD;
        }
        if (pokemon.getFormEnum() == GALAR_ZEN) {
            return GALAR_STANDARD;
        }
        return STANDARD;
    }

    @Override
    public IEnumForm getDefaultFromForm(IEnumForm form) {
        return STANDARD;
    }

    @Override
    public Set<FormAttributes> getFormAttributes() {
        switch (this) {
            case GALAR_STANDARD: 
            case GALAR_ZEN: {
                return Sets.immutableEnumSet((Enum)FormAttributes.GALARIAN, (Enum[])new FormAttributes[0]);
            }
        }
        return IEnumForm.super.getFormAttributes();
    }

    @Override
    public String getUnlocalizedName() {
        return "pixelmon.darmanitan.form." + this.name().toLowerCase();
    }

    public EnumDarmanitan getZenFromStandard() {
        return this == GALAR_STANDARD ? GALAR_ZEN : ZEN;
    }

    @Override
    public String getName() {
        return this.name();
    }
}

