/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.forms;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.extraStats.DeoxysStats;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.ICosmeticForm;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.Arrays;
import javax.annotation.Nonnull;

public enum EnumDeoxys implements IEnumForm,
ICosmeticForm
{
    Normal,
    Attack,
    Defense,
    Speed,
    Sus;

    private static final EnumDeoxys[] VALUES;
    private static final EnumDeoxys[] NO_COSMETIC;

    @Override
    public String getFormSuffix() {
        return "-" + this.name().toLowerCase();
    }

    @Override
    public byte getForm() {
        return (byte)this.ordinal();
    }

    @Override
    public boolean isDefaultForm() {
        return this == Normal;
    }

    @Override
    public String getUnlocalizedName() {
        return "pixelmon.deoxys.form." + this.name().toLowerCase();
    }

    @Override
    public boolean isCosmetic() {
        return this == Sus;
    }

    @Override
    @Nonnull
    public IEnumForm getBaseFromCosmetic(Pokemon pokemon) {
        return pokemon.getFormEnum() == Sus ? Normal : pokemon.getFormEnum();
    }

    @Override
    public boolean hasShiny(EnumSpecies species) {
        return true;
    }

    public static EnumDeoxys getFromIndex(int index) {
        try {
            return VALUES[index];
        }
        catch (IndexOutOfBoundsException e) {
            return Normal;
        }
    }

    public static int getNextForm(int current, Pokemon pokemon) {
        EnumDeoxys[] forms = VALUES;
        if (pokemon.getExtraStats(DeoxysStats.class) == null || !pokemon.getExtraStats(DeoxysStats.class).isSus()) {
            forms = NO_COSMETIC;
        }
        if (current < 0 || current + 1 >= forms.length) {
            return 0;
        }
        return current + 1;
    }

    @Override
    public String getName() {
        return this.name();
    }

    static {
        VALUES = EnumDeoxys.values();
        NO_COSMETIC = Arrays.copyOfRange(VALUES, 0, Speed.ordinal());
    }
}

