/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.forms;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.enums.forms.FormAttributes;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.Set;

public enum EnumGengar implements IEnumForm
{
    Normal(0, ""),
    Mega(1, "mega"),
    Gigantamax(2, "gmax");

    private final byte form;
    private final String suffix;

    private EnumGengar(int form, String suffix) {
        this.form = (byte)form;
        this.suffix = suffix;
    }

    @Override
    public String getFormSuffix() {
        return this == Normal ? "" : "-" + this.suffix;
    }

    @Override
    public byte getForm() {
        return this.form;
    }

    @Override
    public boolean isTemporary() {
        return this != Normal;
    }

    @Override
    public IEnumForm getDefaultFromTemporary(Pokemon pokemon) {
        return Normal;
    }

    @Override
    public boolean isDefaultForm() {
        return this == Normal;
    }

    @Override
    public Set<FormAttributes> getFormAttributes() {
        switch (this) {
            case Mega: {
                return Sets.immutableEnumSet((Enum)FormAttributes.MEGA_EVOLUTION, (Enum[])new FormAttributes[0]);
            }
            case Gigantamax: {
                return Sets.immutableEnumSet((Enum)FormAttributes.GIGANTAMAX, (Enum[])new FormAttributes[0]);
            }
        }
        return IEnumForm.super.getFormAttributes();
    }

    @Override
    public String getUnlocalizedName() {
        return "pixelmon.generic.form." + this.name().toLowerCase();
    }

    @Override
    public String getName() {
        return this.name();
    }
}

