/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.forms;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.enums.forms.EnumFeebas;
import com.pixelmonmod.pixelmon.enums.forms.ICosmeticForm;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public enum EnumMagikarp implements IEnumForm,
ICosmeticForm
{
    NORMAL,
    ROASTED,
    SKELLY,
    CALICO_ORANGE_WHITE,
    CALICO_ORANGE_WHITE_BLACK,
    CALICO_WHITE_ORANGE,
    CALICO_ORANGE_GOLD,
    ORANGE_TWOTONE,
    ORANGE_ORCA,
    ORANGE_DAPPLES,
    PINK_TWOTONE,
    PINK_ORCA,
    PINK_DAPPLES,
    GRAY_BUBBLES,
    GRAY_DIAMONDS,
    GRAY_PATCHES,
    PURPLE_BUBBLES,
    PURPLE_DIAMONDS,
    PURPLE_PATCHES,
    APRICOT_TIGER,
    APRICOT_ZEBRA,
    APRICOT_STRIPES,
    BROWN_TIGER,
    BROWN_ZEBRA,
    BROWN_STRIPES,
    WHITE_FOREHEAD,
    WHITE_MASK,
    BLACK_FOREHEAD,
    BLACK_MASK,
    BLUE_SAUCY,
    BLUE_RAINDROPS,
    VIOLET_SAUCY,
    VIOLET_RAINDROPS;

    public static Pair<IEnumForm, Integer>[] OLD_ROD_WEIGHTS;

    public static IEnumForm getWeightedRodForm(int rodQuality) {
        int randomIndex;
        int availableForms = 6;
        switch (rodQuality) {
            case 6: {
                availableForms = 33;
                break;
            }
            case 5: {
                availableForms = 28;
                break;
            }
            case 4: {
                availableForms = 24;
                break;
            }
            case 3: {
                availableForms = 18;
                break;
            }
            case 2: {
                availableForms = 12;
                break;
            }
            case 1: {
                availableForms = 9;
            }
        }
        double totalWeight = 0.0;
        for (int i = 0; i < availableForms; ++i) {
            totalWeight += (double)((Integer)OLD_ROD_WEIGHTS[i].getRight()).intValue();
        }
        double random = Math.random() * totalWeight;
        for (randomIndex = 0; randomIndex < OLD_ROD_WEIGHTS.length && !((random -= (double)((Integer)OLD_ROD_WEIGHTS[randomIndex].getRight()).intValue()) <= 0.0); ++randomIndex) {
        }
        return (IEnumForm)OLD_ROD_WEIGHTS[randomIndex].getLeft();
    }

    @Override
    public String getFormSuffix(boolean shiny) {
        if (shiny) {
            return "";
        }
        return this.getFormSuffix();
    }

    @Override
    public String getFormSuffix() {
        if (this != NORMAL) {
            return "-" + this.name().toLowerCase();
        }
        return "";
    }

    @Override
    public String getSpriteSuffix(boolean shiny) {
        if (shiny) {
            return "";
        }
        if (this != NORMAL) {
            return "-" + this.name().toLowerCase();
        }
        return "";
    }

    @Override
    public byte getForm() {
        return (byte)this.ordinal();
    }

    @Override
    public boolean isDefaultForm() {
        return this == NORMAL;
    }

    @Override
    public String getUnlocalizedName() {
        return "pixelmon.magikarp.form." + this.name().toLowerCase();
    }

    @Override
    public boolean isCosmetic() {
        return this != NORMAL;
    }

    @Override
    @Nonnull
    public IEnumForm getBaseFromCosmetic(Pokemon pokemon) {
        return NORMAL;
    }

    @Override
    public String getName() {
        return this.name();
    }

    static {
        OLD_ROD_WEIGHTS = new Pair[]{ImmutablePair.of((Object)NORMAL, (Object)120), ImmutablePair.of((Object)SKELLY, (Object)11), ImmutablePair.of((Object)CALICO_ORANGE_GOLD, (Object)9), ImmutablePair.of((Object)CALICO_ORANGE_WHITE, (Object)38), ImmutablePair.of((Object)CALICO_ORANGE_WHITE_BLACK, (Object)38), ImmutablePair.of((Object)CALICO_WHITE_ORANGE, (Object)38), ImmutablePair.of((Object)ORANGE_TWOTONE, (Object)40), ImmutablePair.of((Object)ORANGE_ORCA, (Object)10), ImmutablePair.of((Object)ORANGE_DAPPLES, (Object)40), ImmutablePair.of((Object)PINK_TWOTONE, (Object)40), ImmutablePair.of((Object)PINK_ORCA, (Object)10), ImmutablePair.of((Object)PINK_DAPPLES, (Object)40), ImmutablePair.of((Object)GRAY_BUBBLES, (Object)40), ImmutablePair.of((Object)GRAY_DIAMONDS, (Object)40), ImmutablePair.of((Object)GRAY_PATCHES, (Object)10), ImmutablePair.of((Object)PURPLE_BUBBLES, (Object)40), ImmutablePair.of((Object)PURPLE_DIAMONDS, (Object)40), ImmutablePair.of((Object)PURPLE_PATCHES, (Object)10), ImmutablePair.of((Object)APRICOT_TIGER, (Object)11), ImmutablePair.of((Object)APRICOT_ZEBRA, (Object)40), ImmutablePair.of((Object)APRICOT_STRIPES, (Object)40), ImmutablePair.of((Object)BROWN_TIGER, (Object)11), ImmutablePair.of((Object)BROWN_ZEBRA, (Object)40), ImmutablePair.of((Object)BROWN_STRIPES, (Object)40), ImmutablePair.of((Object)WHITE_FOREHEAD, (Object)35), ImmutablePair.of((Object)WHITE_MASK, (Object)8), ImmutablePair.of((Object)BLACK_FOREHEAD, (Object)35), ImmutablePair.of((Object)BLACK_MASK, (Object)8), ImmutablePair.of((Object)BLUE_SAUCY, (Object)32), ImmutablePair.of((Object)BLUE_RAINDROPS, (Object)8), ImmutablePair.of((Object)VIOLET_SAUCY, (Object)32), ImmutablePair.of((Object)VIOLET_RAINDROPS, (Object)8), ImmutablePair.of((Object)EnumFeebas.KARP, (Object)4)};
    }
}

