/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.forms;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.enums.forms.FormAttributes;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.Set;

public enum EnumMega implements IEnumForm
{
    Normal(0, ""),
    Mega(1, "mega"),
    MegaX(1, "mega-x"),
    MegaY(2, "mega-y");

    private final byte form;
    private final String suffix;

    private EnumMega(int form, String suffix) {
        this.form = (byte)form;
        this.suffix = suffix;
    }

    @Override
    public String getFormSuffix() {
        return this == Normal ? "" : "-" + this.suffix;
    }

    @Override
    public byte getForm() {
        return this.form;
    }

    @Override
    public boolean isTemporary() {
        return this != Normal;
    }

    @Override
    public IEnumForm getDefaultFromTemporary(Pokemon pokemon) {
        return Normal;
    }

    @Override
    public boolean isDefaultForm() {
        return this == Normal;
    }

    @Override
    public Set<FormAttributes> getFormAttributes() {
        if (this != Normal) {
            return Sets.immutableEnumSet((Enum)FormAttributes.MEGA_EVOLUTION, (Enum[])new FormAttributes[0]);
        }
        return IEnumForm.super.getFormAttributes();
    }

    @Override
    public String getUnlocalizedName() {
        return "pixelmon.generic.form." + this.name().toLowerCase();
    }

    @Override
    public String getName() {
        return this.name();
    }
}

