/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.forms;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.enums.forms.FormAttributes;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.Set;

public enum EnumMeowth implements IEnumForm
{
    Normal(0, "normal"),
    Alolan(1, "alola"),
    Galarian(2, "galar"),
    Gigantamax(3, "gmax");

    private final byte form;
    private final String suffix;

    private EnumMeowth(int form, String suffix) {
        this.form = (byte)form;
        this.suffix = suffix;
    }

    @Override
    public String getFormSuffix() {
        return "-" + this.suffix;
    }

    @Override
    public byte getForm() {
        return this.form;
    }

    @Override
    public boolean isTemporary() {
        return this == Gigantamax;
    }

    @Override
    public IEnumForm getDefaultFromTemporary(Pokemon pokemon) {
        return Normal;
    }

    @Override
    public boolean isDefaultForm() {
        return this == Normal;
    }

    @Override
    public Set<FormAttributes> getFormAttributes() {
        switch (this) {
            case Alolan: {
                return Sets.immutableEnumSet((Enum)FormAttributes.ALOLAN, (Enum[])new FormAttributes[0]);
            }
            case Galarian: {
                return Sets.immutableEnumSet((Enum)FormAttributes.GALARIAN, (Enum[])new FormAttributes[0]);
            }
            case Gigantamax: {
                return Sets.immutableEnumSet((Enum)FormAttributes.GIGANTAMAX, (Enum[])new FormAttributes[0]);
            }
        }
        return IEnumForm.super.getFormAttributes();
    }

    @Override
    public String getUnlocalizedName() {
        return "pixelmon.generic.form." + this.name().toLowerCase();
    }

    @Override
    public String getName() {
        return this.name();
    }
}

