/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.forms;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.enums.forms.FormAttributes;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.Set;

public enum EnumSnorlax implements IEnumForm
{
    Normal(0, "normal"),
    Snow(1, "snow"),
    Gigantamax(2, "gmax");

    private final byte form;
    private final String suffix;

    private EnumSnorlax(int form, String suffix) {
        this.form = (byte)form;
        this.suffix = suffix;
    }

    @Override
    public String getFormSuffix() {
        return this == Normal ? "" : "-" + this.suffix;
    }

    @Override
    public String getFormSuffix(boolean shiny) {
        if (shiny && this != Gigantamax) {
            return "";
        }
        return this.getFormSuffix();
    }

    @Override
    public byte getForm() {
        return this.form;
    }

    @Override
    public boolean isTemporary() {
        return this == Gigantamax;
    }

    @Override
    public boolean isDefaultForm() {
        return this == Normal;
    }

    @Override
    public Set<FormAttributes> getFormAttributes() {
        switch (this) {
            case Snow: {
                return Sets.immutableEnumSet((Enum)FormAttributes.COSMETIC, (Enum[])new FormAttributes[0]);
            }
            case Gigantamax: {
                return Sets.immutableEnumSet((Enum)FormAttributes.GIGANTAMAX, (Enum[])new FormAttributes[0]);
            }
        }
        return IEnumForm.super.getFormAttributes();
    }

    @Override
    public String getUnlocalizedName() {
        return (this == Snow ? "pixelmon.snorlax.form." : "pixelmon.generic.form.") + this.name().toLowerCase();
    }

    @Override
    public String getName() {
        return this.name();
    }
}

