/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.forms;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.FormAttributes;
import com.pixelmonmod.pixelmon.enums.forms.ICosmeticForm;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.Set;
import javax.annotation.Nonnull;

public enum EnumSpecial implements IEnumForm,
ICosmeticForm
{
    Base("", 0),
    Zombie("-zombie", 100),
    Online("-online", 101),
    Drowned("-drowned", 102),
    Valentine("-valentine", 103),
    Rainbow("-rainbow", 104),
    Alien("-alien", 105),
    Valencian("-valencian", 106),
    Alter("-alter", 107),
    Pink("-pink", 108),
    Summer("-summer", 109),
    Crystal("-crystal", 110),
    Creator("-creator", 111),
    Strike("-strike", 112),
    Ashen("-ashen", 113),
    Spirit("-spirit", 114),
    Halloween("-halloween", 115);

    private String suffix;
    private byte index;

    private EnumSpecial(String suffix, byte index) {
        this.suffix = suffix;
        this.index = index;
    }

    @Override
    public String getFormSuffix(boolean shiny) {
        if (shiny && this != Rainbow && this != Valentine) {
            return "";
        }
        return this.getFormSuffix();
    }

    @Override
    public String getFormSuffix() {
        return this.suffix;
    }

    @Override
    public byte getForm() {
        return this.index;
    }

    @Override
    public boolean isDefaultForm() {
        return false;
    }

    @Override
    public String getUnlocalizedName() {
        return "pixelmon.generic.form." + this.name().toLowerCase();
    }

    @Override
    public boolean hasShiny(EnumSpecies species) {
        if (this == Rainbow || this == Valentine) {
            return species != EnumSpecies.Skarmory;
        }
        return false;
    }

    @Override
    public boolean isCosmetic() {
        return true;
    }

    @Override
    public Set<FormAttributes> getFormAttributes() {
        if (this != Base) {
            return Sets.immutableEnumSet((Enum)FormAttributes.COSMETIC, (Enum[])new FormAttributes[0]);
        }
        return IEnumForm.super.getFormAttributes();
    }

    @Override
    @Nonnull
    public IEnumForm getBaseFromCosmetic(Pokemon pokemon) {
        if (EnumSpecies.mfTextured.contains(pokemon.getSpecies())) {
            return pokemon.getGender();
        }
        return pokemon.getSpecies().getPossibleForms(false).get(0);
    }

    @Override
    public String getName() {
        return this.name();
    }
}

