/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.forms;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.enums.forms.FormAttributes;
import com.pixelmonmod.pixelmon.enums.forms.ICosmeticForm;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public enum EnumSpheal implements IEnumForm,
ICosmeticForm
{
    NORMAL,
    POKEBALL,
    DUSKBALL,
    LOVEBALL,
    FRIENDBALL,
    HEAVYBALL,
    MOONBALL,
    PREMIERBALL,
    MASTERBALL,
    GSBALL;

    public static Pair<EnumSpheal, Integer>[] OLD_ROD_WEIGHTS;

    public static EnumSpheal getWeightedRodForm(int rodQuality) {
        int randomIndex;
        int availableForms = 1;
        switch (rodQuality) {
            case 6: {
                availableForms = 10;
                break;
            }
            case 5: {
                availableForms = 8;
                break;
            }
            case 4: {
                availableForms = 6;
                break;
            }
            case 3: {
                availableForms = 5;
                break;
            }
            case 2: {
                availableForms = 4;
                break;
            }
            case 1: {
                availableForms = 2;
            }
        }
        double totalWeight = 0.0;
        for (int i = 0; i < availableForms; ++i) {
            totalWeight += (double)((Integer)OLD_ROD_WEIGHTS[i].getRight()).intValue();
        }
        double random = Math.random() * totalWeight;
        for (randomIndex = 0; randomIndex < OLD_ROD_WEIGHTS.length && !((random -= (double)((Integer)OLD_ROD_WEIGHTS[randomIndex].getRight()).intValue()) <= 0.0); ++randomIndex) {
        }
        return (EnumSpheal)OLD_ROD_WEIGHTS[randomIndex].getLeft();
    }

    public static EnumSpheal getFromIndex(int index) {
        try {
            return EnumSpheal.values()[index];
        }
        catch (IndexOutOfBoundsException e) {
            return NORMAL;
        }
    }

    @Override
    public byte getForm() {
        return (byte)this.ordinal();
    }

    @Override
    public boolean isDefaultForm() {
        return this == NORMAL;
    }

    @Override
    public String getUnlocalizedName() {
        return "pixelmon.spheal.form." + this.name().toLowerCase();
    }

    @Override
    public String getFormSuffix(boolean shiny) {
        if (shiny) {
            return "";
        }
        return this.getFormSuffix();
    }

    @Override
    public String getFormSuffix() {
        return "-" + this.name().toLowerCase();
    }

    @Override
    public boolean isCosmetic() {
        return this != NORMAL;
    }

    @Override
    public Set<FormAttributes> getFormAttributes() {
        if (this != NORMAL) {
            return Sets.immutableEnumSet((Enum)FormAttributes.COSMETIC, (Enum[])new FormAttributes[0]);
        }
        return IEnumForm.super.getFormAttributes();
    }

    @Override
    @Nonnull
    public IEnumForm getBaseFromCosmetic(Pokemon pokemon) {
        return NORMAL;
    }

    @Override
    public String getName() {
        return this.name();
    }

    static {
        OLD_ROD_WEIGHTS = new Pair[]{ImmutablePair.of((Object)NORMAL, (Object)120), ImmutablePair.of((Object)POKEBALL, (Object)60), ImmutablePair.of((Object)DUSKBALL, (Object)60), ImmutablePair.of((Object)LOVEBALL, (Object)60), ImmutablePair.of((Object)FRIENDBALL, (Object)40), ImmutablePair.of((Object)HEAVYBALL, (Object)40), ImmutablePair.of((Object)MOONBALL, (Object)20), ImmutablePair.of((Object)PREMIERBALL, (Object)15), ImmutablePair.of((Object)MASTERBALL, (Object)5), ImmutablePair.of((Object)GSBALL, (Object)1)};
    }
}

