/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.forms;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.forms.FormAttributes;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public enum EnumToxtricity implements IEnumForm
{
    AMPED("amped", EnumNature.Hardy, EnumNature.Brave, EnumNature.Adamant, EnumNature.Naughty, EnumNature.Docile, EnumNature.Impish, EnumNature.Lax, EnumNature.Hasty, EnumNature.Jolly, EnumNature.Naive, EnumNature.Rash, EnumNature.Sassy, EnumNature.Quirky),
    LOWKEY("lowkey", EnumNature.Lonely, EnumNature.Bold, EnumNature.Relaxed, EnumNature.Timid, EnumNature.Serious, EnumNature.Modest, EnumNature.Mild, EnumNature.Quiet, EnumNature.Bashful, EnumNature.Calm, EnumNature.Gentle, EnumNature.Careful),
    GIGANTAMAX("gmax", new EnumNature[0]);

    private static final EnumToxtricity[] VALUES;
    private final byte form;
    private final String suffix;
    private final EnumSet<EnumNature> natures = EnumSet.noneOf(EnumNature.class);

    private EnumToxtricity(String suffix, EnumNature ... natures) {
        this.form = (byte)this.ordinal();
        this.suffix = suffix;
        this.natures.addAll(Arrays.asList(natures));
    }

    @Override
    public String getFormSuffix() {
        return "-" + this.suffix;
    }

    @Override
    public byte getForm() {
        return this.form;
    }

    @Override
    public boolean isTemporary() {
        return this == GIGANTAMAX;
    }

    @Override
    public IEnumForm getDefaultFromTemporary(Pokemon pokemon) {
        for (EnumToxtricity form : VALUES) {
            if (!form.natures.contains(pokemon.getBaseNature())) continue;
            return form;
        }
        return AMPED;
    }

    @Override
    public IEnumForm getDefaultFromForm(IEnumForm form) {
        return RandomHelper.rand.nextBoolean() ? AMPED : LOWKEY;
    }

    @Override
    public boolean isDefaultForm() {
        return this == AMPED || this == LOWKEY;
    }

    @Override
    public Set<FormAttributes> getFormAttributes() {
        if (this == GIGANTAMAX) {
            return Sets.immutableEnumSet((Enum)FormAttributes.GIGANTAMAX, (Enum[])new FormAttributes[0]);
        }
        return IEnumForm.super.getFormAttributes();
    }

    @Override
    public String getUnlocalizedName() {
        return this == GIGANTAMAX ? "pixelmon.generic.form.gigantamax" : "pixelmon.toxtricity.form." + this.suffix;
    }

    public Set<EnumNature> getNatures() {
        return ImmutableSet.copyOf(this.natures);
    }

    @Override
    public String getName() {
        return this.name();
    }

    static {
        VALUES = EnumToxtricity.values();
    }
}

