/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.forms;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.enums.forms.FormAttributes;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.Set;

public enum EnumUrshifu implements IEnumForm
{
    SingleStrike(0, "singlestrike"),
    RapidStrike(1, "rapidstrike"),
    GigantamaxSS(2, "gmaxss"),
    GigantamaxRS(3, "gmaxrs");

    private final byte form;
    private final String suffix;

    private EnumUrshifu(int form, String suffix) {
        this.form = (byte)form;
        this.suffix = suffix;
    }

    @Override
    public String getFormSuffix() {
        return "-" + this.suffix;
    }

    @Override
    public byte getForm() {
        return (byte)this.ordinal();
    }

    @Override
    public boolean isDefaultForm() {
        return false;
    }

    @Override
    public boolean isTemporary() {
        return this.form >= 2;
    }

    @Override
    public IEnumForm getDefaultFromTemporary(Pokemon pokemon) {
        return pokemon.getForm() == 2 ? SingleStrike : RapidStrike;
    }

    @Override
    public IEnumForm getDefaultFromForm(IEnumForm form) {
        return form == GigantamaxSS || form == SingleStrike ? SingleStrike : RapidStrike;
    }

    @Override
    public String getUnlocalizedName() {
        return "pixelmon." + (this.isTemporary() ? "generic" : "urshifu") + ".form." + this.name().toLowerCase();
    }

    @Override
    public Set<FormAttributes> getFormAttributes() {
        switch (this) {
            case GigantamaxSS: 
            case GigantamaxRS: {
                return Sets.immutableEnumSet((Enum)FormAttributes.GIGANTAMAX, (Enum[])new FormAttributes[0]);
            }
        }
        return IEnumForm.super.getFormAttributes();
    }

    public EnumUrshifu getGigantamax() {
        switch (this) {
            case RapidStrike: {
                return GigantamaxRS;
            }
            case SingleStrike: {
                return GigantamaxSS;
            }
        }
        return this;
    }

    public EnumUrshifu getRegular() {
        switch (this) {
            case GigantamaxRS: {
                return RapidStrike;
            }
            case GigantamaxSS: {
                return SingleStrike;
            }
        }
        return this;
    }

    @Override
    public String getName() {
        return this.name();
    }
}

