/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.technicalmoves;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen1TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen2TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen3TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen4TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen5TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen6TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen7TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen8TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen8TechnicalRecords;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface ITechnicalMove {
    public String prefix();

    public int getId();

    public String getAttackName();

    default public AttackBase getAttack() {
        return AttackBase.getAttackBaseFromEnglishName(this.getAttackName()).orElse(null);
    }

    default public int getGeneration() {
        if (this instanceof Gen1TechnicalMachines) {
            return 1;
        }
        if (this instanceof Gen2TechnicalMachines) {
            return 2;
        }
        if (this instanceof Gen3TechnicalMachines) {
            return 3;
        }
        if (this instanceof Gen4TechnicalMachines) {
            return 4;
        }
        if (this instanceof Gen5TechnicalMachines) {
            return 5;
        }
        if (this instanceof Gen6TechnicalMachines) {
            return 6;
        }
        if (this instanceof Gen7TechnicalMachines) {
            return 7;
        }
        if (this instanceof Gen8TechnicalMachines || this instanceof Gen8TechnicalRecords) {
            return 8;
        }
        return -1;
    }

    public static ITechnicalMove getMoveFor(String directory, int id) {
        switch (directory) {
            case "tr8": 
            case "tr_gen8": {
                return Gen8TechnicalRecords.getTr(id);
            }
            case "tm8": 
            case "tm_gen8": {
                return Gen8TechnicalMachines.getTm(id);
            }
            case "tm_gen7": {
                return Gen7TechnicalMachines.getTm(id);
            }
            case "tm_gen6": {
                return Gen6TechnicalMachines.getTm(id);
            }
            case "tm_gen5": {
                return Gen5TechnicalMachines.getTm(id);
            }
            case "tm_gen4": {
                return Gen4TechnicalMachines.getTm(id);
            }
            case "tm_gen3": {
                return Gen3TechnicalMachines.getTm(id);
            }
            case "tm_gen2": {
                return Gen2TechnicalMachines.getTm(id);
            }
            case "tm_gen1": {
                return Gen1TechnicalMachines.getTm(id);
            }
        }
        return null;
    }

    public static ITechnicalMove getMoveFor(String directory, String move) {
        switch (directory) {
            case "tr8": 
            case "tr_gen8": {
                return Gen8TechnicalRecords.getTr(move);
            }
            case "tm8": 
            case "tm_gen8": {
                return Gen8TechnicalMachines.getTm(move);
            }
            case "tm_gen7": {
                return Gen7TechnicalMachines.getTm(move);
            }
            case "tm_gen6": {
                return Gen6TechnicalMachines.getTm(move);
            }
            case "tm_gen5": {
                return Gen5TechnicalMachines.getTm(move);
            }
            case "tm_gen4": {
                return Gen4TechnicalMachines.getTm(move);
            }
            case "tm_gen3": {
                return Gen3TechnicalMachines.getTm(move);
            }
            case "tm_gen2": {
                return Gen2TechnicalMachines.getTm(move);
            }
            case "tm_gen1": {
                return Gen1TechnicalMachines.getTm(move);
            }
        }
        return null;
    }

    public static ITechnicalMove[] getAllFor(String name) {
        switch (name) {
            case "tr8": 
            case "tr_gen8": {
                return Gen8TechnicalRecords.values();
            }
            case "tm8": 
            case "tm_gen8": {
                return Gen8TechnicalMachines.values();
            }
            case "tm_gen7": {
                return Gen7TechnicalMachines.values();
            }
            case "tm_gen6": {
                return Gen6TechnicalMachines.values();
            }
            case "tm_gen5": {
                return Gen5TechnicalMachines.values();
            }
            case "tm_gen4": {
                return Gen4TechnicalMachines.values();
            }
            case "tm_gen3": {
                return Gen3TechnicalMachines.values();
            }
            case "tm_gen2": {
                return Gen2TechnicalMachines.values();
            }
            case "tm_gen1": {
                return Gen1TechnicalMachines.values();
            }
        }
        return null;
    }

    public Map<EnumType, List<ITechnicalMove>> getTypeMap();

    public static List<ITechnicalMove> getForType(ITechnicalMove group, EnumType type) {
        return group.getTypeMap().getOrDefault(type, new ArrayList());
    }

    public static Map<EnumType, List<ITechnicalMove>> getTypeMapFor(ITechnicalMove group) {
        return group.getTypeMap();
    }

    public static void mapToTypes() {
        ITechnicalMove[][] values;
        for (ITechnicalMove[] group : values = new ITechnicalMove[][]{Gen1TechnicalMachines.values(), Gen2TechnicalMachines.values(), Gen3TechnicalMachines.values(), Gen4TechnicalMachines.values(), Gen5TechnicalMachines.values(), Gen6TechnicalMachines.values(), Gen7TechnicalMachines.values(), Gen8TechnicalMachines.values(), Gen8TechnicalRecords.values()}) {
            Map<EnumType, List<ITechnicalMove>> map = ITechnicalMove.getTypeMapFor(group[0]);
            for (EnumType type : EnumType.values()) {
                map.put(type, new ArrayList());
            }
            for (ITechnicalMove tm : group) {
                map.get(tm.getAttack().getAttackType()).add(tm);
            }
        }
    }

    public static class Adapter
    implements JsonDeserializer<ITechnicalMove>,
    JsonSerializer<ITechnicalMove> {
        public JsonElement serialize(ITechnicalMove src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.getAttackName());
        }

        public ITechnicalMove deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ITechnicalMove move;
            if (typeOfT == Gen8TechnicalMachines.class) {
                move = Gen8TechnicalMachines.nameMap.get(json.getAsString());
            } else if (typeOfT == Gen8TechnicalRecords.class) {
                move = Gen8TechnicalRecords.nameMap.get(json.getAsString());
            } else if (typeOfT == Gen7TechnicalMachines.class) {
                move = Gen7TechnicalMachines.nameMap.get(json.getAsString());
            } else if (typeOfT == Gen6TechnicalMachines.class) {
                move = Gen6TechnicalMachines.nameMap.get(json.getAsString());
            } else if (typeOfT == Gen5TechnicalMachines.class) {
                move = Gen5TechnicalMachines.nameMap.get(json.getAsString());
            } else if (typeOfT == Gen4TechnicalMachines.class) {
                move = Gen4TechnicalMachines.nameMap.get(json.getAsString());
            } else if (typeOfT == Gen3TechnicalMachines.class) {
                move = Gen3TechnicalMachines.nameMap.get(json.getAsString());
            } else if (typeOfT == Gen2TechnicalMachines.class) {
                move = Gen2TechnicalMachines.nameMap.get(json.getAsString());
            } else if (typeOfT == Gen1TechnicalMachines.class) {
                move = Gen1TechnicalMachines.nameMap.get(json.getAsString());
            } else {
                throw new RuntimeException("Technical record subclass not programed for serialization");
            }
            if (move == null) {
                throw new RuntimeException("Invalid move name when deserializing: " + json.getAsString() + " from " + typeOfT.getTypeName().substring(typeOfT.getTypeName().lastIndexOf(".") + 1));
            }
            return move;
        }
    }
}

