/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.config.PixelmonCreativeTabs;
import com.pixelmonmod.pixelmon.enums.technicalmoves.ITechnicalMove;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTechnicalMove
extends PixelmonItem {
    private static final IItemPropertyGetter TYPE_GETTER = new IItemPropertyGetter(){

        @SideOnly(value=Side.CLIENT)
        public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
            ITechnicalMove move = ItemTechnicalMove.getMove(stack);
            if (move == null) {
                return 0.0f;
            }
            return move.getAttack().getAttackType().getIndex();
        }
    };
    private final String prefix;

    public ItemTechnicalMove(String prefix) {
        super(prefix);
        this.prefix = prefix;
        this.func_77627_a(true);
        this.func_77637_a(PixelmonCreativeTabs.tms);
        this.func_185043_a(new ResourceLocation("pixelmon", "move_type"), TYPE_GETTER);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K) {
            if (ItemTechnicalMove.getMove(stack) == null) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74777_a("tm", (short)stack.func_77952_i());
                if (ItemTechnicalMove.getMove(stack) == null) {
                    stack.func_77978_p().func_74777_a("tm", (short)RandomHelper.getRandomElementFromArray(ITechnicalMove.getAllFor(this.prefix)).getId());
                }
            }
            if (stack.func_77952_i() != 0) {
                stack.func_77964_b(0);
            }
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public int getMetadata(ItemStack stack) {
        return stack.func_77942_o() ? (int)stack.func_77978_p().func_74765_d("tm") : -1;
    }

    public String func_77667_c(ItemStack stack) {
        ITechnicalMove technicalMove = ItemTechnicalMove.getMove(stack);
        if (technicalMove == null) {
            return super.func_77667_c(stack);
        }
        return "item." + this.prefix + "." + technicalMove.getId();
    }

    @Override
    public String getTooltipText(ItemStack stack) {
        String ret = "";
        ITechnicalMove technicalMove = ItemTechnicalMove.getMove(stack);
        if (technicalMove == null) {
            return ret;
        }
        AttackBase ab = technicalMove.getAttack();
        if (ab == null || !ab.isAttack(technicalMove.getAttackName())) {
            return ret;
        }
        String formattedData = I18n.func_74837_a((String)"tm.movedata.tooltip", (Object[])new Object[]{"\u00a7" + String.format("#%06X", 0xFFFFFF & ab.getAttackType().getColor()) + ab.getAttackType().getLocalizedName() + TextFormatting.GRAY, ab.getBasePower() != 0 ? Integer.valueOf(ab.getBasePower()) : "-", ab.getAccuracy() != -1 ? Integer.valueOf(ab.getAccuracy()) : "-", ab.getPPBase()});
        ret = ret + formattedData;
        if (I18n.func_94522_b((String)(this.func_77658_a() + ".tooltip"))) {
            ret = ret + I18n.func_74838_a((String)(this.func_77658_a() + ".tooltip"));
        }
        return ret;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ITechnicalMove[] arr = ITechnicalMove.getAllFor(this.prefix);
            if (arr == null) {
                return;
            }
            for (ITechnicalMove move : arr) {
                ItemStack stack = new ItemStack((Item)this, 1, move.getId());
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74777_a("tm", (short)move.getId());
                items.add((Object)stack);
            }
        }
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound compound = super.getNBTShareTag(stack);
        if (compound != null && compound.func_74764_b("tm")) {
            compound.func_74768_a("tm", (int)compound.func_74765_d("tm"));
        }
        return compound;
    }

    public String type() {
        return this.prefix;
    }

    @Nullable
    public static ITechnicalMove getMove(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemTechnicalMove && stack.func_77942_o()) {
            short id = stack.func_77978_p().func_74765_d("tm");
            return ITechnicalMove.getMoveFor(((ItemTechnicalMove)stack.func_77973_b()).prefix, id);
        }
        return null;
    }

    @Nullable
    public static ITechnicalMove getInstanceOf(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemTechnicalMove) {
            return ITechnicalMove.getMoveFor(((ItemTechnicalMove)stack.func_77973_b()).prefix, 0);
        }
        return null;
    }
}

