/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.enums.TextJustification;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemUIElement
extends PixelmonItem {
    public static final String BAKE_MODEL = "UIBakeModel";
    public static final String IMAGE = "UIImage";
    public static final String HOVER = "UIHoverImage";
    public static final String TEXT = "UIText";
    public static final String HOVER_TEXT = "UIHoverText";
    public static final String TEXT_JUSTIFICATION = "UITextJustification";
    public static final String TEXT_SCALE = "UITextScale";
    public static final String X_OFFSET = "UIXOffset";
    public static final String Y_OFFSET = "UIYOffset";
    public static final String X_OVERRIDE = "UIXOverride";
    public static final String Y_OVERRIDE = "UIYOverride";
    public static final String Z_LEVEL = "UIZLevel";
    public static final String IMAGE_WIDTH = "UIImageWidth";
    public static final String IMAGE_HEIGHT = "UIImageHeight";
    public static final String TEX_WIDTH = "UITexWidth";
    public static final String TEX_HEIGHT = "UITexHeight";
    public static final String IMAGE_U = "UIImageU";
    public static final String IMAGE_V = "UIImageV";
    public static final String R = "UIImageR";
    public static final String G = "UIImageG";
    public static final String B = "UIImageB";
    public static final String A = "UIImageA";
    public static final String HR = "UIImageHR";
    public static final String HG = "UIImageHG";
    public static final String HB = "UIImageHB";
    public static final String HA = "UIImageHA";

    public ItemUIElement() {
        super("ui_element");
        this.func_77625_d(Integer.MAX_VALUE);
        this.func_77656_e(Integer.MAX_VALUE);
        this.func_77637_a(null);
    }

    public static Builder builder() {
        return new Builder(new ItemStack(PixelmonItems.uiElement));
    }

    public static Builder builder(ItemStack stack) {
        return new Builder(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBakedModel(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(BAKE_MODEL)) {
            return false;
        }
        return tag.func_74767_n(BAKE_MODEL);
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<ResourceLocation> getImage(ItemStack stack, boolean hover) {
        return hover ? ItemUIElement.getHoverImage(stack) : ItemUIElement.getImage(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<ResourceLocation> getImage(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(IMAGE)) {
            return Optional.empty();
        }
        ResourceLocation rl = new ResourceLocation(tag.func_74779_i(IMAGE));
        return Optional.of(rl);
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<ResourceLocation> getHoverImage(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(HOVER)) {
            return ItemUIElement.getImage(stack);
        }
        ResourceLocation rl = new ResourceLocation(tag.func_74779_i(HOVER));
        return Optional.of(rl);
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<Integer> getXOffset(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(X_OFFSET)) {
            return Optional.empty();
        }
        return Optional.of(tag.func_74762_e(X_OFFSET));
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<Integer> getYOffset(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(Y_OFFSET)) {
            return Optional.empty();
        }
        return Optional.of(tag.func_74762_e(Y_OFFSET));
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<Integer> getXOverride(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(X_OVERRIDE)) {
            return Optional.empty();
        }
        return Optional.of(tag.func_74762_e(X_OVERRIDE));
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<Integer> getYOverride(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(Y_OVERRIDE)) {
            return Optional.empty();
        }
        return Optional.of(tag.func_74762_e(Y_OVERRIDE));
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<Integer> getZLevel(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(Z_LEVEL)) {
            return Optional.empty();
        }
        return Optional.of(tag.func_74762_e(Z_LEVEL));
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<Integer> getImageWidth(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(IMAGE_WIDTH)) {
            return Optional.empty();
        }
        return Optional.of(tag.func_74762_e(IMAGE_WIDTH));
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<Integer> getImageHeight(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(IMAGE_HEIGHT)) {
            return Optional.empty();
        }
        return Optional.of(tag.func_74762_e(IMAGE_HEIGHT));
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<Float> getTextureWidth(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(TEX_WIDTH)) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(tag.func_74760_g(TEX_WIDTH)));
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<Float> getTextureHeight(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(TEX_HEIGHT)) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(tag.func_74760_g(TEX_HEIGHT)));
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<Float> getImageU(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(IMAGE_U)) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(tag.func_74760_g(IMAGE_U)));
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<Float> getImageV(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(IMAGE_V)) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(tag.func_74760_g(IMAGE_V)));
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<float[]> getColor(ItemStack stack, boolean hover) {
        return hover ? ItemUIElement.getHoverColor(stack) : ItemUIElement.getColor(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<float[]> getColor(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(R)) {
            return Optional.empty();
        }
        return Optional.of(new float[]{tag.func_74760_g(R), tag.func_74760_g(G), tag.func_74760_g(B), tag.func_74760_g(A)});
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<float[]> getHoverColor(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(HR)) {
            return ItemUIElement.getColor(stack);
        }
        return Optional.of(new float[]{tag.func_74760_g(HR), tag.func_74760_g(HG), tag.func_74760_g(HB), tag.func_74760_g(HA)});
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<String> getText(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(TEXT)) {
            return Optional.empty();
        }
        return Optional.of(tag.func_74779_i(TEXT));
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<String> getHoverText(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(HOVER_TEXT)) {
            return ItemUIElement.getText(stack);
        }
        return Optional.of(tag.func_74779_i(HOVER_TEXT));
    }

    @SideOnly(value=Side.CLIENT)
    public static Optional<String> getText(ItemStack stack, boolean hover) {
        return hover ? ItemUIElement.getHoverText(stack) : ItemUIElement.getText(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public static TextJustification getTextJustification(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(TEXT_JUSTIFICATION)) {
            return TextJustification.RIGHT;
        }
        return TextJustification.get(tag.func_74765_d(TEXT_JUSTIFICATION));
    }

    @SideOnly(value=Side.CLIENT)
    public static short getTextScale(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b(TEXT_SCALE)) {
            return 12;
        }
        return tag.func_74765_d(TEXT_SCALE);
    }

    public static class Builder {
        private final ItemStack stack;

        private Builder(ItemStack stack) {
            this.stack = stack;
            if (!this.stack.func_77942_o()) {
                this.stack.func_77982_d(new NBTTagCompound());
            }
        }

        public Builder setBakeModel(boolean bakeModel) {
            this.stack.func_77978_p().func_74757_a(ItemUIElement.BAKE_MODEL, bakeModel);
            return this;
        }

        public Builder setImage(String image) {
            this.stack.func_77978_p().func_74778_a(ItemUIElement.IMAGE, image);
            return this;
        }

        public Builder setHoverImage(String image) {
            this.stack.func_77978_p().func_74778_a(ItemUIElement.HOVER, image);
            return this;
        }

        public Builder setText(String text) {
            this.stack.func_77978_p().func_74778_a(ItemUIElement.TEXT, text);
            return this;
        }

        public Builder setHoverText(String text) {
            this.stack.func_77978_p().func_74778_a(ItemUIElement.HOVER_TEXT, text);
            return this;
        }

        public Builder setTextJustification(TextJustification justification) {
            this.stack.func_77978_p().func_74777_a(ItemUIElement.TEXT_JUSTIFICATION, (short)(justification.ordinal() - 1));
            return this;
        }

        public Builder setTextScale(float scale) {
            this.stack.func_77978_p().func_74776_a(ItemUIElement.TEXT_SCALE, scale);
            return this;
        }

        public Builder setPosOffset(int x, int y) {
            this.stack.func_77978_p().func_74768_a(ItemUIElement.X_OFFSET, x);
            this.stack.func_77978_p().func_74768_a(ItemUIElement.Y_OFFSET, y);
            return this;
        }

        public Builder setPosOverride(int x, int y) {
            this.stack.func_77978_p().func_74768_a(ItemUIElement.X_OVERRIDE, x);
            this.stack.func_77978_p().func_74768_a(ItemUIElement.Y_OVERRIDE, y);
            return this;
        }

        public Builder setZLevel(int zLevel) {
            this.stack.func_77978_p().func_74768_a(ItemUIElement.Z_LEVEL, zLevel);
            return this;
        }

        public Builder setSize(int w, int h) {
            this.stack.func_77978_p().func_74768_a(ItemUIElement.IMAGE_WIDTH, w);
            this.stack.func_77978_p().func_74768_a(ItemUIElement.IMAGE_HEIGHT, h);
            return this;
        }

        public Builder setTextureSize(float w, float h) {
            this.stack.func_77978_p().func_74776_a(ItemUIElement.TEX_WIDTH, w);
            this.stack.func_77978_p().func_74776_a(ItemUIElement.TEX_HEIGHT, h);
            return this;
        }

        public Builder setUV(float u, float v) {
            this.stack.func_77978_p().func_74776_a(ItemUIElement.IMAGE_U, u);
            this.stack.func_77978_p().func_74776_a(ItemUIElement.IMAGE_V, v);
            return this;
        }

        public Builder setColor(int r, int g, int b, int a) {
            return this.setColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
        }

        public Builder setColor(float r, float g, float b, float a) {
            this.stack.func_77978_p().func_74776_a(ItemUIElement.R, r);
            this.stack.func_77978_p().func_74776_a(ItemUIElement.G, g);
            this.stack.func_77978_p().func_74776_a(ItemUIElement.B, b);
            this.stack.func_77978_p().func_74776_a(ItemUIElement.A, a);
            return this;
        }

        public Builder setHoverColor(int r, int g, int b, int a) {
            return this.setHoverColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
        }

        public Builder setHoverColor(float r, float g, float b, float a) {
            this.stack.func_77978_p().func_74776_a(ItemUIElement.HR, r);
            this.stack.func_77978_p().func_74776_a(ItemUIElement.HG, g);
            this.stack.func_77978_p().func_74776_a(ItemUIElement.HB, b);
            this.stack.func_77978_p().func_74776_a(ItemUIElement.HA, a);
            return this;
        }

        public ItemStack build() {
            return this.stack;
        }
    }
}

