/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Gluttony;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Ripen;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumBerry;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumBerryStatIncrease;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.heldItems.ItemBerry;

public class ItemBerryStatIncrease
extends ItemBerry {
    public EnumBerryStatIncrease berryType;
    private StatsType stat;

    public ItemBerryStatIncrease(EnumBerryStatIncrease berryType, EnumBerry berry, String itemName, StatsType stat) {
        super(EnumHeldItems.berryStatIncrease, berry, itemName);
        this.berryType = berryType;
        this.stat = stat;
    }

    @Override
    public void tookDamage(PixelmonWrapper attacker, PixelmonWrapper defender, float damage, DamageTypeEnum damageType) {
        int lowHealth;
        int n = lowHealth = defender.getBattleAbility() instanceof Gluttony ? 50 : 25;
        if (defender.isAlive() && defender.getHealthPercent() <= (float)lowHealth) {
            this.eatBerry(defender);
        }
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        if (newPokemon.getHealthPercent() <= 25.0f) {
            this.eatBerry(newPokemon);
        }
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        this.applySwitchInEffect(pw);
    }

    @Override
    public void eatBerry(PixelmonWrapper pokemon) {
        if (ItemBerryStatIncrease.canEatBerry(pokemon)) {
            boolean ripened = pokemon.getBattleAbility().isAbility((Class<? extends AbilityBase>)Ripen.class);
            pokemon.bc.sendToAll("pixelmon.helditems.pinchberry", pokemon.getNickname(), pokemon.getHeldItem().getLocalizedName());
            if (this.stat != null) {
                pokemon.getBattleStats().modifyStat(ripened ? 2 : 1, this.stat);
            } else if (this.berryType == EnumBerryStatIncrease.starfBerry) {
                pokemon.getBattleStats().raiseRandomStat(ripened ? 4 : 2);
            } else if (this.berryType == EnumBerryStatIncrease.lansatBerry) {
                pokemon.getBattleStats().increaseCritStage(ripened ? 4 : 2, false);
            }
            if (ripened) {
                pokemon.bc.sendToAll("pixelmon.abilities.ripen", pokemon.getNickname(), this.getLocalizedName());
            }
            super.eatBerry(pokemon);
            pokemon.consumeItem();
        }
    }
}

