/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.actions.actions;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreen;
import com.pixelmonmod.pixelmon.enums.EnumFeatureState;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.actions.IAction;
import com.pixelmonmod.pixelmon.quests.editor.QuestElement;
import com.pixelmonmod.pixelmon.quests.editor.QuestElementType;
import com.pixelmonmod.pixelmon.quests.editor.args.ArgumentType;
import com.pixelmonmod.pixelmon.quests.editor.args.QuestElementArgument;
import com.pixelmonmod.pixelmon.quests.quest.ArgsIn;
import com.pixelmonmod.pixelmon.quests.quest.Argument;
import com.pixelmonmod.pixelmon.quests.quest.Arguments;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class KeyItemAction
implements IAction {
    private final boolean isTake;

    public KeyItemAction(boolean isTake) {
        this.isTake = isTake;
    }

    @Override
    public String identifier() {
        return this.isTake ? "TAKE_KEY_ITEM" : "KEY_ITEM";
    }

    @Override
    public QuestElement getStructure() {
        return new QuestElement(QuestElementType.ACTION, this.identifier(), new QuestElementArgument("key_item", false, false, ArgumentType.TEXT, "MegaRing", "DynamaxBand", "OvalCharm", "ShinyCharm", "ExpCharm", "CatchingCharm", "MarkCharm"));
    }

    @Override
    public Arguments parse(Quest quest, Stage stage, ArgsIn args) {
        return Arguments.create(Argument.from(args.get(0), KeyItem::getKeyItem));
    }

    @Override
    public void execute(Quest quest, Stage stage, QuestData data, QuestProgress progress, Arguments arguments) {
        KeyItem item = (KeyItem)((Object)arguments.value(0, progress));
        if (item != null) {
            item.action(data.getPlayer(), this.isTake);
        }
    }

    static enum KeyItem {
        MegaRing,
        DynamaxBand,
        OvalCharm,
        ShinyCharm,
        ExpCharm,
        CatchingCharm,
        MarkCharm;


        public static KeyItem getKeyItem(String name) {
            for (KeyItem item : KeyItem.values()) {
                if (!item.name().equalsIgnoreCase(name)) continue;
                return item;
            }
            return null;
        }

        public void action(EntityPlayerMP player, boolean isTake) {
            PlayerPartyStorage pps = Pixelmon.storageManager.getParty(player);
            switch (this) {
                case MegaRing: {
                    if (isTake) {
                        pps.lockMega();
                        break;
                    }
                    pps.unlockMega();
                    break;
                }
                case DynamaxBand: {
                    if (isTake) {
                        pps.lockDynamax();
                        break;
                    }
                    pps.unlockDynamax();
                    break;
                }
                case OvalCharm: {
                    if (isTake) {
                        pps.setOvalCharm(EnumFeatureState.Disabled);
                        break;
                    }
                    pps.setOvalCharm(EnumFeatureState.Active);
                    OpenScreen.open((EntityPlayer)pps.getPlayer(), EnumGuiScreen.OvalCharm, new int[0]);
                    break;
                }
                case ShinyCharm: {
                    if (isTake) {
                        pps.setShinyCharm(EnumFeatureState.Disabled);
                        break;
                    }
                    pps.setShinyCharm(EnumFeatureState.Active);
                    OpenScreen.open((EntityPlayer)pps.getPlayer(), EnumGuiScreen.ShinyCharm, new int[0]);
                    break;
                }
                case ExpCharm: {
                    if (isTake) {
                        pps.setExpCharm(EnumFeatureState.Disabled);
                        break;
                    }
                    pps.setExpCharm(EnumFeatureState.Active);
                    OpenScreen.open((EntityPlayer)pps.getPlayer(), EnumGuiScreen.ExpCharm, new int[0]);
                    break;
                }
                case CatchingCharm: {
                    if (isTake) {
                        pps.setCatchingCharm(EnumFeatureState.Disabled);
                        break;
                    }
                    pps.setCatchingCharm(EnumFeatureState.Active);
                    OpenScreen.open((EntityPlayer)pps.getPlayer(), EnumGuiScreen.CatchingCharm, new int[0]);
                    break;
                }
                case MarkCharm: {
                    if (isTake) {
                        pps.setMarkCharm(EnumFeatureState.Disabled);
                        break;
                    }
                    pps.setMarkCharm(EnumFeatureState.Active);
                    OpenScreen.open((EntityPlayer)pps.getPlayer(), EnumGuiScreen.MarkCharm, new int[0]);
                }
            }
        }
    }
}

