/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.editor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.quests.client.editor.GuiQuestOverview;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestEditorState;
import com.pixelmonmod.pixelmon.quests.client.editor.ui.GuiListQuestEditor;
import com.pixelmonmod.pixelmon.quests.client.editor.ui.GuiSimpleButton;
import com.pixelmonmod.pixelmon.quests.client.editor.ui.GuiTextField;
import com.pixelmonmod.pixelmon.quests.comm.editor.ReloadQuestData;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GuiQuestEditor
extends GuiScreen {
    private List<GuiSimpleButton> buttons = new ArrayList<GuiSimpleButton>();
    private GuiListQuestEditor questList;
    private GuiTextField newQuest;
    private boolean canMakeQuest = false;
    private String madeQuest = "";
    private Quest selected = null;
    int prevWidth = -1;
    int prevHeight = -1;

    public GuiQuestEditor() {
    }

    public GuiQuestEditor(Quest selected) {
        this.selected = selected;
    }

    public void addButtons() {
        this.buttons.clear();
        int x = this.field_146294_l / 2 - 125;
        int y = this.field_146295_m / 2 - 100;
        int buttonS = 14;
        this.buttons.add(new GuiSimpleButton(0, x + 4, y + 6, 12, GuiResources.refresh, 2, 2, -5635841));
    }

    public void func_73866_w_() {
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int gap = 3;
        int x = this.field_146294_l / 2 - 125;
        int y = this.field_146295_m / 2 - 100;
        int newQuestY = y + dispHeight - 35 + 7;
        this.questList = new GuiListQuestEditor(this.field_146297_k.field_71466_p, x + 7, y + 23, 104, 9);
        this.questList.setFocused(true);
        this.newQuest = new GuiTextField(this.field_146297_k.field_71466_p, x + 1, newQuestY + 4, 95, 20, -6908266, -7895161);
        this.newQuest.setTextColor(14889216);
        this.refreshQuests();
        if (this.selected != null) {
            boolean found = false;
            for (Quest quest : QuestEditorState.get().getAllQuests()) {
                if (!quest.getPrintableName().equalsIgnoreCase(this.selected.getPrintableName())) continue;
                this.selected = quest;
                found = true;
                break;
            }
            if (found) {
                int lineindex = this.questList.lines.indexOf(this.selected);
                this.questList.selectQuest(lineindex);
                if (lineindex >= 0 && lineindex < this.questList.lines.size()) {
                    QuestEditorState.get().selectQuest(this.questList.lines.get(lineindex));
                } else {
                    QuestEditorState.get().selectQuest(null);
                }
            }
            this.selected = null;
        }
        this.addButtons();
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        int qlh;
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179112_b((int)770, (int)771);
        super.func_73863_a(mouseX, mouseY, f);
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.backgroundTexture);
        int gap = 3;
        int x = this.field_146294_l / 2 - 125;
        int y = this.field_146295_m / 2 - 100;
        int div = 2 * gap;
        int border = 25;
        int lowerBorder = dispHeight - border - div;
        this.questList.height = qlh = 132;
        this.questList.displayLines = (int)(9.0f * ((float)qlh / (float)(lowerBorder - border - 12)));
        int newQuestGap = 35;
        Gui.func_146110_a((int)(x + dispWidth / 2 + gap + 1), (int)y, (float)0.0f, (float)0.0f, (int)(dispWidth / 2), (int)dispHeight, (float)((float)dispWidth / 2.0f), (float)dispHeight);
        Gui.func_146110_a((int)(x - gap), (int)y, (float)0.0f, (float)0.0f, (int)(dispWidth / 2), (int)(dispHeight - newQuestGap), (float)((float)dispWidth / 2.0f), (float)(dispHeight - newQuestGap));
        int newQuestY = y + dispHeight - newQuestGap + 7;
        Gui.func_146110_a((int)(x - gap), (int)newQuestY, (float)0.0f, (float)0.0f, (int)(dispWidth / 2), (int)(dispHeight - (dispHeight - newQuestGap) - 7), (float)((float)dispWidth / 2.0f), (float)(dispHeight - 30));
        String textA = TextFormatting.BOLD + I18n.func_135052_a((String)"gui.questeditor.title", (Object[])new Object[0]);
        this.field_146289_q.func_175065_a(textA, (float)(x - gap) + (float)dispWidth / 4.0f - (float)this.field_146289_q.func_78256_a(textA) / 2.0f, (float)y + 8.5f, 0xFFFFFF, true);
        this.questList.drawBackground();
        this.questList.drawText();
        this.newQuest.drawTextBox();
        float titleBorder = 8.5f;
        if (QuestEditorState.get().hasQuestSelected()) {
            Quest selectedQuest = QuestEditorState.get().getSelectedQuest();
            String title = selectedQuest.getPrintableName();
            int width = (int)((float)dispWidth / 2.0f - 9.0f);
            int strWidth = this.field_146289_q.func_78256_a(title);
            double wf = 95.0;
            double finalWidth = Math.min((double)strWidth, wf - 6.0);
            GuiHelper.drawSquashedString(this.field_146289_q, title, false, wf, (int)((double)((float)(x + gap) + (float)dispWidth / 4.0f * 3.0f) - finalWidth / 2.0 + 6.0), (int)((float)y + titleBorder), 0xFFFFFF, true);
            this.field_146297_k.field_71446_o.func_110577_a(selectedQuest.getStages().get(selectedQuest.getStages().size() - 1).getStage() == selectedQuest.getActiveStage() ? GuiResources.question_mark : GuiResources.exclamation_mark);
            QuestColor color = selectedQuest.getColor();
            GlStateManager.func_179131_c((float)color.floatR(), (float)color.floatG(), (float)color.floatB(), (float)1.0f);
            Gui.func_146110_a((int)((int)((double)((float)(x + gap) + (float)dispWidth / 4.0f * 3.0f) - finalWidth / 2.0) - 11), (int)((int)((float)y + titleBorder) - 4), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
            for (int i = 0; i < 4; ++i) {
                int buttonW = 50;
                int buttonH = 30;
                int buttonX = x + (int)((float)dispWidth / 4.0f * 3.0f) + gap + 1 - buttonW / 2;
                int buttonY = y + 30 + i * 42;
                String text = "";
                switch (i) {
                    case 0: {
                        GuiQuestEditor.func_73734_a((int)buttonX, (int)buttonY, (int)(buttonX + buttonW), (int)(buttonY + buttonH), (int)-16727066);
                        text = I18n.func_135052_a((String)"gui.questeditor.edit", (Object[])new Object[0]);
                        break;
                    }
                    case 1: {
                        GuiQuestEditor.func_73734_a((int)buttonX, (int)buttonY, (int)(buttonX + buttonW), (int)(buttonY + buttonH), (int)-10263709);
                        text = I18n.func_135052_a((String)"gui.questeditor.test", (Object[])new Object[0]);
                        break;
                    }
                    case 2: {
                        GuiQuestEditor.func_73734_a((int)buttonX, (int)buttonY, (int)(buttonX + buttonW), (int)(buttonY + buttonH), (int)-6029082);
                        text = I18n.func_135052_a((String)"gui.questeditor.clone", (Object[])new Object[0]);
                        break;
                    }
                    case 3: {
                        GuiQuestEditor.func_73734_a((int)buttonX, (int)buttonY, (int)(buttonX + buttonW), (int)(buttonY + buttonH), (int)-2424803);
                        text = I18n.func_135052_a((String)"gui.questeditor.delete", (Object[])new Object[0]);
                    }
                }
                int textWidth = this.field_146289_q.func_78256_a(text);
                GuiHelper.drawSquashedString(this.field_146289_q, text, false, wf, (int)((float)buttonX - (float)textWidth / 2.0f + (float)buttonW / 2.0f), (int)((float)(buttonY - 4) + (float)buttonH / 2.0f), 0xFFFFFF, true);
            }
        } else {
            String title = I18n.func_135052_a((String)"gui.questeditor.noselection", (Object[])new Object[0]);
            int strWidth = this.field_146289_q.func_78256_a(title);
            GuiHelper.drawSquashedString(this.field_146289_q, title, false, strWidth, (int)((float)(x + gap) + (float)dispWidth / 4.0f * 3.0f - (float)strWidth / 2.0f), (int)((float)y + titleBorder), 0xFFFFFF, true);
        }
        int addQuestX = x + 104;
        int addQuestY = y + dispHeight - 19;
        int size = 10;
        GuiQuestEditor.func_73734_a((int)addQuestX, (int)addQuestY, (int)(addQuestX + size), (int)(addQuestY + size), (int)(this.canMakeQuest ? -16724221 : -10066330));
        this.field_146289_q.func_175065_a("+", (float)addQuestX + (float)size / 2.0f - 2.5f, (float)addQuestY + (float)size / 2.0f - 3.5f, 0xFFFFFF, false);
        for (GuiSimpleButton button : this.buttons) {
            button.draw();
        }
        this.checkMouseWheel();
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        Quest clickedOnQuest;
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int gap = 3;
        int x = this.field_146294_l / 2 - 125;
        int y = this.field_146295_m / 2 - 100;
        int div = 2 * gap;
        int border = 25;
        int lowerBorder = dispHeight - border - div;
        float v = (float)(x + gap * 3) + 3.0f * (float)dispWidth / 4.0f;
        int sliderSpeed = 5;
        if (this.canMakeQuest) {
            int addQuestX = x + 104;
            int addQuestY = y + dispHeight - 19;
            int size = 10;
            if (mouseX >= addQuestX && mouseX <= addQuestX + size && mouseY >= addQuestY && mouseY <= addQuestY + size) {
                String questName;
                this.madeQuest = questName = this.newQuest.getText() + ".json";
                QuestEditorState.get().push(questName, new Quest(questName), false);
                this.canMakeQuest = false;
            }
        }
        if (QuestEditorState.get().hasQuestSelected()) {
            Quest selectedQuest = QuestEditorState.get().getSelectedQuest();
            block6: for (int i = 0; i < 4; ++i) {
                int buttonW = 50;
                int buttonH = 30;
                int buttonX = x + (int)((float)dispWidth / 4.0f * 3.0f) + gap + 1 - buttonW / 2;
                int buttonY = y + 30 + i * 42;
                if (mouseX < buttonX || mouseX > buttonX + buttonW || mouseY < buttonY || mouseY > buttonY + buttonH) continue;
                switch (i) {
                    case 0: {
                        this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestOverview());
                        continue block6;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        StringBuilder copy = new StringBuilder("Copy");
                        while (QuestEditorState.get().hasQuest(selectedQuest.getPrintableName() + " " + copy.toString())) {
                            copy.append(" Copy");
                        }
                        Quest newQuest = new Quest(selectedQuest, selectedQuest.getPrintableName() + " " + copy.toString() + ".json");
                        this.madeQuest = newQuest.getFilename();
                        QuestEditorState.get().push(newQuest.getFilename(), newQuest, false);
                        continue block6;
                    }
                    case 3: {
                        QuestEditorState.get().delete(selectedQuest);
                    }
                }
            }
        }
        if ((clickedOnQuest = this.questList.mouseClicked(mouseX, mouseY, 0, this.questList.yPos + 8)) != null) {
            int lineindex = this.questList.lines.indexOf(clickedOnQuest);
            this.questList.selectQuest(lineindex);
            if (lineindex >= 0 && lineindex < this.questList.lines.size()) {
                QuestEditorState.get().selectQuest(this.questList.lines.get(lineindex));
            } else {
                QuestEditorState.get().selectQuest(null);
            }
        }
        int id = -1;
        for (GuiSimpleButton button : this.buttons) {
            if (!button.isEnabled() || !button.isWithin(mouseX, mouseY)) continue;
            id = button.id;
            break;
        }
        if (id == 0) {
            Pixelmon.network.sendToServer((IMessage)new ReloadQuestData());
        }
        this.newQuest.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void func_73869_a(char c, int i) {
        block3: {
            try {
                super.func_73869_a(c, i);
            }
            catch (IOException e) {
                if (!Pixelmon.devEnvironment) break block3;
                Pixelmon.LOGGER.error(e.getLocalizedMessage());
            }
        }
        if (this.newQuest.isFocused() && this.newQuest.textboxKeyTyped(c, i)) {
            this.updateNewQuestBox();
        }
    }

    public void updateNewQuestBox() {
        this.refreshQuests();
        if (this.newQuest.getText().isEmpty()) {
            this.newQuest.setTextColor(14889216);
            this.canMakeQuest = false;
            return;
        }
        String filename = this.newQuest.getText().replace(" ", "_");
        for (Quest quest : QuestEditorState.get().getAllQuests()) {
            if (!quest.getIdentityName().equalsIgnoreCase(filename)) continue;
            this.newQuest.setTextColor(14889216);
            this.canMakeQuest = false;
            return;
        }
        this.newQuest.setTextColor(Color.WHITE.getRGB());
        this.canMakeQuest = true;
    }

    public void refreshQuests() {
        int size = this.questList.lines.size();
        this.questList.lines.clear();
        for (Quest quest : QuestEditorState.get().getAllQuests()) {
            this.questList.addLine(quest);
        }
        this.questList.sort(this.newQuest.getText());
        if (size > this.questList.lines.size()) {
            this.questList.selectQuest(-1);
            QuestEditorState.get().selectQuest(null);
        }
        if (!this.madeQuest.isEmpty()) {
            int i = 0;
            for (Quest quest : this.questList.lines) {
                if (quest.getFilename().equalsIgnoreCase(this.madeQuest)) {
                    QuestEditorState.get().selectQuest(quest);
                    this.questList.selectQuest(i);
                    break;
                }
                ++i;
            }
            this.madeQuest = "";
        }
        if (Math.abs(size - this.questList.lines.size()) > 1) {
            this.questList.startLine = 0;
        }
    }

    private void checkMouseWheel() {
        int mousewheelDirection = Mouse.getDWheel();
        if (mousewheelDirection == 120) {
            if (this.questList.isFocused) {
                this.questList.scrollDown();
            }
        } else if (mousewheelDirection == -120 && this.questList.isFocused) {
            this.questList.scrollUp();
        }
    }

    public void func_73876_c() {
        if (QuestEditorState.get().isDirty()) {
            this.refreshQuests();
            this.updateNewQuestBox();
        }
        if (this.prevWidth != -1 && this.prevHeight != -1 && (this.field_146294_l != this.prevWidth || this.field_146295_m != this.prevHeight)) {
            this.addButtons();
        }
        this.prevWidth = this.field_146294_l;
        this.prevHeight = this.field_146295_m;
    }
}

