/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.editor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.quests.client.editor.GuiQuestEditor;
import com.pixelmonmod.pixelmon.quests.client.editor.GuiQuestStage;
import com.pixelmonmod.pixelmon.quests.client.editor.GuiQuestStrings;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestEditorState;
import com.pixelmonmod.pixelmon.quests.client.editor.ui.GuiSimpleButton;
import com.pixelmonmod.pixelmon.quests.client.editor.ui.GuiTextField;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.util.helpers.CursorHelper;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Mouse;

public class GuiQuestOverview
extends GuiScreen {
    private List<GuiSimpleButton> buttons = new ArrayList<GuiSimpleButton>();
    private GuiTextField questName;
    private String oldName;
    private int globalQuestOption = -1;
    private MouseState mouseState = MouseState.HOVER;
    private Stage draggedStage = null;
    private Stage hoverStage = null;
    private int ticker = 0;
    private final int[] addStageButtonLoc = new int[]{0, 0, 0, 0};
    private boolean changingHue = false;
    private boolean changingColor = false;
    private float[] hsb = null;
    private int hoveringColor = -1;
    private boolean reload = false;

    public GuiQuestOverview() {
        this.oldName = QuestEditorState.get().getSelectedQuest().getFilename();
    }

    public void func_73866_w_() {
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int gap = 3;
        int x = this.field_146294_l / 2 - 125;
        int y = this.field_146295_m / 2 - 100;
        float titleBorder = 5.5f;
        this.questName = new GuiTextField(this.field_146297_k.field_71466_p, (int)((float)(x + gap) + (float)dispWidth / 2.0f) - 23, (int)((float)y + titleBorder), 115, 14, -6908266, -7895161);
        this.questName.setTextColor(Color.WHITE.getRGB());
        Quest quest = QuestEditorState.get().getSelectedQuest();
        if (quest != null) {
            this.questName.setText(quest.getPrintableName());
        }
        this.addButtons();
    }

    public void addButtons() {
        this.buttons.clear();
        int x = this.field_146294_l / 2 - 125;
        int y = this.field_146295_m / 2 - 100;
        int id = 0;
        int buttonS = 14;
        this.buttons.add(new GuiSimpleButton(id++, x + 4 + (buttonS + 6) * 0, y + 6, 12, GuiResources.back, 2, 2, -12407307));
        this.buttons.add(new GuiSimpleButton(id++, x + 4 + (buttonS + 6) * 1, y + 6, 12, GuiResources.save, 2, 2, -14300093));
        this.buttons.add(new GuiSimpleButton(id++, x + 4 + (buttonS + 6) * 2, y + 6, 12, GuiResources.discard, 2, 2, -2210481));
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        if (!QuestEditorState.get().hasQuestSelected()) {
            return;
        }
        Quest quest = QuestEditorState.get().getSelectedQuest();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179112_b((int)770, (int)771);
        super.func_73863_a(mouseX, mouseY, f);
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.backgroundTexture);
        int gap = 3;
        int x = this.field_146294_l / 2 - 125;
        int y = this.field_146295_m / 2 - 100;
        Gui.func_146110_a((int)(x - gap), (int)y, (float)0.0f, (float)0.0f, (int)(dispWidth + gap * 2 + 1), (int)dispHeight, (float)dispWidth, (float)dispHeight);
        this.drawColorPicker(dispWidth, dispHeight, mouseX, mouseY);
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179112_b((int)770, (int)771);
        float titleBorder = 8.5f;
        this.field_146297_k.field_71446_o.func_110577_a(quest.getStages().get(quest.getStages().size() - 1).getStage() == quest.getActiveStage() ? GuiResources.question_mark : GuiResources.exclamation_mark);
        QuestColor color = quest.getColor();
        GlStateManager.func_179131_c((float)color.floatR(), (float)color.floatG(), (float)color.floatB(), (float)1.0f);
        Gui.func_146110_a((int)((int)((float)(x + gap) + (float)dispWidth / 2.0f) - 41), (int)((int)((float)y + titleBorder) - 4), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        this.drawStages(x, y, mouseX, mouseY);
        float textX = (float)x + (float)dispWidth / 4.0f * 3.0f - 2.0f;
        float textY = y + 130;
        float spacing = 14.0f;
        int buttonSize = 40;
        int tickerColor = this.ticker % 200 < 100 ? 0 : 0xFFFFFF;
        GuiHelper.drawCenteredString(I18n.func_135052_a((String)"gui.questeditor.weight", (Object[])new Object[]{String.valueOf(quest.getWeight())}), textX, textY, this.globalQuestOption == 0 ? tickerColor : 0);
        GuiHelper.drawCenteredString(I18n.func_135052_a((String)(quest.isAbandonable() ? "gui.questeditor.abandonable" : "gui.questeditor.notabandonable"), (Object[])new Object[0]), textX, textY + spacing, this.globalQuestOption == 1 ? tickerColor : 0);
        GuiHelper.drawCenteredString(I18n.func_135052_a((String)(quest.isRepeatable() ? "gui.questeditor.repeatable" : "gui.questeditor.notrepeatable"), (Object[])new Object[0]), textX, textY + spacing * 2.0f, this.globalQuestOption == 2 ? tickerColor : 0);
        GuiHelper.drawCenteredString(I18n.func_135052_a((String)"gui.questeditor.edittext", (Object[])new Object[0]), textX, textY + spacing * 3.0f, this.globalQuestOption == 3 ? tickerColor : 0);
        boolean optionHovering = false;
        if ((float)mouseX >= textX - (float)buttonSize && (float)mouseX <= textX + (float)buttonSize) {
            for (int i = 0; i < 4; ++i) {
                if (!((float)mouseY >= textY + spacing * (float)i) || !((float)mouseY <= textY + spacing * (float)i + 6.0f)) continue;
                optionHovering = true;
                this.globalQuestOption = i;
            }
        }
        if (!optionHovering) {
            this.globalQuestOption = -1;
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        for (GuiSimpleButton button : this.buttons) {
            button.draw();
        }
        this.questName.drawTextBox();
        this.checkMouseWheel(mouseX, mouseY);
    }

    private void drawStages(int x, int y, int mouseX, int mouseY) {
        boolean mouseDown = Mouse.isButtonDown((int)0);
        if (mouseDown) {
            if (this.mouseState == MouseState.HOVER) {
                this.mouseState = MouseState.PRESS;
            } else if (this.mouseState == MouseState.PRESS) {
                this.mouseState = MouseState.DRAG;
            }
        } else if (this.mouseState == MouseState.PRESS || this.mouseState == MouseState.DRAG) {
            this.mouseState = MouseState.RELEASE;
        } else if (this.mouseState == MouseState.RELEASE) {
            this.mouseState = MouseState.HOVER;
            this.draggedStage = null;
        }
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        Quest quest = QuestEditorState.get().getSelectedQuest();
        int[] editDropZone = new int[]{x + dispWidth / 2 - 50, y + 90, x + dispWidth / 2 - 5, y + 110};
        int[] deleteDropZone = new int[]{x + dispWidth / 2 + 5, y + 90, x + dispWidth / 2 + 50, y + 110};
        boolean isHoverEdit = this.draggedStage != null && mouseX >= editDropZone[0] && mouseY >= editDropZone[1] && mouseX <= editDropZone[2] && mouseY <= editDropZone[3];
        boolean isHoverDelete = quest.getStages().size() > 1 && this.draggedStage != null && mouseX >= deleteDropZone[0] && mouseY >= deleteDropZone[1] && mouseX <= deleteDropZone[2] && mouseY <= deleteDropZone[3];
        GuiQuestOverview.func_73734_a((int)editDropZone[0], (int)editDropZone[1], (int)editDropZone[2], (int)editDropZone[3], (int)(isHoverEdit || this.draggedStage != null && this.ticker % 200 < 100 ? -16727066 : -10066330));
        GuiQuestOverview.func_73734_a((int)deleteDropZone[0], (int)deleteDropZone[1], (int)deleteDropZone[2], (int)deleteDropZone[3], (int)(isHoverDelete || quest.getStages().size() > 1 && this.draggedStage != null && this.ticker % 200 < 100 ? -2210481 : -10066330));
        GuiHelper.drawCenteredString(I18n.func_135052_a((String)"gui.questeditor.editstage", (Object[])new Object[0]), (float)(editDropZone[0] + editDropZone[2]) / 2.0f, y + 96, 0xFFFFFF, true);
        GuiHelper.drawCenteredString(I18n.func_135052_a((String)"gui.questeditor.removestage", (Object[])new Object[0]), (float)(deleteDropZone[0] + deleteDropZone[2]) / 2.0f, y + 96, 0xFFFFFF, true);
        int stageCount = quest.getStages().size();
        int gap = dispWidth / (stageCount + 1);
        if (this.draggedStage != null && this.mouseState == MouseState.RELEASE) {
            if (isHoverEdit) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestStage(this.draggedStage));
            } else if (isHoverDelete) {
                for (Stage stage : quest.getStages()) {
                    if (stage.getNextStage() != this.draggedStage.getStage()) continue;
                    stage.setNextStage(this.draggedStage.getNextStage());
                }
                quest.getStages().remove(this.draggedStage);
                quest.clearDefaultStrings(this.draggedStage.getStage(), this.draggedStage.getRawObjectives().size());
            }
        }
        boolean hovering = false;
        int index = 1;
        for (Stage stage : quest.getStages()) {
            boolean mouseOver = this.drawStage(stage, quest.getNextStage(stage.getStage()), this.draggedStage == stage, x + gap * index, y + 45, gap, mouseX, mouseY);
            if (mouseOver) {
                hovering = true;
                this.hoverStage = stage;
                if (this.mouseState == MouseState.PRESS) {
                    this.draggedStage = stage;
                } else if (this.mouseState == MouseState.RELEASE) {
                    if (this.draggedStage != null) {
                        Stage a = this.draggedStage;
                        Stage b = stage;
                        ArrayList<String> oa = new ArrayList<String>(a.getRawObjectives());
                        ArrayList<String> aa = new ArrayList<String>(a.getRawActions());
                        ArrayList<String> ob = new ArrayList<String>(b.getRawObjectives());
                        ArrayList<String> ab = new ArrayList<String>(b.getRawActions());
                        a.getRawObjectives().clear();
                        a.getRawObjectives().addAll(ob);
                        a.getRawActions().clear();
                        a.getRawActions().addAll(ab);
                        b.getRawObjectives().clear();
                        b.getRawObjectives().addAll(oa);
                        b.getRawActions().clear();
                        b.getRawActions().addAll(aa);
                    }
                    this.draggedStage = null;
                }
            }
            ++index;
        }
        if (!hovering) {
            this.hoverStage = null;
        }
        ++this.ticker;
    }

    private boolean drawStage(Stage stage, Stage nextStage, boolean dragged, int x, int y, int gap, int mouseX, int mouseY) {
        int width = 6;
        int height = 30;
        int left = x - width / 2 - 1;
        int top = y - 1;
        int right = x + width + 1;
        int bottom = y + height + 2;
        if (dragged) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)2.0f);
        }
        GuiQuestOverview.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)-16777216);
        GuiHelper.drawCenteredString(String.valueOf(stage.getStage()), x + 2, y - 10, this.hoverStage == stage && this.draggedStage == null ? (this.ticker % 200 < 100 ? 0 : 0xFFFFFF) : 0);
        boolean activeStage = QuestEditorState.get().getSelectedQuest().getActiveStage() == stage.getStage();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(activeStage ? GuiResources.eyeTexture : GuiResources.eyeClosedTexture);
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (activeStage) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            float grey = 0.4f;
            GlStateManager.func_179131_c((float)grey, (float)grey, (float)grey, (float)1.0f);
            if (this.mouseState == MouseState.PRESS && mouseX >= x - 4 && mouseX <= x + 7 && mouseY >= y + height + 1 && mouseY <= y + height + 15) {
                QuestEditorState.get().getSelectedQuest().setActiveStage(stage.getStage());
            }
        }
        Gui.func_146110_a((int)(x - 4), (int)(y + height + 1), (float)0.0f, (float)0.0f, (int)11, (int)11, (float)11.0f, (float)11.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (stage.getStage() == 0) {
            GuiQuestOverview.func_73734_a((int)(x - 10), (int)(y + height / 2 - 1), (int)(x - 4), (int)(y + height / 2 + 2), (int)-1);
            this.addStageButtonLoc[0] = x - 19;
            this.addStageButtonLoc[1] = y + height / 2 - 4;
            this.addStageButtonLoc[2] = x - 10;
            this.addStageButtonLoc[3] = y + height / 2 + 5;
            GuiQuestOverview.func_73734_a((int)this.addStageButtonLoc[0], (int)this.addStageButtonLoc[1], (int)this.addStageButtonLoc[2], (int)this.addStageButtonLoc[3], (int)-1);
            GuiQuestOverview.func_73734_a((int)(x - 17), (int)(y + height / 2), (int)(x - 12), (int)(y + height / 2 + 1), (int)-16777216);
            GuiQuestOverview.func_73734_a((int)(x - 15), (int)(y + height / 2 - 2), (int)(x - 14), (int)(y + height / 2 + 3), (int)-16777216);
        }
        if (nextStage != null) {
            GuiQuestOverview.func_73734_a((int)(x + 7), (int)(y + height / 2 - 1), (int)(x + gap - 4), (int)(y + height / 2 + 2), (int)-1);
        } else {
            GuiQuestOverview.func_73734_a((int)(x + 7), (int)(y + height / 2 - 1), (int)(x + 13), (int)(y + height / 2 + 2), (int)-1);
            GuiQuestOverview.func_73734_a((int)(x + 13), (int)(y + height / 2 - 3), (int)(x + 15), (int)(y + height / 2 + 4), (int)-1);
        }
        if (dragged) {
            x = mouseX;
            y = mouseY - height / 2;
        }
        GuiQuestOverview.func_73734_a((int)(x - width / 2 - 1), (int)(y - 1), (int)(x + width + 1), (int)(y + height + 2), (int)-16777216);
        GuiQuestOverview.func_73734_a((int)(x - width / 2), (int)y, (int)(x + width), (int)(y + height / 2), (int)-17664);
        GuiQuestOverview.func_73734_a((int)(x - width / 2), (int)(y + height / 2 + 1), (int)(x + width), (int)(y + height + 1), (int)-5479425);
        GuiHelper.drawCenteredString(String.valueOf(stage.getRawObjectives().size()), x + 2, (float)y + (float)height / 2.0f - 11.0f, 0);
        GuiHelper.drawCenteredString(String.valueOf(stage.getRawActions().size()), x + 2, y + height - 10, 0);
        if (dragged) {
            GlStateManager.func_179121_F();
        }
        return mouseX >= left && mouseX <= right && mouseY >= top && mouseY <= bottom;
    }

    private void drawColorPicker(int dispWidth, int dispHeight, int mouseX, int mouseY) {
        Quest quest = QuestEditorState.get().getSelectedQuest();
        if (this.hsb == null) {
            this.hsb = new float[3];
            Color.RGBtoHSB(quest.getColor().getR(), quest.getColor().getG(), quest.getColor().getB(), this.hsb);
        }
        int x = this.field_146294_l / 2 - 125;
        int y = this.field_146295_m / 2 - 100;
        int left = x + 5;
        int top = y + 117;
        int width = 100;
        int height = 55;
        for (int i = 0; i < width; ++i) {
            float v1 = (float)i / (float)width;
            float v2 = (float)((double)i + 0.5) / (float)width;
            GuiHelper.drawGradientRect(left + i, top, 1.0f, left + i + 1, top + height, Color.HSBtoRGB(this.hsb[0], v1, 1.0f), Color.BLACK.getRGB(), false);
            GuiHelper.drawGradientRect(left + i, top + height + 4, 1.0f, left + i + 1, top + height + 12, Color.HSBtoRGB(v1, 1.0f, 1.0f), Color.HSBtoRGB(v2, 1.0f, 1.0f), true);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int newColor = Color.HSBtoRGB(this.hsb[0], this.hsb[1], this.hsb[2]);
        Color color = new Color(newColor);
        GuiQuestOverview.func_73734_a((int)(left + width + 3), (int)top, (int)(left + width + 13), (int)(top + height + 23), (int)-16777216);
        GuiQuestOverview.func_73734_a((int)(left + width + 3 + 1), (int)(top + 1), (int)(left + width + 13 - 1), (int)(top + height + 23 - 1), (int)newColor);
        int tickerColor = this.ticker % 200 < 100 ? 0 : 0xFFFFFF;
        int rgbSpacing = 37;
        this.field_146289_q.func_78276_b("R", left, top + height + 16, 0);
        this.field_146289_q.func_78276_b(String.valueOf(color.getRed()), left + 8, top + height + 16, this.hoveringColor == 0 ? tickerColor : 0);
        this.field_146289_q.func_78276_b("G", left + rgbSpacing, top + height + 16, 0);
        this.field_146289_q.func_78276_b(String.valueOf(color.getGreen()), left + rgbSpacing + 8, top + height + 16, this.hoveringColor == 1 ? tickerColor : 0);
        this.field_146289_q.func_78276_b("B", left + rgbSpacing * 2, top + height + 16, 0);
        this.field_146289_q.func_78276_b(String.valueOf(color.getBlue()), left + rgbSpacing * 2 + 8, top + height + 16, this.hoveringColor == 2 ? tickerColor : 0);
        if (this.mouseState == MouseState.PRESS) {
            if (mouseX >= left && mouseX <= left + width && mouseY >= top && mouseY <= top + height) {
                this.changingColor = true;
                CursorHelper.setCursor(CursorHelper.TRANSPARENT_CURSOR);
            } else if (mouseX >= left && mouseX <= left + width && mouseY >= top + height + 4 && mouseY <= top + height + 12) {
                this.changingHue = true;
                CursorHelper.setCursor(CursorHelper.TRANSPARENT_CURSOR);
            }
        } else if (this.mouseState == MouseState.RELEASE) {
            if (this.changingColor || this.changingHue) {
                CursorHelper.setCursor(CursorHelper.DEFAULT_CURSOR);
            }
            this.changingColor = false;
            this.changingHue = false;
        } else if (this.mouseState == MouseState.DRAG && (this.changingColor || this.changingHue)) {
            int boundedMouseX = this.bound(mouseX, left, left + width);
            int boundedMouseY = this.bound(mouseY, top, top + height);
            float colorX = (float)(boundedMouseX - left) / (float)width;
            float colorY = (float)(boundedMouseY - top) / (float)height;
            if (this.changingColor) {
                this.hsb[1] = colorX;
                this.hsb[2] = 1.0f - colorY;
            } else if (this.changingHue) {
                this.hsb[0] = colorX;
                boundedMouseY = top + height + 8;
            }
            int fullbrightColor = Color.HSBtoRGB(this.hsb[0], 1.0f, 1.0f);
            QuestColor newQuestColor = new QuestColor(newColor);
            quest.setColor(newQuestColor);
            int size = 12;
            int border = 1;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)2.0f);
            GuiQuestOverview.func_73734_a((int)(boundedMouseX - border - size / 2), (int)(boundedMouseY - border - size / 2), (int)(boundedMouseX + size / 2 + border), (int)(boundedMouseY + size / 2 + border), (int)-16777216);
            GuiQuestOverview.func_73734_a((int)(boundedMouseX - size / 2), (int)(boundedMouseY - size / 2), (int)(boundedMouseX + size / 2), (int)(boundedMouseY + size / 2), (int)(this.changingColor ? newColor : fullbrightColor));
            GlStateManager.func_179121_F();
        } else {
            boolean set = false;
            for (int i = 0; i < 3; ++i) {
                if (mouseX < left + rgbSpacing * i || mouseX > left + rgbSpacing * i + 24 || mouseY < top + height + 16 || mouseY > top + height + 16 + 6) continue;
                this.hoveringColor = i;
                set = true;
                break;
            }
            if (!set) {
                this.hoveringColor = -1;
            }
        }
    }

    private int bound(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int x = this.field_146294_l / 2 - 125;
        int y = this.field_146295_m / 2 - 100;
        int id = -1;
        for (GuiSimpleButton button : this.buttons) {
            if (!button.isEnabled() || !button.isWithin(mouseX, mouseY)) continue;
            id = button.id;
            break;
        }
        if (id != -1) {
            switch (id) {
                case 0: {
                    QuestEditorState.get().push(this.oldName, QuestEditorState.get().getSelectedQuest(), true);
                    this.oldName = QuestEditorState.get().getSelectedQuest().getFilename();
                    break;
                }
                case 1: {
                    QuestEditorState.get().push(this.oldName, QuestEditorState.get().getSelectedQuest(), false);
                    this.oldName = QuestEditorState.get().getSelectedQuest().getFilename();
                    break;
                }
                case 2: {
                    QuestEditorState.get().fetch(false);
                    this.reload = true;
                }
            }
        }
        if (mouseX >= this.addStageButtonLoc[0] && mouseY >= this.addStageButtonLoc[1] && mouseX <= this.addStageButtonLoc[2] && mouseY <= this.addStageButtonLoc[3]) {
            QuestEditorState.get().addNewStage();
        }
        if (this.globalQuestOption != -1) {
            switch (this.globalQuestOption) {
                case 1: {
                    QuestEditorState.get().getSelectedQuest().toggleAbandonability();
                    break;
                }
                case 2: {
                    QuestEditorState.get().getSelectedQuest().toggleRepeatability();
                    break;
                }
                case 3: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestStrings());
                }
            }
        }
        this.questName.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void func_73869_a(char c, int i) {
        block3: {
            try {
                super.func_73869_a(c, i);
            }
            catch (IOException e) {
                if (!Pixelmon.devEnvironment) break block3;
                Pixelmon.LOGGER.error(e.getLocalizedMessage());
            }
        }
        if (this.questName.isFocused() && this.questName.textboxKeyTyped(c, i)) {
            QuestEditorState.get().getSelectedQuest().setFilename(this.questName.getText() + ".json");
        }
    }

    private void checkMouseWheel(int mouseX, int mouseY) {
        int mousewheelDirection = Mouse.getDWheel();
        if (mousewheelDirection == 120) {
            this.onScroll(Direction.DOWN, mouseX, mouseY);
        } else if (mousewheelDirection == -120) {
            this.onScroll(Direction.UP, mouseX, mouseY);
        }
    }

    private void onScroll(Direction direction, int mouseX, int mouseY) {
        int change;
        short oldStageValue;
        short newStageValue;
        if (this.changingColor || this.changingHue) {
            return;
        }
        if (this.hoverStage != null && (newStageValue = (short)((oldStageValue = this.hoverStage.getStage()) + (direction == Direction.UP ? 1 : -1))) >= 0 && newStageValue < Short.MAX_VALUE && oldStageValue != newStageValue) {
            Quest quest = QuestEditorState.get().getSelectedQuest();
            Stage replacing = quest.getStage(newStageValue);
            if (replacing != null) {
                short sA = this.hoverStage.getStage();
                short nsA = this.hoverStage.getNextStage();
                short sB = replacing.getStage();
                short nsB = replacing.getNextStage();
                this.hoverStage.setStage(sB);
                this.hoverStage.setNextStage(nsB);
                replacing.setStage(sA);
                replacing.setNextStage(nsA);
            } else if (oldStageValue != 0 || newStageValue != 1) {
                this.hoverStage.setStage(newStageValue);
                for (Stage stage : quest.getStages()) {
                    if (stage.getNextStage() != oldStageValue) continue;
                    stage.setNextStage(newStageValue);
                }
                quest.clearDefaultStrings(oldStageValue, this.hoverStage.getRawObjectives().size());
                quest.setDefaultStrings(newStageValue, this.hoverStage.getRawObjectives().size());
            }
            quest.getStages().sort(Comparator.comparing(Stage::getStage));
        }
        if (this.hoveringColor != -1) {
            change = direction == Direction.DOWN ? -1 : 1;
            int rgb = Color.HSBtoRGB(this.hsb[0], this.hsb[1], this.hsb[2]);
            Color color = new Color(rgb);
            QuestColor newColor = new QuestColor(this.bound(color.getRed() + (this.hoveringColor == 0 ? change : 0), 0, 255), this.bound(color.getGreen() + (this.hoveringColor == 1 ? change : 0), 0, 255), this.bound(color.getBlue() + (this.hoveringColor == 2 ? change : 0), 0, 255));
            QuestEditorState.get().getSelectedQuest().setColor(newColor);
            Color.RGBtoHSB(newColor.getR(), newColor.getG(), newColor.getB(), this.hsb);
        }
        if (this.globalQuestOption == 0) {
            change = direction == Direction.DOWN ? -1 : 1;
            QuestEditorState.get().getSelectedQuest().setWeight(QuestEditorState.get().getSelectedQuest().getWeight() + change);
        }
    }

    private void refreshQuest() {
        for (Quest quest : QuestEditorState.get().getAllQuests()) {
            if (!quest.getFilename().equalsIgnoreCase(this.oldName)) continue;
            QuestEditorState.get().selectQuest(quest);
            this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestOverview());
            break;
        }
    }

    public void func_73876_c() {
        if (!QuestEditorState.get().hasQuestSelected()) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestEditor());
        }
        this.addButtons();
        if (QuestEditorState.get().isDirty() && this.reload) {
            this.refreshQuest();
            this.reload = false;
        }
    }

    private static enum Direction {
        UP,
        DOWN;

    }

    private static enum MouseState {
        HOVER,
        PRESS,
        DRAG,
        RELEASE;

    }
}

