/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.editor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiDropDown;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiDropDownManager;
import com.pixelmonmod.pixelmon.quests.actions.ExecutorMode;
import com.pixelmonmod.pixelmon.quests.client.editor.GuiQuestEditor;
import com.pixelmonmod.pixelmon.quests.client.editor.GuiQuestOverview;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestEditorState;
import com.pixelmonmod.pixelmon.quests.client.editor.ui.GuiSimpleButton;
import com.pixelmonmod.pixelmon.quests.editor.QuestElement;
import com.pixelmonmod.pixelmon.quests.editor.QuestElementType;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.math.NumberUtils;
import org.lwjgl.input.Mouse;

public class GuiQuestStage
extends GuiScreen {
    private List<GuiSimpleButton> buttons = new ArrayList<GuiSimpleButton>();
    private Stage stage;
    private CopyOnWriteArrayList<QuestElement> objectives;
    private CopyOnWriteArrayList<QuestElement> actions;
    private QuestElement selection = null;
    private HashSet<Integer> actionObjectives = new HashSet();
    private ExecutorMode actionMode = ExecutorMode.AND;
    private ArrayList<Gui> selectionElements = new ArrayList();
    private GuiDropDown<QuestElement> dropDown;
    private final GuiDropDownManager dropDownManager = new GuiDropDownManager();
    private MouseState mouseState = MouseState.HOVER;
    private boolean reload = false;
    int prevWidth = -1;
    int prevHeight = -1;

    public GuiQuestStage(Stage stage) {
        this.stage = stage;
        this.objectives = new CopyOnWriteArrayList<QuestElement>(QuestEditorState.get().getObjectivesForStage(stage));
        this.actions = new CopyOnWriteArrayList<QuestElement>(QuestEditorState.get().getActionsForStage(stage));
        this.dropDownManager.clearDropDowns();
    }

    public void func_73866_w_() {
        this.addButtons();
    }

    public void addButtons() {
        this.buttons.clear();
        int x = this.field_146294_l / 2 - 125;
        int y = this.field_146295_m / 2 - 100;
        int id = 0;
        int buttonS = 14;
        this.buttons.add(new GuiSimpleButton(id++, x + 4 + (buttonS + 6) * 0, y + 6, 12, GuiResources.back, 2, 2, -12407307));
        this.buttons.add(new GuiSimpleButton(id++, x + 4 + (buttonS + 6) * 1, y + 6, 12, GuiResources.save, 2, 2, -14300093));
        this.buttons.add(new GuiSimpleButton(id++, x + 4 + (buttonS + 6) * 2, y + 6, 12, GuiResources.discard, 2, 2, -2210481));
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        if (!QuestEditorState.get().hasQuestSelected()) {
            return;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179112_b((int)770, (int)771);
        super.func_73863_a(mouseX, mouseY, f);
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.backgroundTexture);
        int gap = 3;
        int x = this.field_146294_l / 2 - 125;
        int y = this.field_146295_m / 2 - 100;
        Gui.func_146110_a((int)(x - gap), (int)y, (float)0.0f, (float)0.0f, (int)(dispWidth / 2), (int)dispHeight, (float)((float)dispWidth / 2.0f), (float)dispHeight);
        Gui.func_146110_a((int)(x + dispWidth / 2 + gap + 1), (int)y, (float)0.0f, (float)0.0f, (int)(dispWidth / 2), (int)dispHeight, (float)((float)dispWidth / 2.0f), (float)dispHeight);
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179112_b((int)770, (int)771);
        this.drawElements(x, y, mouseX, mouseY);
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        for (GuiSimpleButton button : this.buttons) {
            button.draw();
        }
        if (this.selection != null) {
            this.selection.draw(this.field_146297_k, x, y, dispWidth, dispHeight);
        }
        this.dropDownManager.drawDropDowns(0.0f, mouseX, mouseY);
        this.checkMouseWheel(mouseX, mouseY);
    }

    private void drawElements(int x, int y, int mouseX, int mouseY) {
        boolean showActionOptions;
        boolean mouseDown = Mouse.isButtonDown((int)0);
        if (mouseDown) {
            if (this.mouseState == MouseState.HOVER) {
                this.mouseState = MouseState.PRESS;
            } else if (this.mouseState == MouseState.PRESS) {
                this.mouseState = MouseState.DRAG;
            }
        } else if (this.mouseState == MouseState.PRESS || this.mouseState == MouseState.DRAG) {
            this.mouseState = MouseState.RELEASE;
        } else if (this.mouseState == MouseState.RELEASE) {
            this.mouseState = MouseState.HOVER;
        }
        int xOffset = 20;
        int yOffset = 20;
        int dispWidth = xOffset + 230;
        int dispHeight = yOffset + 180;
        int left = x + 4;
        int top = y + 24;
        int right = x + dispWidth / 2 - 10;
        int size = 13;
        boolean bl = showActionOptions = this.selection != null && this.selection.getType() == QuestElementType.ACTION;
        if (showActionOptions) {
            this.field_146289_q.func_78264_a(true);
            GuiHelper.drawCenteredString(TextFormatting.BOLD + this.actionMode.name(), (float)right - 6.0f, top - 8, 0);
            this.field_146289_q.func_78264_a(false);
        }
        int i = 0;
        for (QuestElement element : this.objectives) {
            this.drawElement(element, x, y, dispWidth, dispHeight, i++, size, left, right, top, mouseX, mouseY, -17664);
        }
        for (QuestElement element : this.actions) {
            this.drawElement(element, x, y, dispWidth, dispHeight, i++, size, left, right, top, mouseX, mouseY, -5479425);
        }
        int addY = top + (size - 1) * i + 5;
        GuiQuestStage.func_73734_a((int)(left + 20), (int)addY, (int)(left + 40), (int)(addY + 10), (int)-17664);
        GuiHelper.drawCenteredString("+", (float)left + 30.5f, (float)addY + 1.75f, -16777216);
        GuiQuestStage.func_73734_a((int)(right - 40), (int)addY, (int)(right - 20), (int)(addY + 10), (int)-5479425);
        GuiHelper.drawCenteredString("+", (float)(right - 40) + 10.5f, (float)addY + 1.75f, -16777216);
        if (this.mouseState == MouseState.PRESS) {
            if (showActionOptions && mouseX >= right - 12 && mouseX <= right && mouseY >= top - 8 && mouseY <= top - 2) {
                this.actionMode = this.actionMode == ExecutorMode.AND ? ExecutorMode.OR : ExecutorMode.AND;
            } else if (mouseY >= addY && mouseY <= addY + 10) {
                if (mouseX >= left + 20 && mouseX <= left + 40) {
                    this.objectives.add(QuestEditorState.get().getObjectives().get(0).copy());
                } else if (mouseX >= right - 40 && mouseX <= right - 20) {
                    this.actions.add(QuestEditorState.get().getActions().get(0).copy());
                }
            }
        }
        QuestColor color = QuestEditorState.get().getSelectedQuest().getColor();
        GlStateManager.func_179131_c((float)color.floatR(), (float)color.floatG(), (float)color.floatB(), (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.stage.getIcon().getResource());
        Gui.func_146110_a((int)(x + 60), (int)(y + 4), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
    }

    private void drawElement(QuestElement element, int x, int y, int w, int h, int i, int size, int left, int right, int top, int mouseX, int mouseY, int color) {
        boolean selected;
        int offset = (size - 1) * i;
        boolean bl = selected = this.selection == element;
        if (selected) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)2.0f);
        }
        boolean showActionOptions = this.selection != null && this.selection.getType() == QuestElementType.ACTION && element.getType() == QuestElementType.OBJECTIVE;
        int nudge = 0;
        if (showActionOptions) {
            nudge = 12;
        }
        int x1 = left;
        int x2 = right - nudge;
        int y1 = top + offset;
        int y2 = top + size + offset;
        GuiQuestStage.func_73734_a((int)x1, (int)y1, (int)x2, (int)y2, (int)(selected ? -1 : -16777216));
        GuiQuestStage.func_73734_a((int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)color);
        GuiHelper.drawSquashedString(this.field_146289_q, I18n.func_188566_a((String)element.getName()) ? I18n.func_135052_a((String)element.getName(), (Object[])new Object[0]) : element.getIdentifier(), false, showActionOptions ? 84.0 : 95.0, x1 + 3, y1 + size / 2 - 3, -16777216, false);
        GuiQuestStage.func_73734_a((int)(x2 - 11), (int)(y1 + 2), (int)(x2 - 2), (int)(y1 + 11), (int)-2210481);
        this.field_146289_q.func_78276_b("-", x2 - 9, y1 + 3, -1);
        if (showActionOptions) {
            GuiQuestStage.func_73734_a((int)(right - 11), (int)(y1 + 2), (int)(right - 2), (int)(y1 + 3), (int)-16777216);
            GuiQuestStage.func_73734_a((int)(right - 11), (int)(y1 + 10), (int)(right - 2), (int)(y1 + 11), (int)-16777216);
            GuiQuestStage.func_73734_a((int)(right - 11), (int)(y1 + 2), (int)(right - 10), (int)(y1 + 11), (int)-16777216);
            GuiQuestStage.func_73734_a((int)(right - 3), (int)(y1 + 2), (int)(right - 2), (int)(y1 + 11), (int)-16777216);
            if (this.actionObjectives.contains(i)) {
                GuiQuestStage.func_73734_a((int)(right - 10), (int)(y1 + 3), (int)(right - 3), (int)(y1 + 10), (int)-5479425);
            }
        }
        if (this.mouseState == MouseState.PRESS) {
            if (showActionOptions && mouseX >= right - 11 && mouseY >= y1 + 2 && mouseX <= right - 2 && mouseY <= y1 + 11) {
                if (!this.actionObjectives.remove(i)) {
                    this.actionObjectives.add(i);
                }
            } else if (mouseX >= x2 - 11 && mouseY >= y1 + 2 && mouseX <= x2 - 2 && mouseY <= y1 + 11) {
                this.deleteElement(element);
            } else if (mouseX >= x1 && mouseY >= y1 && mouseX <= x2 && mouseY <= y2) {
                this.selectElement(element, x, y, w, h);
            }
        }
        if (selected) {
            GlStateManager.func_179121_F();
        }
    }

    private void writeExtraString(QuestElement element) {
        if (element != null && element.getType() == QuestElementType.ACTION) {
            StringBuilder extra = new StringBuilder(this.actionMode == ExecutorMode.AND ? "+" : "");
            boolean first = true;
            for (int i : this.actionObjectives) {
                if (!first) {
                    extra.append(",");
                }
                extra.append(i);
                first = false;
            }
            String result = extra.toString();
            if (result.isEmpty() || result.equalsIgnoreCase("+")) {
                element.setExtra("0");
            } else {
                element.setExtra(result);
            }
        }
    }

    private void selectElement(QuestElement element, int x, int y, int w, int h) {
        this.writeExtraString(this.selection);
        this.selection = element;
        if (this.selection.getType() == QuestElementType.ACTION) {
            String objArgs = this.selection.getExtra();
            ExecutorMode executorMode = this.actionMode = objArgs.startsWith("+") ? ExecutorMode.AND : ExecutorMode.OR;
            if (this.actionMode == ExecutorMode.AND) {
                objArgs = objArgs.substring(1);
            }
            String[] split = objArgs.split(",");
            this.actionObjectives.clear();
            for (String arg : split) {
                if (!NumberUtils.isParsable((String)arg)) continue;
                int i = Integer.parseInt(arg);
                if (this.objectives.size() <= i) continue;
                this.actionObjectives.add(i);
            }
        }
        this.selection.initialize(this.field_146297_k, x, y, w, h);
        this.setDropDowns(x, y, w, h);
    }

    private void setDropDowns(int x, int y, int w, int h) {
        int dropDownX = x + w / 2 + 6;
        int dropDownY = y + 2;
        int dropDownW = 111;
        int dropDownH = 140;
        this.dropDownManager.clearDropDowns();
        if (this.selection.getType() == QuestElementType.OBJECTIVE) {
            this.addDropDown(new GuiDropDown<int>((List<int>)QuestEditorState.get().getObjectives(), QuestEditorState.get().getObjectives().indexOf(QuestEditorState.get().getObjective(this.selection.getIdentifier())), dropDownX, dropDownY, dropDownW, dropDownH, dropDownW - 6).setGetOptionString(qe -> I18n.func_188566_a((String)qe.getName()) ? I18n.func_135052_a((String)qe.getName(), (Object[])new Object[0]) : qe.getIdentifier()).setOrdered().setOnSelected(e -> this.selection.duplicate((QuestElement)e)));
        } else if (this.selection.getType() == QuestElementType.ACTION) {
            this.addDropDown(new GuiDropDown<int>((List<int>)QuestEditorState.get().getActions(), QuestEditorState.get().getActions().indexOf(QuestEditorState.get().getAction(this.selection.getIdentifier())), dropDownX, dropDownY, dropDownW, dropDownH, dropDownW - 6).setGetOptionString(qe -> I18n.func_188566_a((String)qe.getName()) ? I18n.func_135052_a((String)qe.getName(), (Object[])new Object[0]) : qe.getIdentifier()).setOrdered().setOnSelected(e -> this.selection.duplicate((QuestElement)e)));
        }
    }

    private void deleteElement(QuestElement element) {
        if (this.objectives.remove(element)) {
            Quest quest = QuestEditorState.get().getSelectedQuest();
            quest.clearDefaultStrings(this.stage.getStage(), this.objectives.size());
            this.actionObjectives.remove(this.objectives.size());
        }
        this.actions.remove(element);
        if (this.selection == element) {
            this.selection = null;
        }
    }

    private int bound(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (this.dropDownManager.mouseClicked(mouseX, mouseY, mouseButton)) {
            return;
        }
        int x = this.field_146294_l / 2 - 125;
        int y = this.field_146295_m / 2 - 100;
        Gui.func_146110_a((int)(x + 104), (int)(y + 4), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        if (mouseX >= x + 60 && mouseX <= x + 60 + 16 && mouseY >= y + 4 && mouseY <= y + 4 + 16) {
            this.stage.changeIcon();
            return;
        }
        int id = -1;
        for (GuiSimpleButton button : this.buttons) {
            if (!button.isEnabled() || !button.isWithin(mouseX, mouseY)) continue;
            id = button.id;
            break;
        }
        if (id != -1) {
            switch (id) {
                case 0: {
                    this.writeToStage();
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestOverview());
                    break;
                }
                case 1: {
                    this.writeToStage();
                    break;
                }
                case 2: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestOverview());
                }
            }
        }
        if (this.selection != null) {
            this.selection.onClick(mouseX, mouseY, mouseButton);
        }
    }

    private void writeToStage() {
        this.writeExtraString(this.selection);
        Quest quest = QuestEditorState.get().getSelectedQuest();
        this.stage.getRawObjectives().clear();
        int oi = 0;
        for (QuestElement element : this.objectives) {
            this.stage.getRawObjectives().add(element.build(quest, this.stage, oi++));
        }
        this.stage.getRawActions().clear();
        int ai = 0;
        for (QuestElement element : this.actions) {
            this.stage.getRawActions().add(element.build(quest, this.stage, ai++));
        }
        quest.setDefaultStrings(this.stage.getStage(), this.stage.getRawObjectives().size());
    }

    public void func_73869_a(char c, int i) {
        block3: {
            try {
                super.func_73869_a(c, i);
            }
            catch (IOException e) {
                if (!Pixelmon.devEnvironment) break block3;
                Pixelmon.LOGGER.error(e.getLocalizedMessage());
            }
        }
        if (this.selection != null) {
            this.selection.onType(c, i);
        }
    }

    private void checkMouseWheel(int mouseX, int mouseY) {
        int mousewheelDirection = Mouse.getDWheel();
        if (mousewheelDirection == 120) {
            this.onScroll(Direction.DOWN, mouseX, mouseY);
        } else if (mousewheelDirection == -120) {
            this.onScroll(Direction.UP, mouseX, mouseY);
        }
    }

    private void onScroll(Direction direction, int mouseX, int mouseY) {
    }

    public void func_73876_c() {
        if (!QuestEditorState.get().hasQuestSelected()) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestEditor());
        }
        if (this.prevWidth != -1 && this.prevHeight != -1 && (this.field_146294_l != this.prevWidth || this.field_146295_m != this.prevHeight)) {
            this.addButtons();
            if (this.selection != null) {
                int x = this.field_146294_l / 2 - 125;
                int y = this.field_146295_m / 2 - 100;
                int xOffset = 20;
                int yOffset = 20;
                int dispWidth = xOffset + 230;
                int dispHeight = yOffset + 180;
                this.selection.initialize(this.field_146297_k, x, y, dispWidth, dispHeight);
                this.setDropDowns(x, y, dispWidth, dispHeight);
            }
        }
        if (QuestEditorState.get().isDirty() && this.reload) {
            this.reload = false;
        }
        this.prevWidth = this.field_146294_l;
        this.prevHeight = this.field_146295_m;
    }

    public <T> GuiDropDown<T> addDropDown(GuiDropDown<T> dropDown) {
        this.dropDownManager.addDropDown(dropDown);
        return dropDown;
    }

    public void removeDropDown(GuiDropDown dropDown) {
        this.dropDownManager.removeDropDown(dropDown);
    }

    private static enum Direction {
        UP,
        DOWN;

    }

    private static enum MouseState {
        HOVER,
        PRESS,
        DRAG,
        RELEASE;

    }
}

