/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.editor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.quests.comm.editor.FetchQuestData;
import com.pixelmonmod.pixelmon.quests.comm.editor.PushQuestData;
import com.pixelmonmod.pixelmon.quests.editor.QuestElement;
import com.pixelmonmod.pixelmon.quests.editor.QuestElementType;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class QuestEditorState {
    private static final QuestEditorState INSTANCE = new QuestEditorState();
    private final ArrayList<Quest> quests = new ArrayList();
    private final ArrayList<QuestElement> objectives = new ArrayList();
    private final ArrayList<QuestElement> actions = new ArrayList();
    private Quest quest = null;
    private boolean isDirty = false;

    private QuestEditorState() {
    }

    public static QuestEditorState get() {
        return INSTANCE;
    }

    public void fetch(boolean openGui) {
        Pixelmon.network.sendToServer((IMessage)new FetchQuestData(openGui));
    }

    public void push(String oldName, Quest quest, boolean openUI) {
        Pixelmon.network.sendToServer((IMessage)new PushQuestData(oldName, quest, openUI));
    }

    public void delete(Quest quest) {
        Pixelmon.network.sendToServer((IMessage)new PushQuestData(quest.getFilename(), quest, true, false));
    }

    public void setQuests(ArrayList<Quest> quests, ArrayList<QuestElement> elements) {
        this.quests.clear();
        this.objectives.clear();
        this.actions.clear();
        this.quests.addAll(quests);
        for (QuestElement element : elements) {
            if (element.getType() == QuestElementType.OBJECTIVE) {
                this.objectives.add(element);
                continue;
            }
            if (element.getType() != QuestElementType.ACTION) continue;
            this.actions.add(element);
        }
        this.markDirty();
    }

    public ArrayList<Quest> getAllQuests() {
        return this.quests;
    }

    public boolean hasQuest(String name) {
        for (Quest quest : this.quests) {
            if (!quest.getPrintableName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<QuestElement> getObjectives() {
        return this.objectives;
    }

    public QuestElement getObjective(String identifier) {
        for (QuestElement element : this.objectives) {
            if (!element.getIdentifier().equalsIgnoreCase(identifier)) continue;
            return element;
        }
        return null;
    }

    public ArrayList<QuestElement> getActions() {
        return this.actions;
    }

    public QuestElement getAction(String identifier) {
        for (QuestElement element : this.actions) {
            if (!element.getIdentifier().equalsIgnoreCase(identifier)) continue;
            return element;
        }
        return null;
    }

    public ArrayList<QuestElement> getObjectivesForStage(Stage stage) {
        ArrayList<QuestElement> objectives = new ArrayList<QuestElement>();
        for (String objective : stage.getRawObjectives()) {
            String identifier = objective.split(" ")[0];
            for (QuestElement element : this.getObjectives()) {
                if (element.getType() != QuestElementType.OBJECTIVE || !element.getIdentifier().equalsIgnoreCase(identifier)) continue;
                objectives.add(element.create(this.quest, objective));
            }
        }
        return objectives;
    }

    public ArrayList<QuestElement> getActionsForStage(Stage stage) {
        ArrayList<QuestElement> actions = new ArrayList<QuestElement>();
        for (String action : stage.getRawActions()) {
            String identifier = action.split(" ")[1];
            for (QuestElement element : this.getActions()) {
                if (element.getType() != QuestElementType.ACTION || !element.getIdentifier().equalsIgnoreCase(identifier)) continue;
                actions.add(element.create(this.quest, action));
            }
        }
        return actions;
    }

    public void selectQuest(Quest quest) {
        this.quest = quest;
    }

    public boolean hasQuestSelected() {
        return this.quest != null;
    }

    public Quest getSelectedQuest() {
        return this.quest;
    }

    public void addNewStage() {
        Quest quest = this.getSelectedQuest();
        if (quest != null) {
            quest.getStages().sort(Comparator.comparing(Stage::getStage));
            Stage lastStage = quest.getStages().get(quest.getStages().size() - 1);
            short lastStageValue = lastStage.getStage();
            short div10 = (short)(lastStageValue / 10 * 10);
            short newStage = (short)(div10 + 10);
            lastStage.setNextStage(newStage);
            Stage stage = new Stage(newStage, -1);
            quest.getStages().add(stage);
            quest.setDefaultStrings(newStage, 0);
        }
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public boolean isDirty() {
        boolean dirty = this.isDirty;
        this.isDirty = false;
        return dirty;
    }
}

