/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.ui;

import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.quests.client.QuestProgressClient;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class GuiListQuest
extends Gui {
    private static final ResourceLocation circle = new ResourceLocation("pixelmon", "textures/gui/quests/circle.png");
    private static final ResourceLocation exclamation_mark = new ResourceLocation("pixelmon", "textures/gui/quests/exclamation_mark.png");
    private static final ResourceLocation question_mark = new ResourceLocation("pixelmon", "textures/gui/quests/question_mark.png");
    public static final int X_OFFSET = 4;
    public static final int Y_OFFSET = 2;
    private final FontRenderer fRend;
    public int xPos = 0;
    public int yPos = 0;
    public int width = 12;
    public int height = 12;
    public boolean drawBackground = true;
    public boolean drawBorder = true;
    public boolean isEnabled = true;
    public boolean isFocused = false;
    public int borderColor = -6250336;
    public int backgroundColor = 0xF2F2F2;
    public int selectedLineColor = 0x4D4D4D;
    public int textColor = Color.BLACK.getRGB();
    public int selectedTextColor = Color.WHITE.getRGB();
    public int displayLines = 0;
    public int lineHeight = 10;
    public List<QuestProgressClient> lines = new LinkedList<QuestProgressClient>();
    public int startLine = 0;
    public Integer selectedQuest = null;
    public boolean highlightSelectedLine = true;

    public GuiListQuest(FontRenderer fontRenderer, int x, int y, int w, int lines) {
        this.fRend = fontRenderer;
        this.xPos = x;
        this.yPos = y;
        this.displayLines = lines;
        this.lineHeight = fontRenderer.field_78288_b + 6;
        this.width = w;
        this.height = this.displayLines * this.lineHeight + 2;
    }

    public void drawBackground() {
        if (this.lines.size() > 9 && this.displayLines == 9) {
            int bottomMarker = this.lineHeight * 9 - 1;
            float barMult = 9.0f / ((float)this.lines.size() - 8.0f);
            float barHeight = (float)this.lineHeight * barMult;
            float barPos = barHeight * (float)this.startLine;
            GuiListQuest.func_73734_a((int)(this.xPos + this.width + 2), (int)(this.yPos + 3 + (int)barPos), (int)(this.xPos + this.width + 6), (int)(this.yPos + 3 + (int)barPos + (int)barHeight), (int)-6710887);
            GuiListQuest.func_73734_a((int)(this.xPos + this.width + 2), (int)(this.yPos + 1), (int)(this.xPos + this.width + 6), (int)(this.yPos + 3), (int)-7829368);
            GuiListQuest.func_73734_a((int)(this.xPos + this.width + 2), (int)(this.yPos + 1 + bottomMarker), (int)(this.xPos + this.width + 6), (int)(this.yPos + 3 + bottomMarker), (int)-7829368);
        }
    }

    public void drawText() {
        Minecraft mc = Minecraft.func_71410_x();
        for (int i = this.startLine; i < this.startLine + this.displayLines; ++i) {
            QuestProgressClient qpc;
            if (i >= this.lines.size() || i < 0 || (qpc = this.lines.get(i)) == null || qpc.getName() == null) continue;
            double wf = 85.0;
            if (this.selectedQuest != null && this.selectedQuest == i && this.highlightSelectedLine) {
                GuiListQuest.func_73734_a((int)this.xPos, (int)(this.yPos + 1 + this.lineHeight * (i - this.startLine)), (int)(this.xPos + this.width), (int)(this.yPos + this.lineHeight * (1 + i - this.startLine) + this.lineHeight / 4 - 1), (int)-7829368);
                GuiHelper.drawSquashedString(this.fRend, qpc.getName(), false, wf, this.xPos + 4 + 12, this.yPos + 2 + this.lineHeight * (i - this.startLine) + this.lineHeight / 4, this.selectedTextColor, true);
            } else {
                GuiHelper.drawSquashedString(this.fRend, qpc.getName(), false, wf, this.xPos + 4 + 12, this.yPos + 2 + this.lineHeight * (i - this.startLine) + this.lineHeight / 4, this.selectedTextColor, false);
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_179112_b((int)770, (int)771);
            mc.field_71446_o.func_110577_a(qpc.isComplete() ? question_mark : qpc.getIcon().getResource());
            if (qpc.isComplete() || qpc.getColor() == null) {
                GlStateManager.func_179131_c((float)0.8509804f, (float)0.8509804f, (float)0.8509804f, (float)1.0f);
            } else {
                QuestColor color = qpc.getColor();
                GlStateManager.func_179131_c((float)color.floatR(), (float)color.floatG(), (float)color.floatB(), (float)1.0f);
            }
            Gui.func_146110_a((int)(this.xPos + 1), (int)(this.yPos + 1 + this.lineHeight * (i - this.startLine) + 1), (float)0.0f, (float)0.0f, (int)14, (int)14, (float)14.0f, (float)14.0f);
        }
    }

    public QuestProgressClient mouseClicked(int mouseX, int mouseY, int mouseButton, int offsetY) {
        int theLine;
        int index;
        if (mouseX > this.xPos && mouseX < this.xPos + this.width && mouseY > this.yPos && mouseY < this.yPos + this.height && (index = (theLine = ((mouseY += 8) - offsetY) / this.lineHeight) + this.startLine) < this.lines.size() && index >= 0) {
            return this.lines.get(index);
        }
        return null;
    }

    public void setEnabled(boolean enable) {
        this.isEnabled = enable;
    }

    public void setFocused(boolean focus) {
        this.isFocused = focus;
    }

    public void addLine(QuestProgressClient qpc) {
        this.lines.add(qpc);
    }

    public void selectQuest(int i) {
        this.selectedQuest = i;
    }

    public void scrollUp() {
        ++this.startLine;
        if (this.startLine > this.lines.size() - this.displayLines) {
            this.startLine = this.lines.size() - this.displayLines;
        }
        if (this.startLine < 0) {
            this.startLine = 0;
        }
    }

    public void scrollDown() {
        --this.startLine;
        if (this.startLine < 0) {
            this.startLine = 0;
        }
    }
}

