/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.comm.editor;

import com.pixelmonmod.pixelmon.comm.packetHandlers.ISyncHandler;
import com.pixelmonmod.pixelmon.quests.QuestRegistry;
import com.pixelmonmod.pixelmon.quests.client.editor.QuestEditorState;
import com.pixelmonmod.pixelmon.quests.editor.QuestElement;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PullQuestData
implements IMessage {
    private ArrayList<Quest> quests = new ArrayList<Quest>(QuestRegistry.getInstance().getQuestCollection());
    private ArrayList<QuestElement> elements = QuestRegistry.getInstance().getQuestElements();

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.quests.size());
        for (Quest quest : this.quests) {
            quest.writeToByteBuf(buf);
        }
        buf.writeShort(this.elements.size());
        for (QuestElement element : this.elements) {
            element.writeToByteBuf(buf);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.quests = new ArrayList();
        int questCount = buf.readShort();
        for (int i = 0; i < questCount; ++i) {
            this.quests.add(new Quest(buf));
        }
        this.elements = new ArrayList();
        int elementCount = buf.readShort();
        for (int i = 0; i < elementCount; ++i) {
            this.elements.add(new QuestElement(buf));
        }
    }

    public static class Handler
    implements ISyncHandler<PullQuestData> {
        @Override
        public void onSyncMessage(PullQuestData message, MessageContext ctx) {
            QuestEditorState.get().setQuests(message.quests, message.elements);
        }
    }
}

