/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.objectives.objectives.entity;

import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.editor.QuestElement;
import com.pixelmonmod.pixelmon.quests.editor.QuestElementType;
import com.pixelmonmod.pixelmon.quests.editor.args.ArgumentType;
import com.pixelmonmod.pixelmon.quests.editor.args.QuestElementArgument;
import com.pixelmonmod.pixelmon.quests.objectives.IObjective;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.player.ItemObjective;
import com.pixelmonmod.pixelmon.quests.quest.ArgsIn;
import com.pixelmonmod.pixelmon.quests.quest.Argument;
import com.pixelmonmod.pixelmon.quests.quest.Arguments;
import com.pixelmonmod.pixelmon.quests.quest.Context;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import com.pixelmonmod.pixelmon.util.helpers.UUIDHelper;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;

public class NPCObjective
implements IObjective {
    private final String identifier;
    private final Type type;

    public NPCObjective(String identifier, Type type) {
        this.identifier = identifier;
        this.type = type;
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public QuestElement getStructure() {
        if (this.type == Type.TALK) {
            return new QuestElement(QuestElementType.OBJECTIVE, this.identifier(), new QuestElementArgument("entity_uuid", false, false, ArgumentType.TEXT, new String[0]));
        }
        if (this.type == Type.RESPOND) {
            return new QuestElement(QuestElementType.OBJECTIVE, this.identifier(), new QuestElementArgument("entity_uuid", false, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("dialogue_option", false, false, ArgumentType.WHOLE_NUMBER, "0", "1", "2", "3", "4", "5", "6", "7"));
        }
        if (this.type == Type.GIVE || this.type == Type.SHOW) {
            return new QuestElement(QuestElementType.OBJECTIVE, this.identifier(), new QuestElementArgument("entity_uuid", false, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("success", false, false, ArgumentType.SUCCESS, new String[0]), new QuestElementArgument("item", false, false, ArgumentType.ITEM, new String[0]), new QuestElementArgument("count", true, false, ArgumentType.WHOLE_NUMBER, new String[0]), new QuestElementArgument("damage_metadata", true, false, ArgumentType.WHOLE_NUMBER, new String[0]), new QuestElementArgument("display_name", true, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("nbt", true, false, ArgumentType.TEXT, new String[0]));
        }
        return new QuestElement(QuestElementType.OBJECTIVE, this.identifier(), new QuestElementArgument[0]);
    }

    @Override
    public Arguments parse(Quest quest, Stage stage, ArgsIn args) {
        if (this.type == Type.GIVE || this.type == Type.SHOW) {
            return Arguments.create(Argument.of(this.type), Argument.from(args.get(0), UUIDHelper::questUUID), Argument.from(args.get(1), s -> s.equalsIgnoreCase("success") || s.equalsIgnoreCase("true"), true), Argument.from(args.get(2), Item::func_111206_d, null), Argument.from(args.get(3), Integer::parseInt, -1), Argument.from(args.get(4), Integer::parseInt, -1), Argument.from(args.get(5), s -> s, ""), Argument.from(args.get(6), s -> {
                try {
                    return JsonToNBT.func_180713_a((String)s);
                }
                catch (Exception e) {
                    return new NBTTagCompound();
                }
            }, new NBTTagCompound()));
        }
        if (this.type == Type.RESPOND) {
            return Arguments.create(Argument.of(this.type), Argument.from(args.get(0), UUIDHelper::questUUID), Argument.from(args.get(1), Integer::parseInt, 1));
        }
        return Arguments.create(Argument.of(this.type), Argument.from(args.get(0), UUIDHelper::questUUID));
    }

    @Override
    public boolean test(Stage stage, QuestData data, QuestProgress progress, Objective objective, Arguments arguments, Context context) {
        Entity npc = (Entity)context.get(0);
        Type type = (Type)((Object)arguments.value(0, progress));
        UUID uuid = (UUID)arguments.value(1, progress);
        if (uuid == null || !npc.getPersistentID().equals(uuid)) {
            return false;
        }
        switch (type) {
            case GIVE: 
            case SHOW: {
                InventoryPlayer inventory = data.getPlayer().field_71071_by;
                boolean success = (Boolean)arguments.value(2, progress);
                Item item = (Item)arguments.value(3, progress);
                int count = (Integer)arguments.value(4, progress);
                int damage = (Integer)arguments.value(5, progress);
                String name = (String)arguments.value(6, progress);
                NBTTagCompound nbt = (NBTTagCompound)arguments.value(7, progress);
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    ItemStack stack = inventory.func_70301_a(i);
                    if (stack.func_190926_b() || !ItemObjective.compare(stack, item, count, damage, name, nbt)) continue;
                    if (type == Type.GIVE) {
                        stack.func_190918_g(count);
                    }
                    return success;
                }
                return !success;
            }
            case RESPOND: {
                int a = (Integer)context.get(1);
                int b = (Integer)arguments.value(2, progress);
                if (a != b) break;
                return true;
            }
            case TALK: {
                return true;
            }
        }
        return false;
    }

    @Override
    public ArrayList<QuestMarker> mark(Stage stage, QuestProgress progress, Objective objective, int objectiveIndex, Arguments arguments, Context context) {
        UUID uuid;
        ArrayList<QuestMarker> markers = new ArrayList<QuestMarker>();
        if (!progress.isObjectiveComplete(objectiveIndex) && (uuid = (UUID)arguments.value(1, progress)) != null) {
            markers.add(new QuestMarker(uuid, 0, progress.getQuest().getColor(), progress.getMarkerType()));
        }
        return markers;
    }

    public static enum Type {
        TALK,
        GIVE,
        SHOW,
        RESPOND;

    }
}

