/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.sounds;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import com.pixelmonmod.pixelmon.sounds.BattleMusicType;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PixelSounds {
    public static SoundEvent pc;
    public static SoundEvent pokelootObtained;
    public static SoundEvent cameraShutter;
    public static SoundEvent healerActive;
    public static SoundEvent pokeballClose;
    public static SoundEvent pokeballRelease;
    public static SoundEvent pokeballCapture;
    public static SoundEvent pokeballCaptureSuccess;
    public static SoundEvent bellRing;
    public static SoundEvent ultraWormhole;
    public static SoundEvent ultraSpaceAmbient;
    public static EnumMap<EnumSpecies, Map<BaseStats.SoundType, SoundEvent>> pixelmonSounds;
    public static Map<String, Map<BaseStats.SoundType, SoundEvent>> pixelmonFormSounds;
    public static EnumMap<BattleMusicType, SoundEvent> battleMusics;
    public static MusicTicker.MusicType ULTRA_SPACE_MUSIC_TYPE;

    public static void registerSounds(IForgeRegistry<SoundEvent> registry) {
        String prefix = "pixelmon:";
        pc = PixelSounds.registerSound(registry, prefix + "pixelmon.block.PC");
        pokelootObtained = PixelSounds.registerSound(registry, prefix + "pixelmon.block.PokelootObtained");
        cameraShutter = PixelSounds.registerSound(registry, prefix + "pixelmon.item.CameraShutter");
        healerActive = PixelSounds.registerSound(registry, prefix + "pixelmon.block.healerActivate");
        pokeballClose = PixelSounds.registerSound(registry, prefix + "pixelmon.block.PokeballClose");
        pokeballRelease = PixelSounds.registerSound(registry, prefix + "pixelmon.block.PokeballRelease");
        pokeballCapture = PixelSounds.registerSound(registry, prefix + "pixelmon.block.PokeballCapture");
        pokeballCaptureSuccess = PixelSounds.registerSound(registry, prefix + "pixelmon.block.PokeballCaptureSuccess");
        bellRing = PixelSounds.registerSound(registry, prefix + "pixelmon.block.bellRing");
        ultraWormhole = PixelSounds.registerSound(registry, prefix + "pixelmon.item.UltraWormhole");
        ultraSpaceAmbient = PixelSounds.registerSound(registry, prefix + "pixelmon.music.ultraspace");
        battleMusics = new EnumMap(BattleMusicType.class);
        for (BattleMusicType type : BattleMusicType.values()) {
            battleMusics.put(type, PixelSounds.registerSound(registry, prefix + "pixelmon.music.battle." + type.name().toLowerCase()));
        }
        pixelmonSounds = new EnumMap(EnumSpecies.class);
        pixelmonFormSounds = new HashMap<String, Map<BaseStats.SoundType, SoundEvent>>();
        PixelSounds.registerCries(registry);
        if (ULTRA_SPACE_MUSIC_TYPE == null && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ULTRA_SPACE_MUSIC_TYPE = (MusicTicker.MusicType)EnumHelper.addEnum(MusicTicker.MusicType.class, (String)"ULTRA_SPACE", (Class[])new Class[]{SoundEvent.class, Integer.TYPE, Integer.TYPE}, (Object[])new Object[]{ultraSpaceAmbient, 0, 200});
        }
    }

    private static SoundEvent registerSound(IForgeRegistry<SoundEvent> registry, String soundNameIn) {
        ResourceLocation resourcelocation = new ResourceLocation(soundNameIn);
        SoundEvent event = (SoundEvent)new SoundEvent(resourcelocation).setRegistryName(resourcelocation);
        registry.register((IForgeRegistryEntry)event);
        return event;
    }

    private static void registerCries(IForgeRegistry<SoundEvent> registry) {
        String prefix = "pixelmon:pixelmon.mob.";
        BufferedInputStream istream = Pixelmon.proxy.getStreamForResourceLocation(new ResourceLocation("pixelmon:sounds.json"));
        BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(istream));
        JsonObject json = new JsonParser().parse((Reader)bufferedreader).getAsJsonObject();
        for (EnumSpecies species : EnumSpecies.values()) {
            Object event;
            String key = "pixelmon.mob." + species.name.toLowerCase();
            if (json.has(key)) {
                event = PixelSounds.registerSound(registry, prefix + species.name.toLowerCase());
                pixelmonSounds.putIfAbsent(species, Maps.newEnumMap(BaseStats.SoundType.class));
                pixelmonSounds.get(species).put(BaseStats.SoundType.Neutral, (SoundEvent)event);
            }
            if (json.has(key + "F")) {
                event = PixelSounds.registerSound(registry, prefix + species.name.toLowerCase() + "F");
                pixelmonSounds.putIfAbsent(species, Maps.newEnumMap(BaseStats.SoundType.class));
                pixelmonSounds.get(species).put(BaseStats.SoundType.Female, (SoundEvent)event);
            }
            if (json.has(key + "M")) {
                event = PixelSounds.registerSound(registry, prefix + species.name.toLowerCase() + "M");
                pixelmonSounds.putIfAbsent(species, Maps.newEnumMap(BaseStats.SoundType.class));
                pixelmonSounds.get(species).put(BaseStats.SoundType.Male, (SoundEvent)event);
            }
            for (IEnumForm form : species.getPossibleForms(false)) {
                String suffix;
                if (form.getFormSuffix().isEmpty()) continue;
                String string = suffix = form.getFormSuffix().startsWith("-") ? form.getFormSuffix().substring(1) : form.getFormSuffix();
                if (!json.has(key + "." + suffix)) continue;
                SoundEvent event2 = PixelSounds.registerSound(registry, prefix + species.name.toLowerCase() + "." + suffix);
                pixelmonFormSounds.putIfAbsent(species.getPokemonName() + form.getFormSuffix(), Maps.newEnumMap(BaseStats.SoundType.class));
                pixelmonFormSounds.get(species.getPokemonName() + form.getFormSuffix()).put(BaseStats.SoundType.Neutral, event2);
            }
        }
        if (Pixelmon.devEnvironment) {
            Set<String> cries = json.entrySet().stream().map(Map.Entry::getKey).filter(s -> s.startsWith("pixelmon.mob")).collect(Collectors.toSet());
            for (EnumSpecies species : EnumSpecies.values()) {
                String key = "pixelmon.mob." + species.name.toLowerCase();
                cries.remove(key);
                cries.remove(key + "F");
                cries.remove(key + "M");
                for (IEnumForm form : species.getPossibleForms(false)) {
                    if (form.getFormSuffix().isEmpty()) continue;
                    String suffix = form.getFormSuffix().startsWith("-") ? form.getFormSuffix().substring(1) : form.getFormSuffix();
                    cries.remove(key + "." + suffix);
                }
            }
            cries.forEach(cry -> Pixelmon.LOGGER.warn("Found unlinked sound in sounds.json key: " + cry));
        }
    }

    public static void linkPixelmonSounds() {
        for (EnumSpecies species : EnumSpecies.values()) {
            BaseStats stats = species.getBaseStats();
            if (pixelmonSounds.containsKey(species)) {
                Map<BaseStats.SoundType, SoundEvent> map = pixelmonSounds.get(species);
                if (map.containsKey((Object)BaseStats.SoundType.Neutral)) {
                    stats.addSound(BaseStats.SoundType.Neutral, map.get((Object)BaseStats.SoundType.Neutral));
                }
                if (map.containsKey((Object)BaseStats.SoundType.Female)) {
                    stats.addSound(BaseStats.SoundType.Female, map.get((Object)BaseStats.SoundType.Female));
                }
                if (map.containsKey((Object)BaseStats.SoundType.Male)) {
                    stats.addSound(BaseStats.SoundType.Male, map.get((Object)BaseStats.SoundType.Male));
                }
            }
            for (IEnumForm form : species.getPossibleForms(false)) {
                if (form.getFormSuffix().isEmpty() || !pixelmonFormSounds.containsKey(species.getPokemonName() + form.getFormSuffix())) continue;
                species.getBaseStats(form).addSound(BaseStats.SoundType.Neutral, pixelmonFormSounds.get(species.getPokemonName() + form.getFormSuffix()).get((Object)BaseStats.SoundType.Neutral));
            }
        }
    }
}

