/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.ISpawningTweak;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.api.storage.TransientData;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.spawning.PlayerTrackingSpawner;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.MathHelper;

public class FluteLevelTweak
implements ISpawningTweak {
    @Override
    public void doTweak(AbstractSpawner spawner, SpawnAction<? extends Entity> action) {
        if (!(action instanceof SpawnActionPokemon)) {
            return;
        }
        SpawnActionPokemon spawnActionPokemon = (SpawnActionPokemon)action;
        EntityPixelmon pokemon = (EntityPixelmon)spawnActionPokemon.getOrCreateEntity();
        SpawnActionPokemon actionPokemon = (SpawnActionPokemon)action;
        if (actionPokemon.baseSpec.level != null || !(action.spawnInfo instanceof SpawnInfoPokemon)) {
            return;
        }
        if (pokemon.isBossPokemon()) {
            return;
        }
        int newLevel = this.getTweakedLevel(spawner, actionPokemon, actionPokemon.usingSpec.level);
        pokemon.getPokemonData().setLevel(newLevel);
        pokemon.func_70606_j(pokemon.getPokemonData().getHealth());
    }

    public int getTweakedLevel(AbstractSpawner spawner, SpawnAction<? extends Entity> action, int level) {
        PlayerPartyStorage storage = spawner instanceof PlayerTrackingSpawner ? ((PlayerTrackingSpawner)spawner).playerStorage : Pixelmon.storageManager.getParty((EntityPlayerMP)action.spawnLocation.cause);
        if (storage == null) {
            return level;
        }
        TransientData td = storage.transientData;
        long time = System.currentTimeMillis();
        if (td.isBlackFluteActive(time)) {
            return MathHelper.func_76125_a((int)(level + RandomHelper.rand.nextInt(PixelmonConfig.lureFluteLevelModifier)), (int)1, (int)PixelmonConfig.maxLevel);
        }
        if (td.isWhiteFluteActive(time)) {
            return MathHelper.func_76125_a((int)(level - RandomHelper.rand.nextInt(PixelmonConfig.lureFluteLevelModifier)), (int)1, (int)PixelmonConfig.maxLevel);
        }
        return level;
    }
}

