/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.SpawnerCoordinator;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.spawners.TickingSpawner;
import com.pixelmonmod.pixelmon.api.world.BlockCollection;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PlayerTrackingSpawner
extends TickingSpawner {
    public final UUID playerUUID;
    public PlayerPartyStorage playerStorage;
    public Long lastStorageCheck = 0L;
    protected List<SpawnAction<? extends Entity>> possibleSpawns = new ArrayList<SpawnAction<? extends Entity>>();
    public int minDistFromCentre = PixelmonConfig.minimumDistanceFromCentre;
    public int maxDistFromCentre = PixelmonConfig.maximumDistanceFromCentre;
    public float horizontalTrackFactor = PixelmonConfig.horizontalTrackFactor;
    public float verticalTrackFactor = PixelmonConfig.verticalTrackFactor;
    public int horizontalSliceRadius = PixelmonConfig.horizontalSliceRadius;
    public int verticalSliceRadius = PixelmonConfig.verticalSliceRadius;

    public PlayerTrackingSpawner(EntityPlayerMP player) {
        super(player.func_70005_c_());
        this.playerUUID = player.func_110124_au();
    }

    @Override
    public int getNumPasses() {
        return 2;
    }

    @Nullable
    public EntityPlayerMP getTrackedPlayer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.playerUUID);
    }

    @Override
    public boolean hasCapacity(int numSpawns) {
        if (!super.hasCapacity(numSpawns)) {
            return false;
        }
        int effectiveCapacity = this.capacity;
        int playerSpawnerCount = 0;
        for (AbstractSpawner spawner : PixelmonSpawning.coordinator.spawners) {
            if (!(spawner instanceof PlayerTrackingSpawner)) continue;
            ++playerSpawnerCount;
        }
        if (playerSpawnerCount == 0) {
            return true;
        }
        if (PixelmonConfig.maximumSpawnedPokemon / playerSpawnerCount < effectiveCapacity) {
            effectiveCapacity = Math.min(effectiveCapacity, PixelmonConfig.maximumSpawnedPokemon / playerSpawnerCount);
        }
        return numSpawns + this.spawnedTracker.count() <= effectiveCapacity;
    }

    @Override
    public boolean canSpawn(SpawnAction<?> action) {
        EntityPlayerMP playerByUUID = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.playerUUID);
        if (playerByUUID == null || playerByUUID.field_70128_L || playerByUUID.func_193105_t()) {
            return false;
        }
        if (action instanceof SpawnActionPokemon) {
            EntityPixelmon pixelmon = (EntityPixelmon)((SpawnActionPokemon)action).getOrCreateEntity();
            if (pixelmon == null) {
                Pixelmon.LOGGER.error("Invalid spawnset: " + action);
                return false;
            }
            if (action.spawnInfo.stringLocationTypes != null && action.spawnInfo.stringLocationTypes.contains("Air") || pixelmon.getBaseStats() != null && pixelmon.getBaseStats().getSpawnLocations() != null && pixelmon.getBaseStats().getSpawnLocations().stream().anyMatch(it -> it == SpawnLocationType.Air || it == SpawnLocationType.AirPersistent)) {
                int playerFlyingPokes = this.spawnedTracker.countAllFlyingPoke();
                long maxFlying = PixelmonConfig.maximumSpawnedFlyingPokemonPerPlayer;
                long playerSpawnerCount = PixelmonSpawning.coordinator.spawners.stream().filter(it -> it instanceof PlayerTrackingSpawner).count();
                if (playerSpawnerCount == 0L) {
                    playerSpawnerCount = 1L;
                }
                return (long)(playerFlyingPokes + 1) <= (maxFlying = Math.min(maxFlying, (long)PixelmonConfig.maximumSpawnedFlyingPokemon / playerSpawnerCount));
            }
        }
        return super.canSpawn(action);
    }

    @Override
    public boolean shouldDoSpawning() {
        return super.shouldDoSpawning();
    }

    public boolean isTrackedPlayerOnline() {
        return this.getTrackedPlayer() != null;
    }

    @Override
    public List<SpawnAction<? extends Entity>> getSpawns(int pass) {
        if (pass == 0) {
            this.possibleSpawns = new ArrayList<SpawnAction<? extends Entity>>();
            EntityPlayerMP player = this.getTrackedPlayer();
            if (player != null) {
                if (player.field_70163_u < 0.0 || player.field_70163_u > 255.0) {
                    return null;
                }
                if (this.playerStorage == null) {
                    this.playerStorage = Pixelmon.storageManager.getParty(player);
                    if (this.playerStorage == null) {
                        return null;
                    }
                }
                if (this.lastStorageCheck < System.currentTimeMillis() + 10000L) {
                    if (this.playerStorage != null) {
                        this.playerStorage.updatePartyCache();
                    }
                    this.lastStorageCheck = System.currentTimeMillis();
                    this.spawnedTracker.removeNonExistent();
                }
                BlockCollection collection = this.getTrackedBlockCollection((Entity)player, this.horizontalTrackFactor, this.verticalTrackFactor, this.horizontalSliceRadius, this.verticalSliceRadius, this.minDistFromCentre, this.maxDistFromCentre);
                this.isBusy = true;
                SpawnerCoordinator.PROCESSOR.execute(() -> {
                    ArrayList<SpawnLocation> spawnLocations = this.spawnLocationCalculator.calculateSpawnableLocations(collection);
                    Collections.shuffle(spawnLocations);
                    this.possibleSpawns = this.selectionAlgorithm.calculateSpawnActions(this, this.spawnSets, spawnLocations);
                    this.isBusy = false;
                });
            }
            return null;
        }
        if (this.possibleSpawns == null || this.possibleSpawns.isEmpty()) {
            return null;
        }
        this.possibleSpawns.removeIf(action -> {
            action.applyLocationMutations();
            if (!this.canSpawn((SpawnAction<?>)action)) {
                return true;
            }
            return !action.spawnLocation.location.world.func_175644_a(Entity.class, entity -> entity.func_180425_c().func_185332_f(action.spawnLocation.location.pos.func_177958_n(), action.spawnLocation.location.pos.func_177956_o(), action.spawnLocation.location.pos.func_177952_p()) < (double)this.minDistBetweenSpawns).isEmpty();
        });
        return this.possibleSpawns;
    }

    public static class PlayerTrackingSpawnerBuilder<T extends PlayerTrackingSpawner>
    extends TickingSpawner.TickingSpawnerBuilder<T> {
        public Integer minDistFromCentre = null;
        public Integer maxDistFromCentre = null;
        public Float horizontalTrackFactor = null;
        public Float verticalTrackFactor = null;
        public Integer horizontalSliceRadius = null;
        public Integer verticalSliceRadius = null;

        public <E extends PlayerTrackingSpawnerBuilder<T>> E setDistanceFromCentre(int minimum, int maximum) {
            if (minimum < 0) {
                minimum = 0;
            }
            this.minDistFromCentre = minimum;
            if (maximum < 0) {
                maximum = 0;
            }
            this.maxDistFromCentre = maximum;
            return (E)((PlayerTrackingSpawnerBuilder)this.getThis());
        }

        public <E extends PlayerTrackingSpawnerBuilder<T>> E setTrackFactors(float horizontal, float vertical) {
            this.horizontalTrackFactor = Float.valueOf(horizontal);
            this.verticalTrackFactor = Float.valueOf(vertical);
            return (E)((PlayerTrackingSpawnerBuilder)this.getThis());
        }

        public <E extends PlayerTrackingSpawnerBuilder<T>> E setSliceRadii(int horizontal, int vertical) {
            if (horizontal < 1) {
                horizontal = 1;
            }
            this.horizontalSliceRadius = horizontal;
            if (vertical < 1) {
                vertical = 1;
            }
            this.verticalSliceRadius = vertical;
            return (E)((PlayerTrackingSpawnerBuilder)this.getThis());
        }

        @Override
        public T apply(T spawner) {
            ((PlayerTrackingSpawner)spawner).minDistFromCentre = this.minDistFromCentre != null ? this.minDistFromCentre : PixelmonConfig.minimumDistanceFromCentre;
            ((PlayerTrackingSpawner)spawner).maxDistFromCentre = this.maxDistFromCentre != null ? this.maxDistFromCentre : PixelmonConfig.maximumDistanceFromCentre;
            ((PlayerTrackingSpawner)spawner).verticalTrackFactor = this.verticalTrackFactor != null ? this.verticalTrackFactor.floatValue() : PixelmonConfig.verticalTrackFactor;
            ((PlayerTrackingSpawner)spawner).horizontalTrackFactor = this.horizontalTrackFactor != null ? this.horizontalTrackFactor.floatValue() : PixelmonConfig.horizontalTrackFactor;
            ((PlayerTrackingSpawner)spawner).verticalSliceRadius = this.verticalSliceRadius != null ? this.verticalSliceRadius : PixelmonConfig.verticalSliceRadius;
            ((PlayerTrackingSpawner)spawner).horizontalSliceRadius = this.horizontalSliceRadius != null ? this.horizontalSliceRadius : PixelmonConfig.horizontalSliceRadius;
            PlayerPartyStorage party = Pixelmon.storageManager.getParty(((PlayerTrackingSpawner)spawner).playerUUID);
            ((PlayerTrackingSpawner)spawner).rarityTweaks.add(party);
            super.apply(spawner);
            return spawner;
        }
    }
}

