/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.economy.IPixelmonBankAccount;
import com.pixelmonmod.pixelmon.api.enums.BattleEndTaskResult;
import com.pixelmonmod.pixelmon.api.enums.BattleEndTaskType;
import com.pixelmonmod.pixelmon.api.enums.EnumTriBoolean;
import com.pixelmonmod.pixelmon.api.enums.ServerCosmetics;
import com.pixelmonmod.pixelmon.api.events.EconomyEvent;
import com.pixelmonmod.pixelmon.api.events.PokedexEvent;
import com.pixelmonmod.pixelmon.api.events.PokerusEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.IRarityTweak;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.TransientData;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PixelExtrasDisplayPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.QueryResourceLocationPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.CloseBattle;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.UpdateClientPlayerData;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Pokerus;
import com.pixelmonmod.pixelmon.enums.EnumBerryFlavor;
import com.pixelmonmod.pixelmon.enums.EnumCurryKey;
import com.pixelmonmod.pixelmon.enums.EnumCurryRating;
import com.pixelmonmod.pixelmon.enums.EnumFeatureState;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.enums.EnumMegaItemsUnlocked;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumTrainerCardColor;
import com.pixelmonmod.pixelmon.items.ItemLure;
import com.pixelmonmod.pixelmon.listener.EntityPlayerExtension;
import com.pixelmonmod.pixelmon.pokedex.EnumPokedexRegisterStatus;
import com.pixelmonmod.pixelmon.pokedex.Pokedex;
import com.pixelmonmod.pixelmon.quests.comm.ResetQuests;
import com.pixelmonmod.pixelmon.storage.PlayerStats;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasStorage;
import com.pixelmonmod.pixelmon.storage.playerData.PlayerData;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import com.pixelmonmod.pixelmon.storage.playerData.TeleportPosition;
import com.pixelmonmod.pixelmon.util.helpers.CommonHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlayerPartyStorage
extends PartyStorage
implements IPixelmonBankAccount,
IRarityTweak {
    protected String playerName = null;
    public EnumTrainerCardColor trainerCardColor = EnumTrainerCardColor.WHITE;
    public TeleportPosition teleportPos = new TeleportPosition();
    protected int pokeDollars = 0;
    public Pokedex pokedex = new Pokedex();
    public PlayerStats stats = new PlayerStats();
    public boolean guiOpened = false;
    public boolean battleEnabled = true;
    public boolean starterPicked = false;
    public boolean oldGen = false;
    private int ticksTillEncounter;
    private EnumMegaItemsUnlocked megaItemsUnlocked = EnumMegaItemsUnlocked.None;
    private EnumMegaItem megaItem = EnumMegaItem.Disabled;
    private ItemStack lure = ItemStack.field_190927_a;
    private EnumFeatureState shinyCharm = EnumFeatureState.Disabled;
    private EnumFeatureState ovalCharm = EnumFeatureState.Disabled;
    private EnumFeatureState expCharm = EnumFeatureState.Disabled;
    private EnumFeatureState catchingCharm = EnumFeatureState.Disabled;
    private EnumFeatureState markCharm = EnumFeatureState.Disabled;
    private EnumSet<ServerCosmetics> serverCosmetics = EnumSet.noneOf(ServerCosmetics.class);
    private int[] curryData = new int[26];
    private HashMap<EnumSpecies, int[]> megasObtained = new HashMap();
    public PlayerData playerData = new PlayerData();
    private QuestData questData = new QuestData();
    public transient TransientData transientData = new TransientData();

    public PlayerPartyStorage(UUID uuid, boolean shouldSendUpdates) {
        super(uuid);
        this.shouldSendUpdates = shouldSendUpdates;
        this.pokedex.setUUID(uuid);
        if (shouldSendUpdates) {
            this.tryUpdatePlayerName();
        }
    }

    public PlayerPartyStorage(UUID uuid) {
        this(uuid, true);
    }

    @Override
    public boolean add(Pokemon pokemon) {
        if (!super.add(pokemon)) {
            PCStorage pc = Pixelmon.storageManager.getPCForPlayer(this.uuid);
            EntityPlayerMP player = this.getPlayer();
            if (player != null) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("pixelmon.storage.partyfull", new Object[]{pokemon.getDisplayName()}));
            }
            if (!pc.add(pokemon)) {
                if (player != null) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("pixelmon.storage.compfull", new Object[0]));
                }
                return false;
            }
        }
        return true;
    }

    public EnumTriBoolean addSilently(Pokemon pokemon) {
        if (!super.add(pokemon)) {
            PCStorage pc = Pixelmon.storageManager.getPCForPlayer(this.uuid);
            return pc.add(pokemon) ? EnumTriBoolean.FALSE : EnumTriBoolean.NULL;
        }
        return EnumTriBoolean.TRUE;
    }

    public void tryUpdatePlayerName() {
        EntityPlayerMP player;
        if (this.shouldSendUpdates && (player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.uuid)) != null) {
            this.playerName = player.func_70005_c_();
        }
    }

    @Nullable
    public EntityPlayerMP getPlayer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance() == null ? null : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.uuid);
    }

    @Nullable
    public String getPlayerName() {
        return this.playerName;
    }

    public UUID getPlayerUUID() {
        return this.uuid;
    }

    @Override
    public void set(StoragePosition position, Pokemon pokemon) {
        super.set(position, pokemon);
        if (pokemon != null && this.playerName != null && (pokemon.getOriginalTrainer() == null || pokemon.getOriginalTrainer().equals(this.playerName) && pokemon.getOriginalTrainerUUID() == null)) {
            pokemon.setOriginalTrainer(this.uuid, this.playerName);
        }
        if (this.getShouldSendUpdates()) {
            if (this.getPlayer() != null) {
                EntityPlayerExtension.updatePlayerPokeballs(this.getPlayer(), this.getAll());
            }
            if (pokemon != null && !pokemon.isEgg() && this.pokedex.getSeenMap().get(pokemon.getSpecies().getNationalPokedexInteger()) != EnumPokedexRegisterStatus.caught && !Pixelmon.EVENT_BUS.post((Event)new PokedexEvent(this.uuid, pokemon, EnumPokedexRegisterStatus.caught, "storageMovement"))) {
                this.pokedex.set(pokemon, EnumPokedexRegisterStatus.caught);
                this.pokedex.update();
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.playerName != null) {
            nbt.func_74778_a("player", this.playerName);
        }
        this.playerData.writeToNBT(nbt);
        this.teleportPos.writeToNBT(nbt);
        nbt.func_74783_a("curryDex", this.curryData);
        nbt.func_74768_a("pixelDollars", this.pokeDollars);
        nbt.func_74768_a("trainerCardColor", this.trainerCardColor.ordinal());
        nbt.func_74757_a("starterPicked", this.starterPicked);
        nbt.func_74757_a("oldGen", this.oldGen);
        this.pokedex.writeToNBT(nbt);
        this.stats.writeToNBT(nbt);
        nbt.func_74768_a("TicksTillNextEncounter", this.ticksTillEncounter);
        nbt.func_74778_a("MegaItemString", this.megaItem.toString());
        if (this.megaItem.canEvolve() && this.megaItemsUnlocked.isNone()) {
            this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.Mega);
        }
        nbt.func_74768_a("MegaItemsUnlocked", this.megaItemsUnlocked.ordinal());
        nbt.func_74768_a("ShinyCharmID", this.shinyCharm.ordinal());
        nbt.func_74768_a("OvalCharmID", this.ovalCharm.ordinal());
        nbt.func_74768_a("ExpCharmID", this.expCharm.ordinal());
        nbt.func_74768_a("CatchingCharmID", this.catchingCharm.ordinal());
        nbt.func_74768_a("MarkCharmID", this.markCharm.ordinal());
        BitSet set = new BitSet();
        for (ServerCosmetics serverCosmetics : this.serverCosmetics) {
            set.set(serverCosmetics.ordinal());
        }
        nbt.func_74773_a("ServCosm", set.toByteArray());
        NBTTagList tagList = new NBTTagList();
        for (EnumSpecies pokemon : this.megasObtained.keySet()) {
            NBTTagCompound megaObtainedNBT = new NBTTagCompound();
            megaObtainedNBT.func_74778_a("Name", pokemon.toString());
            int[] forms = this.megasObtained.get(pokemon);
            megaObtainedNBT.func_74783_a("Variant", forms);
            tagList.func_74742_a((NBTBase)megaObtainedNBT);
        }
        nbt.func_74782_a("MegasObtained", (NBTBase)tagList);
        this.questData.writeToNBT(nbt);
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        this.lure.func_77955_b(nBTTagCompound);
        nbt.func_74782_a("Lure", (NBTBase)nBTTagCompound);
        return super.writeToNBT(nbt);
    }

    @Override
    public PlayerPartyStorage readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.playerName = nbt.func_74779_i("player");
        this.playerData.readFromNBT(nbt);
        this.teleportPos.readFromNBT(nbt);
        this.pokeDollars = nbt.func_74762_e("pixelDollars");
        this.trainerCardColor = EnumTrainerCardColor.values()[nbt.func_74762_e("trainerCardColor")];
        if (nbt.func_74764_b("curryDex")) {
            this.curryData = nbt.func_74759_k("curryDex");
        }
        if (nbt.func_74764_b("starterPicked")) {
            this.starterPicked = nbt.func_74767_n("starterPicked");
        }
        if (nbt.func_74764_b("oldGen")) {
            this.oldGen = nbt.func_74767_n("oldGen");
        }
        if (nbt.func_74764_b("MegaItemString")) {
            this.setMegaItem(EnumMegaItem.getFromString(nbt.func_74779_i("MegaItemString")), false);
        }
        if (nbt.func_74764_b("MegaItemsUnlocked")) {
            this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.values()[nbt.func_74762_e("MegaItemsUnlocked")]);
        } else if (this.getMegaItem().canEvolve()) {
            this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.Mega);
        }
        if (nbt.func_74764_b("ShinyCharmID")) {
            this.setShinyCharm(EnumFeatureState.values()[nbt.func_74762_e("ShinyCharmID")]);
        }
        if (nbt.func_74764_b("OvalCharmID")) {
            this.setOvalCharm(EnumFeatureState.values()[nbt.func_74762_e("OvalCharmID")]);
        }
        if (nbt.func_74764_b("ExpCharmID")) {
            this.setExpCharm(EnumFeatureState.values()[nbt.func_74762_e("ExpCharmID")]);
        }
        if (nbt.func_74764_b("CatchingCharmID")) {
            this.setCatchingCharm(EnumFeatureState.values()[nbt.func_74762_e("CatchingCharmID")]);
        }
        if (nbt.func_74764_b("MarkCharmID")) {
            this.setMarkCharm(EnumFeatureState.values()[nbt.func_74762_e("MarkCharmID")]);
        }
        this.serverCosmetics.clear();
        if (nbt.func_74764_b("HweenRobe")) {
            this.serverCosmetics.add(ServerCosmetics.DROWNED_ROBE);
        }
        if (nbt.func_74764_b("ServCosm")) {
            BitSet set = BitSet.valueOf(nbt.func_74770_j("ServCosm"));
            for (ServerCosmetics cosmetics : ServerCosmetics.values()) {
                if (!set.get(cosmetics.ordinal())) continue;
                this.serverCosmetics.add(cosmetics);
            }
        }
        this.pokedex.readFromNBT(nbt);
        this.stats.readFromNBT(nbt);
        if (nbt.func_74764_b("MegasObtained")) {
            NBTTagList list = nbt.func_150295_c("MegasObtained", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound megaInfo = (NBTTagCompound)list.func_179238_g(i);
                EnumSpecies pokemon = EnumSpecies.get(megaInfo.func_74779_i("Name"));
                int[] forms = megaInfo.func_74759_k("Variant");
                this.megasObtained.put(pokemon, forms);
            }
        }
        this.questData.readFromNBT(nbt);
        if (nbt.func_74764_b("Lure")) {
            ItemStack lure;
            NBTTagCompound lureTag = nbt.func_74775_l("Lure");
            this.lure = lure = new ItemStack(lureTag);
        }
        return this;
    }

    @Override
    public List<EntityPlayerMP> getPlayersToUpdate() {
        EntityPlayerMP player = this.getPlayer();
        if (player == null) {
            return new ArrayList<EntityPlayerMP>();
        }
        return Lists.newArrayList((Object[])new EntityPlayerMP[]{player});
    }

    @Override
    public boolean getShouldSave() {
        if (this.getPlayer() == null) {
            return true;
        }
        return super.getShouldSave();
    }

    @Override
    public int[] getCurryData() {
        return this.curryData;
    }

    @Override
    public void updateSingleCurryData(EnumCurryKey curryKey, EnumBerryFlavor cookingFlavor, EnumCurryRating rating) {
        byte[] cd = CommonHelper.decodeInteger(this.curryData[curryKey.ordinal()], 3);
        if (cd[cookingFlavor.ordinal()] < rating.ordinal() + 1) {
            cd[cookingFlavor.ordinal()] = (byte)(rating.ordinal() + 1);
            this.curryData[curryKey.ordinal()] = CommonHelper.encodeInteger(cd, 3);
        }
    }

    public boolean isMegaItemObtained(EnumSpecies pokemon, int form) {
        if (this.megasObtained.containsKey(pokemon)) {
            for (int f : this.megasObtained.get(pokemon)) {
                if (f != form) continue;
                return true;
            }
        }
        return false;
    }

    public void obtainedItem(EnumSpecies pokemon, int form, EntityPlayerMP player) {
        if (this.megasObtained.containsKey(pokemon)) {
            int[] forms;
            for (int f : forms = this.megasObtained.get(pokemon)) {
                if (f != form) continue;
                return;
            }
            int[] newForms = new int[forms.length + 1];
            System.arraycopy(forms, 0, newForms, 0, forms.length);
            newForms[newForms.length - 1] = form;
            this.megasObtained.put(pokemon, newForms);
        } else {
            this.megasObtained.put(pokemon, new int[]{form});
        }
        this.unlockMega();
    }

    public void setMegaItem(EnumMegaItem megaItem, boolean giveChoice) {
        this.setMegaItem(megaItem, giveChoice ? 0 : -1);
    }

    public void setMegaItem(EnumMegaItem megaItem, int giveChoice) {
        this.megaItem = megaItem;
        if (this.getPlayer() != null) {
            if (giveChoice >= 0) {
                Pixelmon.network.sendTo((IMessage)new UpdateClientPlayerData(this.megaItem, giveChoice), this.getPlayer());
            }
            EntityPlayerExtension.updatePlayerMegaItem(this.getPlayer(), this.megaItem);
        }
        this.setNeedsSaving();
    }

    public void unlockMega() {
        if (!this.getMegaItemsUnlocked().canMega()) {
            if (this.getMegaItemsUnlocked().canDynamax()) {
                this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.Both);
            } else {
                this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.Mega);
                this.setMegaItem(EnumMegaItem.None, true);
            }
        }
    }

    public void lockMega() {
        if (this.getMegaItemsUnlocked().canMega()) {
            if (this.getMegaItemsUnlocked().canDynamax()) {
                this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.Dynamax);
                if (this.getMegaItem().canMega()) {
                    this.setMegaItem(EnumMegaItem.None, false);
                }
            } else {
                this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.None);
            }
        }
    }

    public void unlockDynamax() {
        if (!this.getMegaItemsUnlocked().canDynamax()) {
            if (this.getMegaItemsUnlocked().canMega()) {
                this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.Both);
            } else {
                this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.Dynamax);
                this.setMegaItem(EnumMegaItem.None, true);
            }
        }
    }

    public void lockDynamax() {
        if (this.getMegaItemsUnlocked().canDynamax()) {
            if (this.getMegaItemsUnlocked().canMega()) {
                this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.Mega);
                if (this.getMegaItem().canDynamax()) {
                    this.setMegaItem(EnumMegaItem.None, false);
                }
            } else {
                this.setMegaItemsUnlocked(EnumMegaItemsUnlocked.None);
            }
        }
    }

    public void setMegaItemsUnlocked(EnumMegaItemsUnlocked megaItemsUnlocked) {
        this.megaItemsUnlocked = megaItemsUnlocked;
        if (this.getPlayer() != null) {
            EntityPlayerExtension.updatePlayerMegaItemsUnlocked(this.getPlayer(), this.megaItemsUnlocked);
        }
        this.setNeedsSaving();
    }

    public void setShinyCharm(EnumFeatureState shinyCharm) {
        this.shinyCharm = shinyCharm;
        if (this.getPlayer() != null) {
            EntityPlayerExtension.updatePlayerShinyCharm(this.getPlayer(), this.shinyCharm);
        }
        this.setNeedsSaving();
    }

    public void setOvalCharm(EnumFeatureState ovalCharm) {
        this.ovalCharm = ovalCharm;
        if (this.getPlayer() != null) {
            EntityPlayerExtension.updatePlayerOvalCharm(this.getPlayer(), this.ovalCharm);
        }
        this.setNeedsSaving();
    }

    public void setExpCharm(EnumFeatureState expCharm) {
        this.expCharm = expCharm;
        if (this.getPlayer() != null) {
            EntityPlayerExtension.updatePlayerExpCharm(this.getPlayer(), this.expCharm);
        }
        this.setNeedsSaving();
    }

    public void setCatchingCharm(EnumFeatureState catchingCharm) {
        this.catchingCharm = catchingCharm;
        if (this.getPlayer() != null) {
            EntityPlayerExtension.updatePlayerCatchingCharm(this.getPlayer(), this.catchingCharm);
        }
        this.setNeedsSaving();
    }

    public void setMarkCharm(EnumFeatureState markCharm) {
        this.markCharm = markCharm;
        if (this.getPlayer() != null) {
            EntityPlayerExtension.updatePlayerMarkCharm(this.getPlayer(), this.markCharm);
        }
        this.setNeedsSaving();
    }

    @Deprecated
    public void setHweenRobe(EnumFeatureState hweenRobe) {
        if (hweenRobe.isAvailable()) {
            this.grantServerCosmetics(ServerCosmetics.DROWNED_ROBE);
        } else {
            this.revokeServerCosmetics(ServerCosmetics.DROWNED_ROBE);
        }
        this.setNeedsSaving();
    }

    public boolean canEquipMegaItem() {
        return this.megaItem != EnumMegaItem.Disabled;
    }

    public EnumMegaItem getMegaItem() {
        return this.megaItem;
    }

    public EnumMegaItemsUnlocked getMegaItemsUnlocked() {
        return this.megaItemsUnlocked;
    }

    public EnumFeatureState getShinyCharm() {
        return this.shinyCharm;
    }

    public EnumFeatureState getOvalCharm() {
        return this.ovalCharm;
    }

    public EnumFeatureState getExpCharm() {
        return this.expCharm;
    }

    public EnumFeatureState getCatchingCharm() {
        return this.catchingCharm;
    }

    public EnumFeatureState getMarkCharm() {
        return this.markCharm;
    }

    @Deprecated
    public EnumFeatureState getHweenRobe() {
        if (this.getServerCosmetics().contains((Object)ServerCosmetics.DROWNED_ROBE)) {
            return EnumFeatureState.Available;
        }
        return EnumFeatureState.Disabled;
    }

    public Set<ServerCosmetics> getServerCosmetics() {
        return ImmutableSet.copyOf(this.serverCosmetics);
    }

    public void setServerCosmetics(Set<ServerCosmetics> cosmetics) {
        this.serverCosmetics = cosmetics.isEmpty() ? EnumSet.noneOf(ServerCosmetics.class) : EnumSet.copyOf(cosmetics);
        PixelExtrasData data = PixelExtrasStorage.getData(this.uuid);
        data.updateServerCosmetics(this.serverCosmetics);
        Pixelmon.network.sendToAll((IMessage)new PixelExtrasDisplayPacket(data));
        this.setNeedsSaving();
    }

    public void grantServerCosmetics(ServerCosmetics ... cosmetics) {
        this.serverCosmetics.addAll(Arrays.asList(cosmetics));
        PixelExtrasData data = PixelExtrasStorage.getData(this.uuid);
        data.updateServerCosmetics(this.serverCosmetics);
        Pixelmon.network.sendToAll((IMessage)new PixelExtrasDisplayPacket(data));
        this.setNeedsSaving();
    }

    public void revokeServerCosmetics(ServerCosmetics ... cosmetics) {
        this.serverCosmetics.removeAll(Arrays.asList(cosmetics));
        PixelExtrasData data = PixelExtrasStorage.getData(this.uuid);
        data.updateServerCosmetics(this.serverCosmetics);
        Pixelmon.network.sendToAll((IMessage)new PixelExtrasDisplayPacket(data));
        this.setNeedsSaving();
    }

    public ItemStack getLureStack() {
        return this.lure;
    }

    @Nullable
    public ItemLure getLure() {
        if (this.lure.func_77973_b() instanceof ItemLure) {
            return (ItemLure)this.lure.func_77973_b();
        }
        return null;
    }

    public void setLureStack(ItemStack stack) {
        EntityPlayerMP player;
        if (stack != null && !stack.func_190926_b() && !(stack.func_77973_b() instanceof ItemLure)) {
            return;
        }
        this.lure = stack == null || stack.func_190926_b() ? ItemStack.field_190927_a : stack;
        this.setHasChanged(true);
        if (this.getShouldSendUpdates() && (player = this.getPlayer()) != null) {
            Pixelmon.network.sendTo((IMessage)new UpdateClientPlayerData(this.lure), player);
        }
    }

    public void setLure(ItemLure lure) {
        if (lure == null) {
            this.setLureStack(ItemStack.field_190927_a);
        } else {
            this.setLureStack(new ItemStack((Item)lure));
        }
    }

    private void setCurrency(int amount) {
        if (this.pokeDollars == amount) {
            return;
        }
        this.pokeDollars = amount;
        if (this.pokeDollars > 999999) {
            this.pokeDollars = 999999;
        } else if (this.pokeDollars < 0) {
            this.pokeDollars = 0;
        }
        this.updatePlayer(this.pokeDollars);
        this.setNeedsSaving();
    }

    @Override
    public int getMoney() {
        EconomyEvent.GetBalanceEvent getBalanceEvent = new EconomyEvent.GetBalanceEvent(this.getPlayer(), this.pokeDollars);
        Pixelmon.EVENT_BUS.post((Event)getBalanceEvent);
        return getBalanceEvent.balance;
    }

    @Override
    public void setMoney(int amount) {
        this.setCurrency(amount);
    }

    @Override
    public int changeMoney(int change) {
        int oldBalance = this.pokeDollars;
        EconomyEvent.transactionType type = change < 0 ? EconomyEvent.transactionType.withdraw : EconomyEvent.transactionType.deposit;
        EconomyEvent.PreTransactionEvent preEvent = new EconomyEvent.PreTransactionEvent(this.getPlayer(), type, this.pokeDollars, change);
        if (!Pixelmon.EVENT_BUS.post((Event)preEvent)) {
            this.setCurrency(this.pokeDollars + preEvent.change);
            Pixelmon.EVENT_BUS.post((Event)new EconomyEvent.PostTransactionEvent(this.getPlayer(), type, oldBalance, this.pokeDollars));
        }
        return this.pokeDollars;
    }

    @Override
    public UUID getOwnerUUID() {
        return this.uuid;
    }

    public void updatePartyCache() {
        this.transientData.lowestLevel = 100;
        this.transientData.highestLevel = 1;
        this.transientData.averageLevel = 0;
        int count = 0;
        for (Pokemon pokemon : this.party) {
            if (pokemon == null || pokemon.isEgg()) continue;
            int level = pokemon.getLevel();
            ++count;
            this.transientData.averageLevel += level;
            this.transientData.lowestLevel = Math.min(this.transientData.lowestLevel, level);
            this.transientData.highestLevel = Math.max(this.transientData.highestLevel, level);
        }
        if (count == 0) {
            this.transientData.averageLevel = 50;
            this.transientData.lowestLevel = 1;
            this.transientData.highestLevel = 100;
        } else {
            this.transientData.averageLevel /= count;
        }
    }

    public int getTicksTillEncounter() {
        return this.ticksTillEncounter;
    }

    public void updateTicksTillEncounter() {
        this.ticksTillEncounter = this.ticksTillEncounter <= 1 ? this.getPlayer().func_70681_au().nextInt(900) + 100 : --this.ticksTillEncounter;
    }

    public void checkPokerus() {
        EntityPlayerMP player = this.getPlayer();
        for (Pokemon pokemon : this.getAll()) {
            int seconds;
            int duration;
            Pokerus pokerus;
            if (pokemon == null || pokemon.isEgg() || pokemon.getPokerus() == null || !(pokerus = pokemon.getPokerus()).canInfect() || (duration = pokerus.type.duration) <= -1 || (seconds = pokerus.secondsSinceInfection) == -1 || seconds >= duration) continue;
            if (++seconds >= duration) {
                pokerus.secondsSinceInfection = -1;
                Pixelmon.EVENT_BUS.post((Event)new PokerusEvent.Cured(player, pokemon, this));
            } else {
                pokerus.secondsSinceInfection = seconds;
            }
            pokemon.markDirty(EnumUpdateType.Pokerus);
        }
    }

    @Override
    public float getMultiplier(AbstractSpawner spawner, SpawnInfo spawnInfo, float sum, float rarity) {
        float modifiedValue = 1.0f;
        if (this.getLure() != null) {
            modifiedValue *= this.getLure().getMultiplier(spawner, spawnInfo, sum, rarity);
        }
        if (this.getTeam().size() > 0) {
            modifiedValue *= this.getTeam().get(0).getAbility().getMultiplier(spawner, spawnInfo, sum, rarity);
        }
        return modifiedValue;
    }

    public QuestData getQuestData(boolean update) {
        return this.questData.get(this.getPlayer(), update);
    }

    public QuestData getQuestData() {
        return this.getQuestData(true);
    }

    public void resetQuestData() {
        this.questData = new QuestData();
        if (!(this.getPlayer() instanceof FakePlayer)) {
            Pixelmon.network.sendTo((IMessage)new ResetQuests(), this.getPlayer());
        }
        this.getQuestData(true);
    }

    public void closeBattleSafely() {
        if (!(this.getPlayer() instanceof FakePlayer)) {
            Pixelmon.network.sendTo((IMessage)new CloseBattle(), this.getPlayer());
        }
    }

    public BattleEndTaskResult addTaskForBattleEnd(BattleEndTaskType type, Consumer<Optional<BattleControllerBase>> consumer) {
        if (this.guiOpened || type == BattleEndTaskType.ALWAYS_QUEUE) {
            this.transientData.onceBattleDone.add(consumer);
            return BattleEndTaskResult.QUEUED;
        }
        if (type == BattleEndTaskType.QUEUE_IF_BATTLE_OTHERWISE_RUN) {
            consumer.accept(Optional.empty());
            return BattleEndTaskResult.EXECUTED;
        }
        return BattleEndTaskResult.IGNORED;
    }

    @Deprecated
    public void addTaskForBattleEnd(Consumer<Optional<BattleControllerBase>> consumer) {
        this.addTaskForBattleEnd(BattleEndTaskType.QUEUE_IF_BATTLE_OTHERWISE_RUN, consumer);
    }

    public void queryResourceLocationExistence(ResourceLocation resource, Consumer<Boolean> result) {
        EntityPlayerMP player = this.getPlayer();
        if (player != null) {
            UUID query = UUID.randomUUID();
            this.transientData.resourceQueries.put(query, result);
            Pixelmon.network.sendTo((IMessage)new QueryResourceLocationPacket(query, resource), player);
        }
    }

    public void receiveResourceLocationQueryResult(UUID query, boolean result) {
        Consumer<Boolean> consumer = this.transientData.resourceQueries.remove(query);
        if (consumer != null) {
            consumer.accept(result);
        }
    }

    public void registerKeyListener(Object instance, Method callback) {
        this.transientData.keyListener = new Tuple(instance, (Object)callback);
    }

    public void receiveKeyInput(int code, char key) {
        if (this.transientData.keyListener != null) {
            EntityPlayerMP player = this.getPlayer();
            if (player == null || player.field_71070_bA == player.field_71069_bz || player.field_71070_bA == null) {
                this.deregisterKeyListener();
            } else {
                try {
                    ((Method)this.transientData.keyListener.func_76340_b()).invoke(this.transientData.keyListener.func_76341_a(), code, Character.valueOf(key));
                }
                catch (Exception e) {
                    Pixelmon.LOGGER.error("Key listener error: " + this.uuid.toString() + ", " + this.playerName);
                }
            }
        }
    }

    public void deregisterKeyListener() {
        this.transientData.keyListener = null;
    }
}

