/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage;

import com.pixelmonmod.pixelmon.enums.EnumType;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerStats {
    private int wins;
    private int losses;
    private int totalExp;
    private int totalKills;
    private int currentExp;
    private int currentKills;
    private int totalBred;
    private int totalHatched;
    private int totalEvolved;
    private HashMap<String, Integer> caughtTypeCount = new HashMap();

    public PlayerStats() {
        for (EnumType type : EnumType.values()) {
            this.caughtTypeCount.put(type.func_176610_l(), 0);
        }
    }

    public static void getNBTTags(HashMap<String, Class> tags) {
        tags.put("Wins", Integer.class);
        tags.put("Losses", Integer.class);
        tags.put("TotalExp", Integer.class);
        tags.put("CurrentExp", Integer.class);
        tags.put("TotalKills", Integer.class);
        tags.put("CurrentKills", Integer.class);
        tags.put("TotalBred", Integer.class);
        tags.put("TotalHatched", Integer.class);
        tags.put("CaughtTypeCount", NBTTagCompound.class);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Wins", this.wins);
        nbt.func_74768_a("Losses", this.losses);
        nbt.func_74768_a("TotalExp", this.totalExp);
        nbt.func_74768_a("CurrentExp", this.currentExp);
        nbt.func_74768_a("TotalKills", this.totalKills);
        nbt.func_74768_a("CurrentKills", this.currentKills);
        nbt.func_74768_a("TotalBred", this.totalBred);
        nbt.func_74768_a("TotalHatched", this.totalHatched);
        NBTTagCompound caughtTypeNBT = new NBTTagCompound();
        this.caughtTypeCount.forEach((arg_0, arg_1) -> ((NBTTagCompound)caughtTypeNBT).func_74768_a(arg_0, arg_1));
        nbt.func_74782_a("CaughtTypeCount", (NBTBase)caughtTypeNBT);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.wins = nbt.func_74762_e("Wins");
        this.losses = nbt.func_74762_e("Losses");
        this.totalExp = nbt.func_74762_e("TotalExp");
        this.currentExp = nbt.func_74762_e("CurrentExp");
        this.totalKills = nbt.func_74762_e("TotalKills");
        this.currentKills = nbt.func_74762_e("CurrentKills");
        this.totalBred = nbt.func_74762_e("TotalBred");
        this.totalHatched = nbt.func_74762_e("TotalHatched");
        NBTTagCompound caughtTypeNBT = nbt.func_74764_b("CaughtTypeCount") ? nbt.func_74775_l("CaughtTypeCount") : new NBTTagCompound();
        for (EnumType type : EnumType.values()) {
            int count = 0;
            if (caughtTypeNBT.func_74764_b(type.func_176610_l())) {
                count = caughtTypeNBT.func_74762_e(type.func_176610_l());
            }
            this.caughtTypeCount.put(type.func_176610_l(), count);
        }
    }

    public void addWin() {
        ++this.wins;
    }

    public void addLoss() {
        ++this.losses;
    }

    public void addKill() {
        ++this.totalKills;
        ++this.currentKills;
    }

    public int getCurrentKills() {
        return this.currentKills;
    }

    public void setCurrentKills(int currentKills) {
        this.currentKills = currentKills;
    }

    public int getTotalExp() {
        return this.totalExp;
    }

    public void setTotalExp(int totalExp) {
        this.totalExp = totalExp;
    }

    public int getTotalKills() {
        return this.totalKills;
    }

    public void setTotalKills(int totalKills) {
        this.totalKills = totalKills;
    }

    public int getCurrentExp() {
        return this.currentExp;
    }

    public void setCurrentExp(int currentExp) {
        this.currentExp = currentExp;
    }

    public int getWins() {
        return this.wins;
    }

    public void setWins(int wins) {
        this.wins = wins;
    }

    public int getLosses() {
        return this.losses;
    }

    public void setLosses(int losses) {
        this.losses = losses;
    }

    public void addExp(int amount) {
        this.totalExp += amount;
        this.currentExp += amount;
    }

    public void setExp(int exp) {
        this.currentExp = exp;
    }

    public void resetWinLoss() {
        this.wins = 0;
        this.losses = 0;
    }

    public int getTotalBred() {
        return this.totalBred;
    }

    public void setTotalBred(int totalBred) {
        this.totalBred = totalBred;
    }

    public void addToTotalBred() {
        ++this.totalBred;
    }

    public int getTotalHatched() {
        return this.totalHatched;
    }

    public void setTotalHatched(int totalHatched) {
        this.totalHatched = totalHatched;
    }

    public void addHatched() {
        ++this.totalHatched;
    }

    public int getTotalEvolved() {
        return this.totalEvolved;
    }

    public void setTotalEvolved(int totalEvolved) {
        this.totalEvolved = totalEvolved;
    }

    public HashMap<String, Integer> getCaughtTypeCount() {
        return this.caughtTypeCount;
    }

    public void setCaughtTypeCount(HashMap<String, Integer> caughtTypeCount) {
        this.caughtTypeCount = caughtTypeCount;
    }

    public void addCaughtType(EnumType type) {
        int count = this.caughtTypeCount.get(type.func_176610_l()) + 1;
        this.caughtTypeCount.put(type.func_176610_l(), count);
    }

    public void addCaughtTypes(ArrayList<EnumType> types) {
        for (EnumType type : types) {
            int count = this.caughtTypeCount.get(type.func_176610_l()) + 1;
            this.caughtTypeCount.put(type.func_176610_l(), count);
        }
    }
}

