/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.extras;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PixelExtrasDisplayPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.RequestExtrasDisplayData;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.storage.extras.ExtrasContact;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlayerExtraDataStore {
    private static PixelExtrasData client = new PixelExtrasData(Minecraft.func_71410_x().func_110432_I().func_148256_e().getId());
    private static final Map<UUID, PixelExtrasData> playerExtras = new HashMap<UUID, PixelExtrasData>();

    public static void add(PixelExtrasData data) {
        if (Objects.equals(PlayerExtraDataStore.client.id, data.id)) {
            client.updateServerCosmetics(data.getServerCosmetics());
            return;
        }
        playerExtras.put(data.id, data);
    }

    public static PixelExtrasData get(EntityPlayer player) {
        return PlayerExtraDataStore.get(player.func_110124_au());
    }

    public static PixelExtrasData get(UUID uuid) {
        if (Objects.equals(PlayerExtraDataStore.client.id, uuid)) {
            return client;
        }
        if (!playerExtras.containsKey(uuid)) {
            playerExtras.put(uuid, new PixelExtrasData(uuid));
            Pixelmon.network.sendToServer((IMessage)new RequestExtrasDisplayData(uuid));
        }
        return playerExtras.get(uuid);
    }

    public static boolean canSeeTexture(EntityPlayer owner, EnumSpecies species) {
        return owner != null && PlayerExtraDataStore.get(owner).canSeeTexture(species);
    }

    public static void refreshClient(Consumer<PixelExtrasData> consumer) {
        ExtrasContact.updateSelf(client, true, consumer.andThen(data -> PlayerExtraDataStore.saveAndRefresh()));
    }

    public static void saveAndSend() {
        PlayerExtraDataStore.sendDisplayPacket();
        PlayerExtraDataStore.saveClientData();
    }

    public static void saveAndRefresh() {
        PlayerExtraDataStore.saveClientData();
        if (client.isReady() && client.hasData()) {
            PixelExtrasDisplayPacket packet = new PixelExtrasDisplayPacket(client);
            packet.dataHash = -1;
            Pixelmon.network.sendToServer((IMessage)packet);
        }
    }

    public static void sendDisplayPacket() {
        if (client.isReady() && client.hasData()) {
            Pixelmon.network.sendToServer((IMessage)new PixelExtrasDisplayPacket(client));
        }
    }

    public static void loadClientData() {
        UUID uuid = Minecraft.func_71410_x().func_110432_I().func_148256_e().getId();
        PixelExtrasData data = new PixelExtrasData(uuid);
        File file = new File(Minecraft.func_71410_x().field_71412_D, "pixel.dat");
        if (file.exists()) {
            NBTTagCompound compound = new NBTTagCompound();
            try (FileInputStream in = new FileInputStream(file);){
                compound = CompressedStreamTools.func_74796_a((InputStream)in);
            }
            catch (IOException e) {
                System.out.println(file.getAbsolutePath());
                e.printStackTrace();
            }
            if (compound.func_74764_b(uuid.toString())) {
                NBTTagCompound nbt = compound.func_74775_l(uuid.toString());
                ExtrasContact.updateSelf(data, false, newData -> {
                    client = newData;
                    newData.setHatType(PixelExtrasData.HatType.getFromId(nbt.func_74771_c("hatType")));
                    newData.setMonocleType(PixelExtrasData.MonocleType.getFromId(nbt.func_74771_c("monocleType")));
                    if (nbt.func_74764_b("sashType")) {
                        newData.setSashType(PixelExtrasData.SashType.values()[nbt.func_74771_c("sashType")]);
                    }
                    if (nbt.func_74764_b("robeType")) {
                        newData.setRobeType(PixelExtrasData.RobeType.values()[nbt.func_74771_c("robeType")]);
                    }
                    if (nbt.func_74764_b("sphealType")) {
                        newData.setSphealType(PixelExtrasData.SphealType.values()[nbt.func_74771_c("sphealType")]);
                    }
                    for (PixelExtrasData.Category category : PixelExtrasData.Category.values()) {
                        if (nbt.func_74764_b("en" + category.name().toLowerCase())) {
                            newData.setEnabled(category, nbt.func_74767_n("en" + category.name().toLowerCase()));
                        } else {
                            newData.setEnabled(category, true);
                        }
                        if (!nbt.func_74764_b("c" + category.name().toLowerCase())) continue;
                        newData.setColours(category, nbt.func_74759_k("c" + category.name().toLowerCase()));
                    }
                    PlayerExtraDataStore.saveClientData();
                });
                return;
            }
        }
        ExtrasContact.updateSelf(data, true, newData -> {
            client = newData;
            PlayerExtraDataStore.saveClientData();
        });
    }

    public static void saveClientData() {
        File file = new File(Minecraft.func_71410_x().field_71412_D, "pixel.dat");
        NBTTagCompound compound = new NBTTagCompound();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            PixelExtrasData.Category[] categoryArray = null;
            try (FileInputStream in = new FileInputStream(file);){
                compound = CompressedStreamTools.func_74796_a((InputStream)in);
            }
            catch (Throwable object) {
                categoryArray = object;
                throw object;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("hatType", (byte)PlayerExtraDataStore.client.getHatType().id);
        nbt.func_74774_a("monocleType", (byte)PlayerExtraDataStore.client.getMonocleType().id);
        if (PlayerExtraDataStore.client.sashType != null) {
            nbt.func_74774_a("sashType", (byte)client.getSashType().ordinal());
        }
        if (PlayerExtraDataStore.client.robeType != null) {
            nbt.func_74774_a("robeType", (byte)client.getRobeType().ordinal());
        }
        if (PlayerExtraDataStore.client.sphealType != null) {
            nbt.func_74774_a("sphealType", (byte)client.getSphealType().ordinal());
        }
        for (PixelExtrasData.Category category : PixelExtrasData.Category.values()) {
            nbt.func_74757_a("en" + category.name().toLowerCase(), client.isEnabled(category));
            if (client.getColours(category) == null) continue;
            nbt.func_74783_a("c" + category.name().toLowerCase(), client.getColours(category));
        }
        compound.func_74782_a(PlayerExtraDataStore.client.id.toString(), (NBTBase)nbt);
        try (FileOutputStream out = new FileOutputStream(file);){
            CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

