/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.playerData;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.battles.CatchComboEvent;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.eventhandler.Event;

public class CaptureCombo {
    private EnumSpecies lastCapture;
    private int captureCount;

    public void onCapture(EntityPlayerMP player, EnumSpecies species) {
        if (PixelmonConfig.allowCatchCombo) {
            this.captureCount = this.lastCapture == species ? ++this.captureCount : 1;
            this.lastCapture = species;
            Pixelmon.EVENT_BUS.post((Event)new CatchComboEvent.ComboIncrement(player, this.lastCapture, this.captureCount));
        } else {
            this.clearCombo();
        }
    }

    public int getCurrentCombo() {
        return this.captureCount;
    }

    public EnumSpecies getCurrentSpecies() {
        return this.lastCapture;
    }

    public void clearCombo() {
        this.lastCapture = null;
        this.captureCount = 0;
    }

    public int getCurrentThreshold() {
        for (int i = 0; i < PixelmonConfig.catchComboThresholds.size(); ++i) {
            if (this.captureCount > PixelmonConfig.catchComboThresholds.get(i)) continue;
            return i;
        }
        return PixelmonConfig.catchComboThresholds.size();
    }

    public float getExpBouns() {
        int threshold = this.getCurrentThreshold();
        return PixelmonConfig.catchComboExpBonuses.size() > threshold ? PixelmonConfig.catchComboExpBonuses.get(threshold).floatValue() : 1.0f;
    }

    public float getShinyModifier() {
        int threshold = this.getCurrentThreshold();
        return PixelmonConfig.catchComboShinyModifiers.size() > threshold ? PixelmonConfig.catchComboShinyModifiers.get(threshold).floatValue() : 1.0f;
    }

    public int getPerfIVCount() {
        int threshold = this.getCurrentThreshold();
        return PixelmonConfig.catchComboPerfectIVs.size() > threshold ? PixelmonConfig.catchComboPerfectIVs.get(threshold) : 0;
    }
}

