/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.tickHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.PassiveHealEvent;
import com.pixelmonmod.pixelmon.api.pokemon.IPassiveHealer;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.TransientData;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.eventhandler.Event;

public class WalkingPassiveHealer
implements IPassiveHealer {
    @Override
    public void tick(EntityPlayerMP player, PlayerPartyStorage party) {
        ++party.transientData.passiveHealTick;
        if (party.transientData.passiveHealTick >= 20 && PixelmonConfig.usePassiveHealer && BattleRegistry.getBattle((EntityPlayer)player) == null) {
            this.doWalkHealing(player, party);
            party.transientData.passiveHealTick = 0;
        }
    }

    public int doWalkHealing(EntityPlayerMP player, PlayerPartyStorage party) {
        int posX = player.func_180425_c().func_177958_n();
        int posZ = player.func_180425_c().func_177952_p();
        TransientData td = party.transientData;
        int changeX = td.lastPassiveHealX - posX;
        int changeZ = td.lastPassiveHealZ - posZ;
        td.lastPassiveHealX = posX;
        td.lastPassiveHealZ = posZ;
        if (changeX == -posX && changeZ == -posZ) {
            return 0;
        }
        int steps = Math.abs(changeX) + Math.abs(changeZ);
        if (steps > 20) {
            return 0;
        }
        if (steps == 0) {
            return 0;
        }
        boolean revive = false;
        boolean status = false;
        boolean heal = RandomHelper.getRandomChance((float)steps / (float)PixelmonConfig.stepsToHealHealthPassively);
        for (int i = 0; i < steps; ++i) {
            if (!revive && RandomHelper.getRandomChance(PixelmonConfig.chanceToRevivePassively)) {
                revive = true;
            }
            if (status || !RandomHelper.getRandomChance(PixelmonConfig.chanceToHealStatusPassively)) continue;
            status = true;
        }
        Pokemon pokemon = party.getAll()[RandomHelper.rand.nextInt(6)];
        PassiveHealEvent.Pre pre = new PassiveHealEvent.Pre(player, pokemon, revive, status, heal);
        Pixelmon.EVENT_BUS.post((Event)pre);
        if (pre.isCanceled()) {
            return 0;
        }
        if (pokemon != null) {
            double percentageHP;
            DelegateLink link = new DelegateLink(pokemon);
            if (revive && pokemon.getHealth() <= 0) {
                ((PokemonLink)link).sendMessage("pixelmon.effect.revived", ((PokemonLink)link).getNickname());
                ((PokemonLink)link).setHealth(1);
                ((PokemonLink)link).update(EnumUpdateType.HP);
                status = false;
                heal = false;
            }
            if (status) {
                if (((PokemonLink)link).getPrimaryStatus().type == StatusType.Burn && ((PokemonLink)link).removeStatuses(StatusType.Burn)) {
                    ((PokemonLink)link).sendMessage("pixelmon.status.burncure", ((PokemonLink)link).getNickname());
                    heal = false;
                    ((PokemonLink)link).update(EnumUpdateType.Status);
                } else if (((PokemonLink)link).getPrimaryStatus().type == StatusType.Paralysis && ((PokemonLink)link).removeStatuses(StatusType.Paralysis)) {
                    ((PokemonLink)link).sendMessage("pixelmon.status.paralysiscure", ((PokemonLink)link).getNickname());
                    heal = false;
                    ((PokemonLink)link).update(EnumUpdateType.Status);
                } else if (((PokemonLink)link).getPrimaryStatus().type == StatusType.Poison && ((PokemonLink)link).removeStatuses(StatusType.Poison)) {
                    ((PokemonLink)link).sendMessage("pixelmon.status.poisoncure", ((PokemonLink)link).getNickname());
                    heal = false;
                    ((PokemonLink)link).update(EnumUpdateType.Status);
                } else if (((PokemonLink)link).getPrimaryStatus().type == StatusType.PoisonBadly && ((PokemonLink)link).removeStatuses(StatusType.PoisonBadly)) {
                    ((PokemonLink)link).sendMessage("pixelmon.status.poisoncure", ((PokemonLink)link).getNickname());
                    heal = false;
                    ((PokemonLink)link).update(EnumUpdateType.Status);
                } else if (((PokemonLink)link).getPrimaryStatus().type == StatusType.Sleep && ((PokemonLink)link).removeStatuses(StatusType.Sleep)) {
                    ((PokemonLink)link).sendMessage("pixelmon.status.wokeup", ((PokemonLink)link).getNickname());
                    heal = false;
                    ((PokemonLink)link).update(EnumUpdateType.Status);
                } else if (((PokemonLink)link).getPrimaryStatus().type == StatusType.Freeze && ((PokemonLink)link).removeStatuses(StatusType.Freeze)) {
                    ((PokemonLink)link).sendMessage("pixelmon.status.breakice", ((PokemonLink)link).getNickname());
                    heal = false;
                    ((PokemonLink)link).update(EnumUpdateType.Status);
                }
            }
            if (heal && (percentageHP = (double)((PokemonLink)link).getHealth() / (double)((PokemonLink)link).getMaxHealth()) < (double)PixelmonConfig.passiveHealingMaxHealthPercentage && ((PokemonLink)link).getHealth() + 1 <= ((PokemonLink)link).getMaxHealth() && ((PokemonLink)link).getHealth() != 0) {
                ((PokemonLink)link).setHealth(((PokemonLink)link).getHealth() + 1);
                ((PokemonLink)link).update(EnumUpdateType.HP);
            }
            Pixelmon.EVENT_BUS.post((Event)new PassiveHealEvent.Post(player, pokemon, revive, status, heal));
        }
        return steps;
    }
}

