/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util.network;

import com.google.common.base.Preconditions;
import com.pixelmonmod.pixelmon.util.network.BetterIndexedCodec;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.network.INetHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class BetterChannelHandlerWrapper<REQ extends IMessage, REPLY extends IMessage>
extends SimpleChannelInboundHandler<REQ> {
    private final IMessageHandler<? super REQ, ? extends REPLY> messageHandler;
    private final Side side;
    private static Constructor<MessageContext> contextConstructor;

    public BetterChannelHandlerWrapper(Class<? extends IMessageHandler<? super REQ, ? extends REPLY>> handler, Side side, Class<REQ> requestType) {
        this(BetterChannelHandlerWrapper.instantiate(handler), side, requestType);
    }

    public BetterChannelHandlerWrapper(IMessageHandler<? super REQ, ? extends REPLY> handler, Side side, Class<REQ> requestType) {
        super(requestType);
        this.messageHandler = (IMessageHandler)Preconditions.checkNotNull(handler, (Object)"IMessageHandler must not be null");
        this.side = side;
    }

    protected void channelRead0(ChannelHandlerContext ctx, REQ msg) throws Exception {
        ThreadLocal local = (ThreadLocal)ctx.channel().attr(BetterIndexedCodec.FML_SOURCE).get();
        INetHandler iNetHandler = ((FMLProxyPacket)local.get()).handler();
        local.remove();
        MessageContext context = BetterChannelHandlerWrapper.context(iNetHandler, this.side);
        IMessage result = this.messageHandler.onMessage(msg, context);
        if (result != null) {
            ctx.channel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.REPLY);
            ctx.writeAndFlush((Object)result).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log.error("BetterChannelHandlerWrapper exception", cause);
        super.exceptionCaught(ctx, cause);
    }

    static <REQ extends IMessage, REPLY extends IMessage> IMessageHandler<? super REQ, ? extends REPLY> instantiate(Class<? extends IMessageHandler<? super REQ, ? extends REPLY>> handler) {
        try {
            return handler.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static MessageContext context(INetHandler netHandler, Side side) {
        try {
            return contextConstructor.newInstance(netHandler, side);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not initialize message context!");
        }
    }

    static {
        try {
            contextConstructor = MessageContext.class.getDeclaredConstructor(INetHandler.class, Side.class);
            contextConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

