/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util.network;

import com.pixelmonmod.pixelmon.util.helpers.ReflectionHelper;
import com.pixelmonmod.pixelmon.util.network.BetterChannelHandlerWrapper;
import com.pixelmonmod.pixelmon.util.network.BetterIndexedCodec;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.lang.reflect.Method;
import java.util.EnumMap;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleIndexedCodec;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class BetterNetworkWrapper
extends SimpleNetworkWrapper {
    EnumMap<Side, FMLEmbeddedChannel> channels;
    BetterIndexedCodec codec;
    private static Class<?> defaultChannelPipeline;
    private static Method generateName;

    public BetterNetworkWrapper(String channelName) {
        super(channelName);
        SimpleIndexedCodec packetCodec = (SimpleIndexedCodec)ReflectionHelper.getPrivateValue(SimpleNetworkWrapper.class, this, "packetCodec");
        this.channels = (EnumMap)ReflectionHelper.getPrivateValue(SimpleNetworkWrapper.class, this, "channels");
        this.codec = new BetterIndexedCodec();
        for (Side side : Side.values()) {
            this.channels.get(side).pipeline().replace((ChannelHandler)packetCodec, null, (ChannelHandler)this.codec);
        }
        ReflectionHelper.setPrivateValue(SimpleNetworkWrapper.class, this, null, "packetCodec");
        defaultChannelPipeline = (Class)ReflectionHelper.getPrivateValue(SimpleNetworkWrapper.class, null, "defaultChannelPipeline");
        generateName = (Method)ReflectionHelper.getPrivateValue(SimpleNetworkWrapper.class, null, "generateName");
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Class<REQ> requestMessageType, int discriminator, Side side) {
        this.codec.addDiscriminator(discriminator, requestMessageType);
        FMLEmbeddedChannel channel = this.channels.get(side);
        String type = channel.findChannelHandlerNameForType(BetterIndexedCodec.class);
        BetterChannelHandlerWrapper<? super REQ, ? extends REPLY> handler = new BetterChannelHandlerWrapper<REQ, REPLY>(messageHandler, side, requestMessageType);
        channel.pipeline().addAfter(type, this.generateName(channel.pipeline(), (ChannelHandler)handler), handler);
    }

    private String generateName(ChannelPipeline pipeline, ChannelHandler handler) {
        try {
            return (String)generateName.invoke(defaultChannelPipeline.cast(pipeline), handler);
        }
        catch (Exception e) {
            throw new RuntimeException("It appears we somehow have a not-standard pipeline. Huh", e);
        }
    }
}

