/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration.dimension.debug;

import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityStatue;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumStatueTextureType;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;

public class DebugChunkGenerator
implements IChunkGenerator {
    private World world;
    int GRID_WIDTH = MathHelper.func_76123_f((float)MathHelper.func_76129_c((float)uniqueStatues.size()));
    int GRID_HEIGHT = MathHelper.func_76123_f((float)((float)uniqueStatues.size() / (float)this.GRID_WIDTH));
    private static final IBlockState BARRIER = Blocks.field_180401_cv.func_176223_P();
    private static List<UniqueStatue> uniqueStatues = new ArrayList<UniqueStatue>();

    public DebugChunkGenerator(World world) {
        this.world = world;
    }

    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer chunkprimer = new ChunkPrimer();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int k = x * 16 + i;
                int l = z * 16 + j;
                chunkprimer.func_177855_a(i, 60, j, BARRIER);
            }
        }
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        chunk.func_76603_b();
        byte[] biomeArray = chunk.func_76605_m();
        for (int b = 0; b < biomeArray.length; ++b) {
            biomeArray[b] = (byte)Biome.func_185362_a((Biome)Biomes.field_76772_c);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int x, int z) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int k = x * 16 + i;
                int l = z * 16 + j;
                EntityStatue statue = this.getStatueAt(k, l);
                if (statue == null) continue;
                statue.func_70107_b(k, 62.0, l);
                this.world.func_72838_d((Entity)statue);
            }
        }
    }

    public EntityStatue getStatueAt(int x, int z) {
        int i;
        if (x > 0 && z > 0 && x % 6 == 1 && z % 6 == 1 && (x /= 6) <= this.GRID_WIDTH && (z /= 6) <= this.GRID_HEIGHT && (i = MathHelper.func_76130_a((int)(x * this.GRID_WIDTH + z))) < uniqueStatues.size()) {
            return uniqueStatues.get(i).create(this.world);
        }
        return null;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return null;
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    static {
        for (EnumSpecies species : EnumSpecies.values()) {
            for (IEnumForm form : species.getPossibleForms(false)) {
                Gender[] genders = species.getBaseStats().getMalePercent() < 0.0 ? new Gender[]{Gender.None} : (species.getBaseStats().getMalePercent() == 0.0 ? new Gender[]{Gender.Female} : (EnumSpecies.mfTextured.contains(species) ? new Gender[]{Gender.Male, Gender.Female} : new Gender[]{Gender.Male}));
                for (Gender gender : genders) {
                    for (Boolean bool : new Boolean[]{false, true}) {
                        uniqueStatues.add(new UniqueStatue(new PokemonBase(species, form.getForm(), gender), bool));
                    }
                }
            }
        }
    }

    public static class UniqueStatue {
        PokemonBase base;
        boolean shiny;

        public UniqueStatue(PokemonBase base, boolean shiny) {
            this.base = base;
            this.shiny = shiny;
        }

        public EntityStatue create(World world) {
            EntityStatue statue = new EntityStatue(world);
            statue.setPokemon(this.base);
            if (this.shiny) {
                statue.setTextureType(EnumStatueTextureType.Shiny);
            }
            return statue;
        }
    }
}

