/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration.structure.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityStatue;
import com.pixelmonmod.pixelmon.util.PixelBlockSnapshot;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class StructureSnapshot {
    private final int width;
    private final int height;
    private final int length;
    private List<NBTTagCompound> statues = Lists.newArrayList();
    private Map<Vec3i, NBTTagCompound> tileEntityData = Maps.newHashMap();
    private BiMap<BlockState, Integer> idToBlock = HashBiMap.create((int)32);
    private int[][][] ids;

    public StructureSnapshot(int width, int height, int length) {
        this.width = width;
        this.height = height;
        this.length = length;
        this.ids = new int[width][height][length];
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLength() {
        return this.length;
    }

    public PixelBlockSnapshot getBlockAt(int x, int y, int z) {
        int id = this.ids[x][y][z];
        BlockPos pos = new BlockPos(x, y, z);
        BlockState state = (BlockState)this.idToBlock.inverse().get((Object)id);
        NBTTagCompound nbt = this.tileEntityData.getOrDefault(pos, null);
        return new PixelBlockSnapshot(pos, state.getBlockState(), nbt);
    }

    public List<NBTTagCompound> getStatues() {
        return this.statues;
    }

    public void writeToNBT(NBTTagCompound compound) {
        Object ySlice;
        compound.func_74774_a("formatVersion", (byte)1);
        compound.func_74768_a("Width", this.width);
        compound.func_74768_a("Height", this.height);
        compound.func_74768_a("Length", this.length);
        NBTTagList palette = new NBTTagList();
        compound.func_74782_a("palette", (NBTBase)palette);
        for (int i = 0; i < this.idToBlock.size(); ++i) {
            NBTTagCompound block = new NBTTagCompound();
            BlockState state = (BlockState)this.idToBlock.inverse().get((Object)i);
            ResourceLocation rl = state.block.getRegistryName();
            block.func_74778_a("id", rl.toString());
            block.func_74774_a("meta", (byte)state.meta);
            palette.func_74742_a((NBTBase)block);
        }
        boolean largePalette = this.idToBlock.size() > 127;
        NBTTagCompound blocks = new NBTTagCompound();
        compound.func_74782_a("blocks", (NBTBase)blocks);
        for (int y = 0; y < this.height; ++y) {
            ySlice = new int[this.width * this.length];
            int k = 0;
            for (int x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.length; ++z) {
                    ySlice[k++] = this.ids[x][y][z];
                }
            }
            if (!largePalette) {
                byte[] newySlice = new byte[((Object)ySlice).length];
                for (int i = 0; i < ((Object)ySlice).length; ++i) {
                    newySlice[i] = (byte)ySlice[i];
                }
                blocks.func_74773_a(y + "", newySlice);
                continue;
            }
            blocks.func_74783_a(y + "", (int[])ySlice);
        }
        NBTTagList tileEntities = new NBTTagList();
        compound.func_74782_a("tileEntities", (NBTBase)tileEntities);
        ySlice = this.tileEntityData.entrySet().iterator();
        while (ySlice.hasNext()) {
            Map.Entry tile = (Map.Entry)ySlice.next();
            NBTTagCompound tileData = new NBTTagCompound();
            tileData.func_74768_a("x", ((Vec3i)tile.getKey()).func_177958_n());
            tileData.func_74768_a("y", ((Vec3i)tile.getKey()).func_177956_o());
            tileData.func_74768_a("z", ((Vec3i)tile.getKey()).func_177952_p());
            tileData.func_74782_a("data", (NBTBase)tile.getValue());
            tileEntities.func_74742_a((NBTBase)tileData);
        }
        NBTTagList statues = new NBTTagList();
        compound.func_74782_a("statues", (NBTBase)statues);
        for (NBTTagCompound statue : this.statues) {
            statues.func_74742_a((NBTBase)statue);
        }
    }

    public static StructureSnapshot from(int minX, int maxX, int minY, int maxY, int minZ, int maxZ, World world) {
        StructureSnapshot snapshot = new StructureSnapshot(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
        int nextId = 0;
        snapshot.idToBlock.put((Object)new BlockState(Blocks.field_150350_a, 0), (Object)nextId++);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = new BlockState(world.func_180495_p(pos));
                    if (!snapshot.idToBlock.containsKey((Object)state)) {
                        snapshot.idToBlock.put((Object)state, (Object)nextId++);
                    }
                    snapshot.ids[x - minX][y - minY][z - minZ] = (Integer)snapshot.idToBlock.get((Object)state);
                    if (world.func_175625_s(pos) == null) continue;
                    TileEntity te = world.func_175625_s(pos);
                    NBTTagCompound compound = new NBTTagCompound();
                    te.func_189515_b(compound);
                    snapshot.tileEntityData.put((Vec3i)new BlockPos(x - minX, y - minY, z - minZ), compound);
                }
            }
        }
        AxisAlignedBB aabb = new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        List statues = world.func_72872_a(EntityStatue.class, aabb);
        for (EntityStatue statue : statues) {
            NBTTagCompound statueTag = new NBTTagCompound();
            statue.func_189511_e(statueTag);
            NBTTagList pos = statueTag.func_150295_c("Pos", 6);
            double posX = pos.func_150309_d(0);
            double posY = pos.func_150309_d(1);
            double posZ = pos.func_150309_d(2);
            pos.func_150304_a(0, (NBTBase)new NBTTagDouble(posX - (double)minX));
            pos.func_150304_a(1, (NBTBase)new NBTTagDouble(posY - (double)minY));
            pos.func_150304_a(2, (NBTBase)new NBTTagDouble(posZ - (double)minZ));
            snapshot.statues.add(statueTag);
        }
        return snapshot;
    }

    public static StructureSnapshot readFromNBT(NBTTagCompound compound) {
        if (compound.func_74771_c("formatVersion") == 0) {
            return StructureSnapshot.loadOldFormat(compound);
        }
        return StructureSnapshot.read(compound);
    }

    private static StructureSnapshot read(NBTTagCompound compound) {
        int width = compound.func_74762_e("Width");
        int height = compound.func_74762_e("Height");
        int length = compound.func_74762_e("Length");
        StructureSnapshot snapshot = new StructureSnapshot(width, height, length);
        NBTTagList palette = compound.func_150295_c("palette", 10);
        for (int i = 0; i < palette.func_74745_c(); ++i) {
            NBTTagCompound blockTag = palette.func_150305_b(i);
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockTag.func_74779_i("id")));
            snapshot.idToBlock.put((Object)new BlockState(block, blockTag.func_74762_e("meta")), (Object)i);
        }
        boolean largePalette = snapshot.idToBlock.size() > 127;
        NBTTagCompound blocks = compound.func_74775_l("blocks");
        compound.func_74782_a("blocks", (NBTBase)blocks);
        for (int y = 0; y < height; ++y) {
            int[] ySlice = blocks.func_74759_k(y + "");
            byte[] smallSlice = blocks.func_74770_j(y + "");
            int k = 0;
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < length; ++z) {
                    snapshot.ids[x][y][z] = largePalette ? ySlice[k++] : smallSlice[k++];
                }
            }
        }
        NBTTagList tileEntities = compound.func_150295_c("tileEntities", 10);
        for (int i = 0; i < tileEntities.func_74745_c(); ++i) {
            NBTTagCompound tileData = tileEntities.func_150305_b(i);
            Vec3i pos = new Vec3i(tileData.func_74762_e("x"), tileData.func_74762_e("y"), tileData.func_74762_e("z"));
            snapshot.tileEntityData.put(pos, tileData.func_74775_l("data"));
        }
        NBTTagList statues = compound.func_150295_c("statues", 10);
        for (int i = 0; i < statues.func_74745_c(); ++i) {
            snapshot.statues.add(statues.func_150305_b(i));
        }
        return snapshot;
    }

    private static StructureSnapshot loadOldFormat(NBTTagCompound compound) {
        int width = compound.func_74762_e("Width");
        int height = compound.func_74762_e("Height");
        int length = compound.func_74762_e("Length");
        StructureSnapshot snapshot = new StructureSnapshot(width, height, length);
        int nextId = 0;
        snapshot.idToBlock.put((Object)new BlockState(Blocks.field_150350_a, 0), (Object)nextId++);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < length; ++z) {
                    int id;
                    NBTTagCompound blockTag = (NBTTagCompound)compound.func_74781_a("X" + x + "Y" + y + "Z" + z);
                    if (blockTag.func_74767_n("hasTE")) {
                        snapshot.tileEntityData.put(new Vec3i(x, y, z), blockTag.func_74775_l("tileEntity"));
                    }
                    String domain = blockTag.func_74764_b("blockMod") ? blockTag.func_74779_i("blockMod") : "minecraft";
                    String resource = blockTag.func_74779_i("blockName");
                    int meta = blockTag.func_74762_e("metadata");
                    Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(domain, resource));
                    if (block == Blocks.field_150350_a) continue;
                    BlockState state = new BlockState(block, meta);
                    if (!snapshot.idToBlock.containsKey((Object)state)) {
                        snapshot.idToBlock.put((Object)state, (Object)nextId++);
                    }
                    snapshot.ids[x][y][z] = id = ((Integer)snapshot.idToBlock.get((Object)state)).intValue();
                }
            }
        }
        int numStatues = compound.func_74762_e("numStatues");
        if (numStatues > 0) {
            float baseX = compound.func_74762_e("baseX");
            float baseY = compound.func_74762_e("baseY");
            float baseZ = compound.func_74762_e("baseZ");
            for (int i = 0; i < numStatues; ++i) {
                NBTTagCompound statue = compound.func_74775_l("statue" + i);
                NBTTagList pos = statue.func_150295_c("Pos", 6);
                double posX = pos.func_150309_d(0);
                double posY = pos.func_150309_d(1);
                double posZ = pos.func_150309_d(2);
                pos.func_150304_a(0, (NBTBase)new NBTTagDouble(posX - (double)baseX));
                pos.func_150304_a(1, (NBTBase)new NBTTagDouble(posY - (double)baseY));
                pos.func_150304_a(2, (NBTBase)new NBTTagDouble(posZ - (double)baseZ));
                snapshot.statues.add(statue);
            }
        }
        return snapshot;
    }

    private static class BlockState {
        Block block;
        int meta;

        public BlockState(Block block, int meta) {
            this.block = block;
            this.meta = meta;
        }

        public BlockState(IBlockState state) {
            this.block = state.func_177230_c();
            this.meta = this.block.func_176201_c(state);
        }

        public IBlockState getBlockState() {
            return this.block.func_176203_a(this.meta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockState state = (BlockState)o;
            return this.meta == state.meta && Objects.equals(this.block, state.block);
        }

        public int hashCode() {
            return Objects.hash(this.block, this.meta);
        }
    }
}

