/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.groups;

import com.mojang.brigadier.StringReader;
import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import oreexcavation.core.OreExcavation;
import oreexcavation.utils.TagIngredient;
import org.apache.logging.log4j.Level;

public class BlockEntry {
    public final Predicate<BlockState> validator;
    private static int[] f;

    public BlockEntry() {
        BlockEntry dgwb;
        dgwb.validator = jsvb -> f[1];
    }

    public BlockEntry(@Nonnull ResourceLocation ffwb) {
        BlockEntry jfwb;
        jfwb.validator = usvb -> ffwb.equals((Object)ForgeRegistries.BLOCKS.getKey((Object)usvb.m_60734_()));
    }

    public BlockEntry(@Nonnull BlockState vdwb, Collection<Property<?>> rdwb, boolean mdwb) {
        BlockEntry ydwb;
        ydwb.validator = vvvb -> {
            if (mdwb && vvvb.m_60734_() != vdwb.m_60734_()) {
                return f[0];
            }
            for (Property uwvb : rdwb) {
                if (vvvb.m_61143_(uwvb) == vdwb.m_61143_(uwvb)) continue;
                return f[0];
            }
            return f[1];
        };
    }

    public BlockEntry(@Nonnull String ecwb) {
        BlockEntry icwb;
        TagIngredient ccwb = new TagIngredient(ecwb);
        icwb.validator = ccwb::apply;
    }

    public boolean checkMatch(BlockState cbwb) {
        BlockEntry gbwb;
        if (cbwb == null || cbwb.m_60734_() == Blocks.f_50016_) {
            return f[0];
        }
        return gbwb.validator.test(cbwb);
    }

    public static BlockEntry readFromString(String tyvb) {
        if (tyvb == null || tyvb.isBlank()) {
            return null;
        }
        if (tyvb.equalsIgnoreCase("*")) {
            return new BlockEntry();
        }
        String[] nyvb = tyvb.split(":");
        if (nyvb.length <= 1 || nyvb.length > 3) {
            OreExcavation.logger.log(Level.WARN, "Invalid Block Entry format: " + tyvb);
            return null;
        }
        if (nyvb.length == 2) {
            return new BlockEntry(new ResourceLocation(nyvb[0], nyvb[1]));
        }
        if (tyvb.startsWith("tag:")) {
            String wzvb = tyvb.substring(4);
            if (wzvb.isBlank()) {
                OreExcavation.logger.log(Level.ERROR, "Unable to parse tag name for Block Entry: " + tyvb);
                return null;
            }
            return new BlockEntry(wzvb);
        }
        if (tyvb.startsWith("state:")) {
            try {
                BlockStateParser.BlockResult rzvb = BlockStateParser.m_234691_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (StringReader)new StringReader(tyvb.substring(6)), (boolean)false);
                return new BlockEntry(rzvb.f_234748_(), rzvb.f_234749_().keySet(), true);
            }
            catch (Exception kzvb) {
                OreExcavation.logger.log(Level.ERROR, "Unable to parse block state for Block Entry: " + tyvb, (Throwable)kzvb);
                return null;
            }
        }
        if (tyvb.startsWith("property:")) {
            try {
                BlockStateParser.BlockResult dzvb = BlockStateParser.m_234691_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (StringReader)new StringReader(tyvb.substring(6)), (boolean)false);
                return new BlockEntry(dzvb.f_234748_(), dzvb.f_234749_().keySet(), false);
            }
            catch (Exception yyvb) {
                OreExcavation.logger.log(Level.ERROR, "Unable to parse block properties for Block Entry: " + tyvb, (Throwable)yyvb);
                return null;
            }
        }
        OreExcavation.logger.log(Level.WARN, "Invalid Block Entry format: " + tyvb);
        return null;
    }

    static {
        BlockEntry.c();
    }

    private static void c() {
        f = new int[2];
        BlockEntry.f[0] = "".length();
        BlockEntry.f[1] = " ".length();
    }
}

