/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.handlers;

import com.google.common.base.Stopwatch;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.events.EventExcavate;
import oreexcavation.handlers.EventHandler;
import oreexcavation.handlers.MiningAgent;
import oreexcavation.shapes.ExcavateShape;
import oreexcavation.undo.ExcavateHistory;
import oreexcavation.undo.RestoreResult;

public class MiningScheduler {
    public static final MiningScheduler INSTANCE;
    private final ArrayDeque<MiningAgent> agents = new ArrayDeque();
    private final Map<UUID, ExcavateHistory> undoing = new HashMap<UUID, ExcavateHistory>();
    private final Map<UUID, ArrayDeque<ExcavateHistory>> undoHistory = new HashMap<UUID, ArrayDeque<ExcavateHistory>>();
    private final Stopwatch timer = Stopwatch.createStarted();
    private static int[] db;

    private MiningScheduler() {
        MiningScheduler orub;
    }

    public MiningAgent getActiveAgent(UUID grub) {
        MiningScheduler hrub;
        for (MiningAgent irub : hrub.agents) {
            if (!irub.getPlayerID().equals(grub)) continue;
            return irub;
        }
        return null;
    }

    public void stopMining(ServerPlayer vqub) {
        MiningScheduler xqub;
        xqub.stopMining(xqub.getActiveAgent(vqub.m_20148_()));
    }

    public void stopMining(MiningAgent kqub) {
        MiningScheduler lqub;
        if (kqub == null) {
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)new EventExcavate.Post(kqub));
        kqub.dropEverything();
        lqub.appendHistory(kqub.getPlayerID(), kqub.getHistory());
        lqub.agents.remove(kqub);
    }

    public MiningAgent startMining(ServerPlayer ypub, BlockPos xpub, BlockState wpub, ExcavateShape vpub, Direction upub, Direction tpub) {
        MiningScheduler zpub;
        MiningAgent spub = zpub.getActiveAgent(ypub.m_20148_());
        if (spub != null) {
            spub.appendBlock(xpub);
            return spub;
        }
        spub = new MiningAgent(ypub, xpub, wpub);
        if (vpub != null) {
            spub.setShape(vpub, upub, tpub);
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new EventExcavate.Pre(spub))) {
            return null;
        }
        zpub.agents.add(spub);
        spub.init();
        return spub;
    }

    public RestoreResult attemptUndo(Player vwtb) {
        MiningScheduler wwtb;
        if (vwtb == null) {
            return RestoreResult.NO_UNDO_HISTORY;
        }
        ArrayDeque<ExcavateHistory> uwtb = wwtb.undoHistory.get(vwtb.m_20148_());
        if (uwtb == null || uwtb.size() <= 0) {
            return RestoreResult.NO_UNDO_HISTORY;
        }
        RestoreResult twtb = uwtb.peek().canRestore(vwtb.m_20194_(), vwtb);
        if (twtb == RestoreResult.SUCCESS) {
            wwtb.undoing.put(vwtb.m_20148_(), uwtb.poll());
        }
        return twtb;
    }

    public void appendHistory(UUID jwtb, ExcavateHistory iwtb) {
        MiningScheduler kwtb;
        if (jwtb == null || iwtb == null) {
            return;
        }
        ArrayDeque hwtb = kwtb.undoHistory.computeIfAbsent(jwtb, fvtb -> new ArrayDeque());
        hwtb.push(iwtb);
        while (hwtb.size() > ExcavationSettings.maxUndos) {
            hwtb.removeLast();
        }
    }

    public void tickAgents(MinecraftServer qvtb) {
        MiningScheduler rvtb;
        rvtb.timer.reset();
        rvtb.timer.start();
        int tvtb = rvtb.agents.size();
        for (int uvtb = db[0]; uvtb < tvtb && !rvtb.agents.isEmpty(); ++uvtb) {
            if (ExcavationSettings.tpsGuard && rvtb.timer.elapsed(TimeUnit.MILLISECONDS) > 40L) {
                EventHandler.skipNext = db[1];
                break;
            }
            MiningAgent wvtb = rvtb.agents.poll();
            if (wvtb == null) continue;
            EventHandler.captureAgent = wvtb;
            boolean vvtb = wvtb.tickMiner(rvtb.timer);
            EventHandler.captureAgent = null;
            if (!vvtb) {
                rvtb.agents.addLast(wvtb);
                continue;
            }
            MinecraftForge.EVENT_BUS.post((Event)new EventExcavate.Post(wvtb));
            wvtb.dropEverything();
            rvtb.appendHistory(wvtb.getPlayerID(), wvtb.getHistory());
        }
        Iterator<Map.Entry<UUID, ExcavateHistory>> pvtb = rvtb.undoing.entrySet().iterator();
        while (pvtb.hasNext()) {
            if (ExcavationSettings.tpsGuard && rvtb.timer.elapsed(TimeUnit.MILLISECONDS) > 40L) {
                EventHandler.skipNext = db[1];
                break;
            }
            Map.Entry<UUID, ExcavateHistory> svtb = pvtb.next();
            if (!svtb.getValue().tickRestore(qvtb, (Player)qvtb.m_6846_().m_11259_(svtb.getKey()))) continue;
            pvtb.remove();
        }
        rvtb.timer.stop();
    }

    public void resetAll() {
        MiningScheduler hvtb;
        hvtb.agents.clear();
        hvtb.undoing.clear();
        hvtb.undoHistory.clear();
        hvtb.timer.reset();
    }

    static {
        MiningScheduler.z();
        INSTANCE = new MiningScheduler();
    }

    private static void z() {
        db = new int[2];
        MiningScheduler.db[0] = 0x97 ^ 0x97;
        MiningScheduler.db[1] = 0x1E ^ 0x68 ^ (0xD2 ^ 0xA5);
    }
}

