/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.undo;

import com.google.common.base.Stopwatch;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.undo.BlockHistory;
import oreexcavation.undo.RestoreResult;
import oreexcavation.utils.BigItemStack;
import oreexcavation.utils.XPHelper;

public class ExcavateHistory {
    private final Deque<BlockHistory> history = new ArrayDeque<BlockHistory>();
    private final NonNullList<BigItemStack> drops = NonNullList.m_122779_();
    private long experience = 0L;
    private final Stopwatch timer = Stopwatch.createUnstarted();
    private final ResourceKey<Level> dimension;
    private static int[] q;

    public ExcavateHistory(ResourceKey<Level> tevb) {
        ExcavateHistory vevb;
        vevb.dimension = tevb;
    }

    public BlockHistory recordPosition(Level cevb, BlockPos aevb) {
        BlockState ydvb = cevb.m_8055_(aevb);
        BlockEntity xdvb = cevb.m_7702_(aevb);
        CompoundTag wdvb = xdvb == null ? null : xdvb.m_187480_();
        return new BlockHistory(aevb, ydvb, wdvb);
    }

    public void addRecordedBlock(BlockHistory fdvb) {
        ExcavateHistory hdvb;
        if (fdvb.state.m_60734_() == Blocks.f_50016_ || hdvb.history.contains(fdvb)) {
            return;
        }
        hdvb.history.push(fdvb);
    }

    public void setRecievedStacks(List<BigItemStack> ucvb) {
        ExcavateHistory wcvb;
        wcvb.drops.clear();
        ucvb.forEach(xyub -> {
            ExcavateHistory yyub;
            yyub.drops.add((Object)xyub.copy());
        });
    }

    public void setRecievedXP(long jcvb) {
        lcvb.experience = jcvb;
    }

    public RestoreResult canRestore(MinecraftServer nbvb, Player mbvb) {
        ExcavateHistory obvb;
        if (nbvb == null || mbvb == null) {
            return RestoreResult.NO_UNDO_HISTORY;
        }
        ServerLevel lbvb = nbvb.m_129880_(obvb.dimension);
        if (lbvb == null) {
            return RestoreResult.NO_UNDO_HISTORY;
        }
        if (!mbvb.m_150110_().f_35937_) {
            if (XPHelper.getPlayerXP(mbvb) < obvb.experience) {
                return RestoreResult.INVALID_XP;
            }
            int[] pbvb = new int[obvb.drops.size()];
            int qbvb = mbvb.m_150109_().m_6643_();
            block0: for (int rbvb = q[0]; rbvb < qbvb; ++rbvb) {
                ItemStack sbvb = mbvb.m_150109_().m_8020_(rbvb);
                if (sbvb.m_41619_()) continue;
                for (int tbvb = q[0]; tbvb < pbvb.length; ++tbvb) {
                    if (!((BigItemStack)obvb.drops.get(tbvb)).isItemEqual(sbvb)) continue;
                    int n = tbvb;
                    pbvb[n] = pbvb[n] + sbvb.m_41613_();
                    continue block0;
                }
            }
            if (IntStream.range(q[0], pbvb.length).parallel().anyMatch(gzub -> {
                ExcavateHistory jzub;
                return pbvb[gzub] < ((BigItemStack)jzub.drops.get((int)gzub)).stackSize ? q[1] : q[0];
            })) {
                return RestoreResult.INVALID_ITEMS;
            }
        }
        if (obvb.history.stream().anyMatch(arg_0 -> ExcavateHistory.lambda$canRestore$2((Level)lbvb, arg_0))) {
            return RestoreResult.OBSTRUCTED;
        }
        return RestoreResult.SUCCESS;
    }

    public boolean tickRestore(MinecraftServer iavb, Player havb) {
        ExcavateHistory javb;
        ServerLevel gavb = iavb.m_129880_(javb.dimension);
        if (gavb == null) {
            return q[1];
        }
        javb.timer.reset();
        javb.timer.start();
        if (!havb.m_150110_().f_35937_) {
            XPHelper.addXP(havb, -javb.experience, q[1]);
            if (!havb.m_150109_().m_7983_()) {
                for (BigItemStack lavb : javb.drops) {
                    int mavb = havb.m_150109_().m_6643_();
                    for (int navb = q[0]; navb < mavb && lavb.stackSize > 0; ++navb) {
                        ItemStack pavb = havb.m_150109_().m_8020_(navb);
                        if (pavb.m_41619_() || !lavb.isItemEqual(pavb)) continue;
                        int oavb = Math.min(lavb.stackSize, pavb.m_41613_());
                        havb.m_150109_().m_7407_(navb, oavb);
                        lavb.stackSize -= oavb;
                    }
                }
            }
            javb.drops.clear();
        }
        while (!(javb.history.isEmpty() || ExcavationSettings.tpsGuard && javb.timer.elapsed(TimeUnit.MILLISECONDS) > 40L)) {
            BlockHistory kavb = javb.history.pop();
            kavb.restoreBlock((Level)gavb);
        }
        javb.timer.stop();
        return javb.history.isEmpty();
    }

    private static /* synthetic */ boolean lambda$canRestore$2(Level szub, BlockHistory rzub) {
        BlockState qzub = szub.m_8055_(rzub.pos);
        return (qzub.m_60734_() != Blocks.f_50016_ && (!qzub.m_247087_() || !ExcavationSettings.undoReplace) || szub.m_45933_(null, new AABB((double)rzub.pos.m_123341_(), (double)rzub.pos.m_123342_(), (double)rzub.pos.m_123343_(), (double)((float)rzub.pos.m_123341_() + 1.0f), (double)((float)rzub.pos.m_123342_() + 1.0f), (double)((float)rzub.pos.m_123343_() + 1.0f))).size() > 0 ? q[1] : q[0]) != 0;
    }

    static {
        ExcavateHistory.t();
    }

    private static void t() {
        q = new int[2];
        ExcavateHistory.q[0] = 0xAE ^ 0xAE;
        ExcavateHistory.q[1] = 0xBA ^ 0xBB;
    }
}

