/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes;

import com.mojang.blaze3d.vertex.BufferUploader;
import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.mehvahdjukaar.advframes.AdvFrames;
import net.mehvahdjukaar.advframes.blocks.AdvancementFrameBlockTile;
import net.mehvahdjukaar.advframes.blocks.StatFrameBlockTile;
import net.mehvahdjukaar.advframes.client.AdvancementFrameBlockTileRenderer;
import net.mehvahdjukaar.advframes.client.AdvancementFrameModel;
import net.mehvahdjukaar.advframes.client.AdvancementSelectScreen;
import net.mehvahdjukaar.advframes.client.ClientConfigs;
import net.mehvahdjukaar.advframes.client.StatFrameBlockTileRenderer;
import net.mehvahdjukaar.advframes.client.StatSelectScreen;
import net.mehvahdjukaar.advframes.forge.AdvFramesClientImpl;
import net.mehvahdjukaar.advframes.integration.CreateCompat;
import net.mehvahdjukaar.moonlight.api.client.model.CustomModelLoader;
import net.mehvahdjukaar.moonlight.api.client.model.NestedModelLoader;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public class AdvFramesClient {
    public static final ResourceLocation TASK_MODEL = AdvFrames.res("item/task");
    public static final ResourceLocation GOAL_MODEL = AdvFrames.res("item/goal");
    public static final ResourceLocation CHALLENGE_MODEL = AdvFrames.res("item/challenge");
    protected static long gameTime;

    public static void init() {
        ClientConfigs.init();
        ClientHelper.addSpecialModelRegistration(AdvFramesClient::registerSpecialModels);
        ClientHelper.addBlockEntityRenderersRegistration(AdvFramesClient::registerBlockEntityRenderers);
        ClientHelper.addModelLoaderRegistration(AdvFramesClient::registerModelLoaders);
        ClientHelper.addClientSetup(AdvFramesClient::clientSetup);
    }

    public static void clientSetup() {
        if (PlatHelper.isModLoaded((String)"create")) {
            CreateCompat.setupClient();
        }
        ClientHelper.registerRenderType((Block)AdvFrames.ADVANCEMENT_FRAME.get(), (RenderType)RenderType.m_110463_());
    }

    private static void registerModelLoaders(ClientHelper.ModelLoaderEvent event) {
        event.register(AdvFrames.res("advancement_frame"), (CustomModelLoader)new NestedModelLoader("frame", AdvancementFrameModel::new));
    }

    private static void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        event.register(AdvFrames.ADVANCEMENT_FRAME_TILE.get(), AdvancementFrameBlockTileRenderer::new);
        event.register(AdvFrames.STAT_FRAME_TILE.get(), StatFrameBlockTileRenderer::new);
    }

    private static void registerSpecialModels(ClientHelper.SpecialModelEvent event) {
        event.register(TASK_MODEL);
        event.register(GOAL_MODEL);
        event.register(CHALLENGE_MODEL);
    }

    public static void setStatScreen(StatFrameBlockTile tile, Player player) {
        if (player instanceof LocalPlayer) {
            LocalPlayer lp = (LocalPlayer)player;
            Minecraft minecraft = Minecraft.m_91087_();
            StatSelectScreen screen = new StatSelectScreen(tile, lp.m_108630_());
            minecraft.m_91152_((Screen)screen);
        }
    }

    public static void setAdvancementScreen(AdvancementFrameBlockTile tile, Player player) {
        if (player instanceof LocalPlayer) {
            LocalPlayer lp = (LocalPlayer)player;
            Minecraft minecraft = Minecraft.m_91087_();
            AdvancementSelectScreen screen = new AdvancementSelectScreen(tile, lp.f_108617_.m_105145_());
            AdvFramesClient.clearForgeGuiLayers(minecraft);
            Screen old = minecraft.f_91080_;
            if (old != null) {
                old.m_7861_();
            }
            minecraft.f_91080_ = screen;
            BufferUploader.m_166835_();
            minecraft.f_91067_.m_91602_();
            KeyMapping.m_90847_();
            screen.m_6575_(minecraft, minecraft.m_91268_().m_85445_(), minecraft.m_91268_().m_85446_());
            minecraft.f_91079_ = false;
            minecraft.m_91341_();
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void clearForgeGuiLayers(Minecraft minecraft) {
        AdvFramesClientImpl.clearForgeGuiLayers(minecraft);
    }

    public static void updatePlayerStats(Object2IntMap<Stat<?>> stats) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            for (Object2IntMap.Entry entry : stats.object2IntEntrySet()) {
                Stat stat = (Stat)entry.getKey();
                int i = entry.getIntValue();
                player.m_108630_().m_6085_((Player)Minecraft.m_91087_().f_91074_, stat, i);
            }
        }
    }
}

