/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.blocks;

import com.mojang.authlib.GameProfile;
import net.mehvahdjukaar.advframes.AdvFrames;
import net.mehvahdjukaar.advframes.blocks.AdvancementFrameBlock;
import net.mehvahdjukaar.advframes.blocks.BaseFrameBlockTile;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class AdvancementFrameBlockTile
extends BaseFrameBlockTile {
    private String advancementId = null;
    private DisplayInfo advancement;

    public AdvancementFrameBlockTile(BlockPos pos, BlockState state) {
        super(AdvFrames.ADVANCEMENT_FRAME_TILE.get(), pos, state);
    }

    public void setAdvancement(Advancement advancement, ServerPlayer player) {
        this.advancement = advancement.m_138320_();
        this.advancementId = advancement.m_138327_().toString();
        this.setOwner(new GameProfile(player.m_20148_(), null));
    }

    @Override
    protected void m_183515_(CompoundTag cmp) {
        super.m_183515_(cmp);
        if (this.advancement != null) {
            MutableComponent mc;
            ComponentContents componentContents;
            MutableComponent mc2;
            ComponentContents componentContents2;
            Component title;
            Level level = this.f_58857_;
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                if (this.owner != null && this.advancementId != null && !this.advancementId.isEmpty()) {
                    ServerPlayer sp;
                    Advancement a = server.m_7654_().m_129889_().m_136041_(new ResourceLocation(this.advancementId));
                    Player player = this.f_58857_.m_46003_(this.owner.getId());
                    if (a == null || player instanceof ServerPlayer && !(sp = (ServerPlayer)player).m_8960_().m_135996_(a).m_8193_()) {
                        return;
                    }
                }
            }
            CompoundTag tag = new CompoundTag();
            if (this.advancementId != null) {
                cmp.m_128359_("ID", this.advancementId);
            }
            if ((title = this.advancement.m_14977_()) instanceof MutableComponent && (componentContents2 = (mc2 = (MutableComponent)title).m_214077_()) instanceof TranslatableContents) {
                TranslatableContents tc = (TranslatableContents)componentContents2;
                tag.m_128359_("Title", tc.m_237508_());
            } else {
                tag.m_128359_("Title", title.getString());
            }
            Component description = this.advancement.m_14985_();
            if (description instanceof MutableComponent && (componentContents = (mc = (MutableComponent)description).m_214077_()) instanceof TranslatableContents) {
                TranslatableContents tc = (TranslatableContents)componentContents;
                tag.m_128359_("Description", tc.m_237508_());
            } else {
                tag.m_128359_("Description", description.getString());
            }
            tag.m_128365_("Icon", (Tag)this.advancement.m_14990_().m_41739_(new CompoundTag()));
            tag.m_128405_("FrameType", this.advancement.m_14992_().ordinal());
            cmp.m_128365_("Advancement", (Tag)tag);
        }
    }

    @Override
    public void m_142466_(CompoundTag cmp) {
        super.m_142466_(cmp);
        this.advancementId = null;
        if (cmp.m_128441_("Advancement")) {
            CompoundTag tag = cmp.m_128469_("Advancement");
            if (cmp.m_128441_("ID")) {
                this.advancementId = tag.m_128461_("ID");
            }
            MutableComponent title = Component.m_237115_((String)tag.m_128461_("Title"));
            MutableComponent description = Component.m_237115_((String)tag.m_128461_("Description"));
            ItemStack icon = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Icon"));
            FrameType type = FrameType.values()[tag.m_128451_("FrameType")];
            this.advancement = new DisplayInfo(icon, (Component)title, (Component)description, null, type, false, true, true);
        }
        if (this.f_58857_ != null) {
            AdvancementFrameBlock.Type t = AdvancementFrameBlock.Type.get(this.advancement);
            if (this.m_58900_().m_61143_(AdvancementFrameBlock.TYPE) != t) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(AdvancementFrameBlock.TYPE, (Comparable)((Object)t)));
            }
        }
    }

    @Override
    public ChatFormatting getTitleColor() {
        FrameType v = this.getAdvancement().m_14992_();
        if (v == FrameType.GOAL) {
            return ChatFormatting.AQUA;
        }
        return v.m_15552_();
    }

    @Override
    public boolean isEmpty() {
        return this.advancement != null;
    }

    public DisplayInfo getAdvancement() {
        return this.advancement;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        if (this.advancement != null) {
            return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
        }
        return null;
    }

    @Override
    @Nullable
    public Component getTitle() {
        if (this.advancement != null) {
            return this.advancement.m_14977_();
        }
        return null;
    }
}

