/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.blocks;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class BaseFrameBlockTile
extends BlockEntity {
    protected GameProfile owner;
    private static GameProfileCache profileCache;
    @Nullable
    private static MinecraftSessionService sessionService;
    @Nullable
    private static Executor mainThreadExecutor;

    protected BaseFrameBlockTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void m_183515_(CompoundTag cmp) {
        super.m_183515_(cmp);
        if (this.owner != null) {
            cmp.m_128362_("PlayerID", this.owner.getId());
        }
    }

    public void m_142466_(CompoundTag cmp) {
        super.m_142466_(cmp);
        if (cmp.m_128441_("PlayerID")) {
            UUID id = cmp.m_128342_("PlayerID");
            this.setOwner(new GameProfile(id, null));
        }
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(@Nullable GameProfile input) {
        if (!(this.owner != null || input != null && input.isComplete())) {
            BaseFrameBlockTile baseFrameBlockTile = this;
            synchronized (baseFrameBlockTile) {
                this.owner = input;
            }
            BaseFrameBlockTile.updateGameProfile(this.owner, gameProfile -> {
                this.owner = gameProfile;
            });
        }
    }

    public static void updateGameProfile(@Nullable GameProfile gameProfile, Consumer<GameProfile> consumer) {
        if (!(gameProfile == null || gameProfile.getId() == null || gameProfile.isComplete() && gameProfile.getName() != null || profileCache == null || sessionService == null)) {
            Optional profile = profileCache.m_11002_(gameProfile.getId());
            Util.m_183991_().execute(() -> Util.m_137521_((Optional)profile, p -> {
                if (p.getName() == null) {
                    p = sessionService.fillProfileProperties(p, true);
                }
                GameProfile finalGp = p;
                mainThreadExecutor.execute(() -> {
                    profileCache.m_10991_(finalGp);
                    consumer.accept(finalGp);
                });
            }, () -> mainThreadExecutor.execute(() -> consumer.accept(gameProfile))));
        } else {
            consumer.accept(gameProfile);
        }
    }

    public static void setup(GameProfileCache gameProfileCache, MinecraftSessionService minecraftSessionService, Executor executor) {
        profileCache = gameProfileCache;
        sessionService = minecraftSessionService;
        mainThreadExecutor = executor;
    }

    public static void clear() {
        profileCache = null;
        sessionService = null;
        mainThreadExecutor = null;
    }

    @Nullable
    public Component getOwnerName() {
        if (this.owner != null) {
            String name = this.owner.getName();
            if (name == null) {
                return null;
            }
            return Component.m_237113_((String)name);
        }
        return null;
    }

    @Nullable
    public abstract Component getTitle();

    public abstract ChatFormatting getTitleColor();

    public abstract boolean isEmpty();
}

