/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mehvahdjukaar.advframes.blocks.BaseFrameBlockTile;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.phys.HitResult;
import org.joml.Matrix4f;

public abstract class BaseFrameTileRenderer<T extends BaseFrameBlockTile>
implements BlockEntityRenderer<T> {
    protected final ItemRenderer itemRenderer;
    protected final EntityRenderDispatcher entityRenderer;
    protected final Font font;
    protected final Minecraft minecraft = Minecraft.m_91087_();
    protected final Camera camera;

    protected BaseFrameTileRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = this.minecraft.m_91291_();
        this.entityRenderer = this.minecraft.m_91290_();
        this.font = this.minecraft.f_91062_;
        this.camera = this.minecraft.f_91063_.m_109153_();
    }

    public void renderTopTextBottomText(LOD lod, T tile, PoseStack poseStack, MultiBufferSource buffer, int light, float offset) {
        BlockPos hitPos;
        BlockPos pos;
        HitResult hit;
        if (Minecraft.m_91404_() && lod.isVeryNear() && (hit = this.minecraft.f_91077_) != null && hit.m_6662_() == HitResult.Type.BLOCK && (pos = tile.m_58899_()).equals((Object)(hitPos = BlockPos.m_274446_((Position)hit.m_82450_())))) {
            Component name;
            Component title = ((BaseFrameBlockTile)((Object)tile)).getTitle();
            int opacity = 0;
            if (title != null) {
                poseStack.m_85836_();
                float width = this.font.m_92852_((FormattedText)title);
                float scale = 0.025f;
                if (width > 48.0f) {
                    scale /= width / 48.0f;
                }
                poseStack.m_85837_(0.0, (double)(offset + 4.0f * scale), 0.0125);
                poseStack.m_85841_(scale, -scale, scale);
                Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                float dx = -width / 2.0f;
                this.font.m_272077_(title, dx, 0.0f, ((BaseFrameBlockTile)((Object)tile)).getTitleColor().m_126665_().intValue(), true, matrix4f, buffer, Font.DisplayMode.POLYGON_OFFSET, opacity, light);
                poseStack.m_85849_();
            }
            if ((name = ((BaseFrameBlockTile)((Object)tile)).getOwnerName()) != null) {
                poseStack.m_85836_();
                float width = this.font.m_92852_((FormattedText)name);
                float scale = 0.025f;
                if (width > 48.0f) {
                    scale /= width / 48.0f;
                }
                poseStack.m_85837_(0.0, (double)(-offset + 4.0f * scale), 0.0125);
                poseStack.m_85841_(scale, -scale, scale);
                Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                float dx = -width / 2.0f;
                this.font.m_272077_(name, dx, 0.0f, -1, true, matrix4f, buffer, Font.DisplayMode.POLYGON_OFFSET, opacity, light);
                poseStack.m_85849_();
            }
        }
    }
}

