/*
 * Decompiled with CFR 0.152.
 */
package net.temporal.galosphere_spellbooks.core.registry;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.item.curios.CurioBaseItem;
import io.redspace.ironsspellbooks.item.curios.SimpleAttributeCurio;
import io.redspace.ironsspellbooks.item.spell_books.SimpleAttributeSpellBook;
import io.redspace.ironsspellbooks.util.ItemPropertiesHelper;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.temporal.galosphere_spellbooks.core.item.armor.SterlingRobesArmorItem;

public class GalosphereSpellbooksItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"galosphere_spellbooks");
    public static final RegistryObject<SpellBook> STERLING_SPELL_BOOK = ITEMS.register("sterling_spell_book", () -> {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)((Attribute)AttributeRegistry.EVOCATION_MAGIC_RESIST.get()), (Object)new AttributeModifier(UUID.fromString("667ad88f-901d-4691-b2a2-3664e42026d3"), "Weapon modifier", 0.35, AttributeModifier.Operation.MULTIPLY_BASE));
        builder.put((Object)((Attribute)AttributeRegistry.MAX_MANA.get()), (Object)new AttributeModifier(UUID.fromString("667ad88f-901d-4691-b2a2-3664e42026d3"), "Weapon modifier", 50.0, AttributeModifier.Operation.ADDITION));
        return new SimpleAttributeSpellBook(4, SpellRarity.UNCOMMON, (Multimap)builder.build());
    });
    public static final RegistryObject<Item> STERLING_ROBES_HELMET = ITEMS.register("sterling_robes_helmet", () -> new SterlingRobesArmorItem(ArmorItem.Type.HELMET, ItemPropertiesHelper.equipment()));
    public static final RegistryObject<Item> STERLING_ROBES_CHESTPLATE = ITEMS.register("sterling_robes_chestplate", () -> new SterlingRobesArmorItem(ArmorItem.Type.CHESTPLATE, ItemPropertiesHelper.equipment()));
    public static final RegistryObject<Item> STERLING_ROBES_LEGGINGS = ITEMS.register("sterling_robes_leggings", () -> new SterlingRobesArmorItem(ArmorItem.Type.LEGGINGS, ItemPropertiesHelper.equipment()));
    public static final RegistryObject<Item> STERLING_ROBES_BOOTS = ITEMS.register("sterling_robes_boots", () -> new SterlingRobesArmorItem(ArmorItem.Type.BOOTS, ItemPropertiesHelper.equipment()));
    public static final RegistryObject<CurioBaseItem> ALLURITE_PENDANT = ITEMS.register("allurite_pendant", () -> new SimpleAttributeCurio(ItemPropertiesHelper.equipment().m_41487_(1), (Attribute)AttributeRegistry.MAX_MANA.get(), new AttributeModifier("mana", 30.0, AttributeModifier.Operation.ADDITION)));

    public static Collection<RegistryObject<Item>> getGSItems() {
        return ITEMS.getEntries();
    }

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }
}

