/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.HostileConfig;
import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.command.GenerateModelCommand;
import dev.shadowsoffire.hostilenetworks.command.GiveModelCommand;
import dev.shadowsoffire.hostilenetworks.curios.CuriosCompat;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelRegistry;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.hostilenetworks.item.DeepLearnerItem;
import dev.shadowsoffire.placebo.network.PacketDistro;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod.EventBusSubscriber(modid="hostilenetworks")
public class HostileEvents {
    @SubscribeEvent
    public static void cmds(RegisterCommandsEvent e) {
        LiteralArgumentBuilder builder = Commands.m_82127_((String)"hostilenetworks");
        GenerateModelCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder);
        GiveModelCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder);
        e.getDispatcher().register(builder);
    }

    @SubscribeEvent
    public static void modelAttunement(PlayerInteractEvent.EntityInteractSpecific e) {
        if (!HostileConfig.rightClickToAttune) {
            return;
        }
        Player player = e.getEntity();
        ItemStack stack = player.m_21120_(e.getHand());
        if (stack.m_41720_() == Hostile.Items.BLANK_DATA_MODEL.get()) {
            if (!player.m_9236_().f_46443_) {
                DataModel model = DataModelRegistry.INSTANCE.getForEntity(e.getTarget().m_6095_());
                if (model == null) {
                    MutableComponent msg = Component.m_237115_((String)"hostilenetworks.msg.no_model").m_130940_(ChatFormatting.RED);
                    player.m_213846_((Component)msg);
                    return;
                }
                MutableComponent msg = Component.m_237110_((String)"hostilenetworks.msg.built", (Object[])new Object[]{model.name()}).m_130940_(ChatFormatting.GOLD);
                player.m_213846_((Component)msg);
                ItemStack modelStack = new ItemStack((ItemLike)Hostile.Items.DATA_MODEL.get());
                DataModelItem.setStoredModel(modelStack, model);
                player.m_21008_(e.getHand(), modelStack);
            }
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void kill(LivingDeathEvent e) {
        if (!HostileConfig.killModelUpgrade) {
            return;
        }
        Entity src = e.getSource().m_7639_();
        if (src instanceof ServerPlayer) {
            ItemStack curioStack;
            ServerPlayer p = (ServerPlayer)src;
            p.m_150109_().f_35974_.stream().filter(s -> s.m_41720_() == Hostile.Items.DEEP_LEARNER.get()).forEach(dl -> HostileEvents.updateModels(dl, e.getEntity().m_6095_(), 0));
            if (p.m_21206_().m_41720_() == Hostile.Items.DEEP_LEARNER.get()) {
                HostileEvents.updateModels(p.m_21206_(), e.getEntity().m_6095_(), 0);
            }
            if (ModList.get().isLoaded("curios") && (curioStack = CuriosCompat.getDeepLearner((Player)p)).m_41720_() == Hostile.Items.DEEP_LEARNER.get()) {
                HostileEvents.updateModels(curioStack, e.getEntity().m_6095_(), 0);
            }
        }
    }

    public static void updateModels(ItemStack learner, EntityType<?> type, int bonus) {
        ItemStackHandler handler = DeepLearnerItem.getItemHandler(learner);
        for (int i = 0; i < 4; ++i) {
            DynamicHolder<DataModel> dModel;
            ItemStack model = handler.getStackInSlot(i);
            if (model.m_41619_() || (!(dModel = DataModelItem.getStoredModel(model)).isBound() || ((DataModel)dModel.get()).type() != type) && !((DataModel)dModel.get()).subtypes().contains(type)) continue;
            int data = DataModelItem.getData(model);
            ModelTier tier = ModelTier.getByData(dModel, data);
            DataModelItem.setData(model, data + ((DataModel)dModel.get()).getDataPerKill(tier) + bonus);
        }
        DeepLearnerItem.saveItems(learner, handler);
    }

    @SubscribeEvent
    public static void reload(AddReloadListenerEvent e) {
        e.addListener((PreparableReloadListener)((ResourceManagerReloadListener)resman -> HostileConfig.load()));
    }

    @SubscribeEvent
    public static void sync(OnDatapackSyncEvent e) {
        if (e.getPlayer() != null) {
            PacketDistro.sendTo((SimpleChannel)HostileNetworks.CHANNEL, (Object)new HostileConfig.ConfigMessage(), (Player)e.getPlayer());
        } else {
            PacketDistro.sendToAll((SimpleChannel)HostileNetworks.CHANNEL, (Object)new HostileConfig.ConfigMessage());
        }
    }
}

