/*
 * Decompiled with CFR 0.152.
 */
package net.mowzierespawner.procedures;

import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mowzierespawner.init.MowzieRespawnerModItems;

@Mod.EventBusSubscriber
public class StructureCheckerOnRightClick {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ServerLevel serverLevel;
        boolean hasNearbyEntities;
        Player player = event.getEntity();
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ItemStack mainHandItem = player.m_21205_();
        if (!mainHandItem.m_41720_().equals(MowzieRespawnerModItems.UMVUTHANA_NECTAR.get())) {
            return;
        }
        ResourceLocation biomeKey = ((ResourceKey)player.m_9236_().m_204166_(player.m_20183_()).m_203543_().orElseThrow()).m_135782_();
        if (!biomeKey.toString().equals("minecraft:savanna")) {
            return;
        }
        Level level = player.m_9236_();
        if (level instanceof ServerLevel && !(hasNearbyEntities = (serverLevel = (ServerLevel)level).m_6249_((Entity)player, player.m_20191_().m_82400_(60.0), entity -> {
            ResourceLocation entityKey = BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_());
            return entityKey != null && entityKey.toString().equals("mowziesmobs:umvuthi");
        }).isEmpty())) {
            return;
        }
        double blockX = event.getPos().m_123341_();
        double blockZ = event.getPos().m_123343_();
        StructureCheckerOnRightClick.execute((Entity)player, blockX, blockZ);
    }

    public static void execute(Entity entity, double xLocation, double zLocation) {
        if (entity == null) {
            return;
        }
        String commandResult = StructureCheckerOnRightClick.executeCommand(entity, "locate structure mowziesmobs:umvuthana_grove");
        if (commandResult.isEmpty()) {
            return;
        }
        String[] coordinates = StructureCheckerOnRightClick.extractCoordinates(commandResult);
        if (coordinates == null) {
            return;
        }
        double structureX = StructureCheckerOnRightClick.parseCoordinate(coordinates[0]);
        double structureZ = StructureCheckerOnRightClick.parseCoordinate(coordinates[2]);
        if (xLocation > structureX - 35.0 && xLocation < structureX + 35.0 && zLocation > structureZ - 35.0 && zLocation < structureZ + 35.0) {
            ServerLevel serverLevel;
            Level mainHandItem;
            Player player;
            if (entity instanceof Player && !(player = (Player)entity).m_7500_()) {
                mainHandItem = player.m_21205_();
                mainHandItem.m_41774_(1);
                player.m_150109_().m_6596_();
            }
            if ((mainHandItem = entity.m_9236_()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)mainHandItem;
                serverLevel.m_5594_(null, entity.m_20183_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if ((mainHandItem = entity.m_9236_()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)mainHandItem;
                int circles = 5;
                int pointsPerCircle = 30;
                double expansionSpeed = 0.5;
                for (int i = 0; i < circles; ++i) {
                    double radius = (double)(i + 1) * expansionSpeed;
                    for (int j = 0; j < pointsPerCircle; ++j) {
                        double angle = Math.PI * 2 * (double)j / (double)pointsPerCircle;
                        double xOffset = radius * Math.cos(angle);
                        double zOffset = radius * Math.sin(angle);
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, entity.m_20185_() + xOffset, entity.m_20186_() + 1.0, entity.m_20189_() + zOffset, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            String placeStructureCommand = String.format("execute positioned %f ~-600 %f run place structure mowziesmobs:umvuthana_grove", structureX, structureZ);
            StructureCheckerOnRightClick.executeCommand(entity, placeStructureCommand);
        }
    }

    private static String executeCommand(Entity entity, String command) {
        final StringBuilder result = new StringBuilder();
        if (!entity.m_9236_().m_5776_() && entity.m_20194_() != null) {
            CommandSourceStack commandSourceStack = new CommandSourceStack(new CommandSource(){

                public void m_213846_(Component message) {
                    result.append(message.getString());
                }

                public boolean m_6999_() {
                    return true;
                }

                public boolean m_7028_() {
                    return true;
                }

                public boolean m_6102_() {
                    return false;
                }
            }, entity.m_20182_(), entity.m_20155_(), entity.m_9236_() instanceof ServerLevel ? (ServerLevel)entity.m_9236_() : null, 4, entity.m_7755_().getString(), entity.m_5446_(), entity.m_9236_().m_7654_(), entity);
            entity.m_20194_().m_129892_().m_230957_(commandSourceStack, command);
        }
        return result.toString();
    }

    private static String[] extractCoordinates(String commandResult) {
        int start = commandResult.indexOf("[");
        int end = commandResult.indexOf("]");
        if (start == -1 || end == -1) {
            return null;
        }
        String coordinatesPart = commandResult.substring(start + 1, end).replace(",", "");
        return coordinatesPart.split(" ");
    }

    private static double parseCoordinate(String coordinate) {
        try {
            return Double.parseDouble(coordinate.trim());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }
}

