/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packagerLink;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.packagerLink.RequestPromiseQueue;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class LogisticsNetwork {
    public UUID id;
    public RequestPromiseQueue panelPromises;
    public Set<GlobalPos> totalLinks;
    public Set<GlobalPos> loadedLinks;
    public UUID owner;
    public boolean locked;

    public LogisticsNetwork(UUID networkId) {
        this.id = networkId;
        this.panelPromises = new RequestPromiseQueue(Create.LOGISTICS::markDirty);
        this.totalLinks = new HashSet<GlobalPos>();
        this.loadedLinks = new HashSet<GlobalPos>();
        this.owner = null;
        this.locked = false;
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("Id", this.id);
        tag.m_128365_("Promises", (Tag)this.panelPromises.write());
        tag.m_128365_("Links", (Tag)NBTHelper.writeCompoundList(this.totalLinks, p -> {
            CompoundTag nbt = NbtUtils.m_129224_((BlockPos)p.m_122646_());
            if (p.m_122640_() != Level.f_46428_) {
                nbt.m_128359_("Dim", p.m_122640_().m_135782_().toString());
            }
            return nbt;
        }));
        if (this.owner != null) {
            tag.m_128362_("Owner", this.owner);
        }
        tag.m_128379_("Locked", this.locked);
        return tag;
    }

    public static LogisticsNetwork read(CompoundTag tag) {
        LogisticsNetwork network = new LogisticsNetwork(tag.m_128342_("Id"));
        network.panelPromises = RequestPromiseQueue.read(tag.m_128469_("Promises"), Create.LOGISTICS::markDirty);
        NBTHelper.iterateCompoundList((ListTag)tag.m_128437_("Links", 10), nbt -> network.totalLinks.add(GlobalPos.m_122643_((ResourceKey)(nbt.m_128441_("Dim") ? ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("Dim"))) : Level.f_46428_), (BlockPos)NbtUtils.m_129239_((CompoundTag)nbt))));
        network.owner = tag.m_128441_("Owner") ? tag.m_128342_("Owner") : null;
        network.locked = tag.m_128471_("Locked");
        return network;
    }
}

