/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.client.recipebook;

import de.cristelknight.doapi.client.recipebook.screen.widgets.PrivateRecipeBookWidget;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.bakery.recipe.CookingPotRecipe;
import net.satisfy.bakery.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class CookingPotRecipeBook
extends PrivateRecipeBookWidget {
    private static final Component TOGGLE_COOKABLE_TEXT = Component.m_237115_((String)"gui.bakery.recipebook.toggleRecipes.cookable");

    public void showGhostRecipe(Recipe<?> recipe, List<Slot> slots, RegistryAccess registryAccess) {
        this.ghostSlots.addSlot(recipe.m_8043_(registryAccess), slots.get((int)0).f_40220_, slots.get((int)0).f_40221_);
        if (recipe instanceof CookingPotRecipe) {
            CookingPotRecipe cookingPotRecipe = (CookingPotRecipe)recipe;
            this.ghostSlots.addSlot(cookingPotRecipe.getContainer(), slots.get((int)7).f_40220_, slots.get((int)7).f_40221_);
        }
        int j = 1;
        for (Ingredient ingredient : recipe.m_7527_()) {
            ItemStack[] inputStacks = ingredient.m_43908_();
            if (inputStacks.length == 0) continue;
            ItemStack inputStack = inputStacks[RandomSource.m_216327_().m_216339_(0, inputStacks.length)];
            this.ghostSlots.addSlot(inputStack, slots.get((int)j).f_40220_, slots.get((int)j++).f_40221_);
        }
    }

    public void insertRecipe(Recipe<?> r) {
        if (r instanceof CookingPotRecipe) {
            CookingPotRecipe recipe = (CookingPotRecipe)r;
            int usedInputSlots = 1;
            block0: for (Ingredient ingredient : recipe.m_7527_()) {
                int slotIndex = 0;
                for (Slot slot : this.screenHandler.f_38839_) {
                    ItemStack itemStack = slot.m_7993_();
                    if (ingredient.test(itemStack) && usedInputSlots < 7) {
                        Minecraft.m_91087_().f_91072_.m_171799_(this.screenHandler.f_38840_, slotIndex, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                        Minecraft.m_91087_().f_91072_.m_171799_(this.screenHandler.f_38840_, usedInputSlots, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                        ++usedInputSlots;
                        continue block0;
                    }
                    ++slotIndex;
                }
            }
            int slotIndex = 0;
            for (Slot slot : this.screenHandler.f_38839_) {
                ItemStack itemStack = slot.m_7993_();
                if (ItemStack.m_41656_((ItemStack)recipe.getContainer(), (ItemStack)itemStack)) {
                    Minecraft.m_91087_().f_91072_.m_171799_(this.screenHandler.f_38840_, slotIndex, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                    Minecraft.m_91087_().f_91072_.m_171799_(this.screenHandler.f_38840_, 7, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                    break;
                }
                ++slotIndex;
            }
        }
    }

    protected void setCraftableButtonTexture() {
        this.toggleCraftableButton.m_94624_(152, 41, 28, 18, TEXTURE);
    }

    public void slotClicked(@Nullable Slot slot) {
        super.slotClicked(slot);
        if (slot != null && slot.f_40219_ < this.screenHandler.getCraftingSlotCount()) {
            this.ghostSlots.reset();
        }
    }

    protected RecipeType<? extends Recipe<Container>> getRecipeType() {
        return (RecipeType)RecipeTypeRegistry.COOKING_POT_RECIPE_TYPE.get();
    }

    protected Component getToggleCraftableButtonText() {
        return TOGGLE_COOKABLE_TEXT;
    }

    public void m_93692_(boolean bl) {
    }

    public boolean m_93696_() {
        return false;
    }
}

