/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.client;

import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.brewery.client.ClientStorageTypes;
import net.satisfy.brewery.client.model.BeerElementalModel;
import net.satisfy.brewery.client.model.RopeKnotEntityModel;
import net.satisfy.brewery.client.render.block.BeerKegBlockEntityRenderer;
import net.satisfy.brewery.client.render.block.BrewingstationRenderer;
import net.satisfy.brewery.client.render.block.HangingRopeRenderer;
import net.satisfy.brewery.client.render.block.RopeCollisionEntityRenderer;
import net.satisfy.brewery.client.render.block.RopeKnotRenderer;
import net.satisfy.brewery.client.render.entity.BeerElementalAttackRenderer;
import net.satisfy.brewery.client.render.entity.BeerElementalRenderer;
import net.satisfy.brewery.event.PlayerJoinEvent;
import net.satisfy.brewery.item.ItemPredicate;
import net.satisfy.brewery.networking.BreweryNetworking;
import net.satisfy.brewery.registry.ArmorRegistry;
import net.satisfy.brewery.registry.BlockEntityRegistry;
import net.satisfy.brewery.registry.EntityRegistry;
import net.satisfy.brewery.registry.ModelRegistry;
import net.satisfy.brewery.registry.ObjectRegistry;
import net.satisfy.brewery.util.rope.RopeHelper;

@OnlyIn(value=Dist.CLIENT)
public class BreweryClient {
    public static void onInitializeClient() {
        BreweryNetworking.registerS2CPackets();
        ItemPredicate.register();
        BreweryClient.registerRenderer();
        BreweryClient.registerModelLayers();
        RenderTypeRegistry.register((RenderType)RenderType.m_110463_(), (Block[])new Block[]{(Block)ObjectRegistry.WILD_HOPS.get(), (Block)ObjectRegistry.BEER_MUG.get(), (Block)ObjectRegistry.BEER_WHEAT.get(), (Block)ObjectRegistry.BEER_HOPS.get(), (Block)ObjectRegistry.BEER_BARLEY.get(), (Block)ObjectRegistry.BEER_HALEY.get(), (Block)ObjectRegistry.BARLEY_CROP.get(), (Block)ObjectRegistry.CORN_CROP.get(), (Block)ObjectRegistry.HOPS_CROP_BODY.get(), (Block)ObjectRegistry.HOPS_CROP.get(), (Block)ObjectRegistry.SILO_WOOD.get(), (Block)ObjectRegistry.SILO_COPPER.get(), (Block)ObjectRegistry.WHISKEY_CARRASCONLABEL.get(), (Block)ObjectRegistry.WHISKEY_LILITUSINGLEMALT.get(), (Block)ObjectRegistry.WHISKEY_JOJANNIK.get(), (Block)ObjectRegistry.WHISKEY_MAGGOALLAN.get(), (Block)ObjectRegistry.WHISKEY_CRISTELWALKER.get()});
        ColorHandlerRegistry.registerBlockColors((state, world, pos, tintIndex) -> {
            if (world == null || pos == null) {
                return -1;
            }
            return BiomeColors.m_108811_((BlockAndTintGetter)world, (BlockPos)pos);
        }, (Supplier[])new Supplier[]{ObjectRegistry.WOODEN_BREWINGSTATION, ObjectRegistry.COPPER_BREWINGSTATION, ObjectRegistry.NETHERITE_BREWINGSTATION});
        ClientStorageTypes.init();
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register((Object)new PlayerJoinEvent());
        ClientTickEvent.CLIENT_LEVEL_PRE.register(clientLevel -> RopeHelper.tick());
    }

    public static void preInitClient() {
        BreweryClient.registerEntityModelLayers();
    }

    private static void registerRenderer() {
        EntityModelLayerRegistry.register((ModelLayerLocation)ModelRegistry.ROPE_KNOT, RopeKnotEntityModel::createBodyLayer);
        EntityRendererRegistry.register(EntityRegistry.ROPE_KNOT, RopeKnotRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.HANGING_ROPE, HangingRopeRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.ROPE_COLLISION, RopeCollisionEntityRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.BEER_ELEMENTAL, BeerElementalRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.BEER_ELEMENTAL_ATTACK, BeerElementalAttackRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)BlockEntityRegistry.BREWINGSTATION_BLOCK_ENTITY.get()), BrewingstationRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)BlockEntityRegistry.BEER_MUG_FLOWER_POT_BLOCK_ENTITY.get()), BeerKegBlockEntityRenderer::new);
    }

    public static void registerModelLayers() {
        EntityModelLayerRegistry.register((ModelLayerLocation)BeerElementalModel.BEER_ELEMENTAL_MODEL_LAYER, BeerElementalModel::createBodyLayer);
    }

    public static LocalPlayer getPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static void registerEntityModelLayers() {
        ArmorRegistry.registerArmorModelLayers();
    }
}

