/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.item;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.satisfy.brewery.registry.ArmorMaterialRegistry;
import net.satisfy.brewery.registry.MobEffectRegistry;

public interface IBrewfestArmorSet {
    public static final MobEffectInstance hardDrinkingEffect = new MobEffectInstance((MobEffect)MobEffectRegistry.HARDDRINKING.get(), 280, 1);
    public static final Map<ArmorMaterial, MobEffectInstance> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)ArmorMaterialRegistry.BREWFEST_ARMOR, (Object)hardDrinkingEffect).build();

    default public boolean hasBrewfestSet(Player player) {
        return IBrewfestArmorSet.hasBrewfestBoots(player) && IBrewfestArmorSet.hasBrewfestLeggings(player) && IBrewfestArmorSet.hasBrewfestBreastplate(player) && IBrewfestArmorSet.hasBrewfestHelmet(player);
    }

    default public void checkForSet(Player player) {
        if (this.hasBrewfestSet(player)) {
            this.addStatusEffectForMaterial(player, new MobEffectInstance((MobEffect)MobEffectRegistry.HARDDRINKING.get(), 280, 2));
        }
        this.hasBrewfest(player);
    }

    default public void hasBrewfest(Player player) {
        for (Map.Entry<ArmorMaterial, MobEffectInstance> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            ArmorMaterial mapArmorMaterial = entry.getKey();
            MobEffectInstance mapStatusEffect = entry.getValue();
            if (!this.hasCorrectBrewfest(mapArmorMaterial, player)) continue;
            this.addStatusEffectForMaterial(player, mapStatusEffect);
        }
    }

    private boolean hasCorrectBrewfest(ArmorMaterial material, Player player) {
        if (material.equals((Object)ArmorMaterialRegistry.BREWFEST_ARMOR) || material.equals((Object)ArmorMaterialRegistry.BREWFEST_DRESS) || material.equals((Object)ArmorMaterialRegistry.BREWFEST_LEATHER)) {
            int slot = 1;
            if (!player.m_150109_().m_36052_(slot).m_41619_()) {
                ArmorItem armor = (ArmorItem)player.m_150109_().m_36052_(slot).m_41720_();
                return armor.m_40401_() == material;
            }
            return false;
        }
        return false;
    }

    default public void addStatusEffectForMaterial(Player player, MobEffectInstance mapStatusEffect) {
        boolean hasPlayerEffect = player.m_21023_(mapStatusEffect.m_19544_());
        if (!hasPlayerEffect || Objects.requireNonNull(player.m_21124_(mapStatusEffect.m_19544_())).m_19557_() < 220) {
            player.m_7292_(new MobEffectInstance(mapStatusEffect.m_19544_(), mapStatusEffect.m_19557_(), mapStatusEffect.m_19564_(), true, false, true));
        }
    }

    public static boolean hasBrewfestBoots(Player player) {
        if (player.m_150109_().m_36052_(0).m_41619_()) {
            return false;
        }
        Item item = player.m_150109_().m_36052_(0).m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return IBrewfestArmorSet.isBrewfestBoots(armorItem);
        }
        return false;
    }

    private static boolean isBrewfestBoots(ArmorItem armorItem) {
        return armorItem.m_40401_() == ArmorMaterialRegistry.BREWFEST_ARMOR || armorItem.m_40401_() == ArmorMaterialRegistry.BREWFEST_DRESS || armorItem.m_40401_() == ArmorMaterialRegistry.BREWFEST_LEATHER;
    }

    public static boolean hasBrewfestLeggings(Player player) {
        if (player.m_150109_().m_36052_(1).m_41619_()) {
            return false;
        }
        Item item = player.m_150109_().m_36052_(1).m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return IBrewfestArmorSet.isBrewfestLeggings(armorItem);
        }
        return false;
    }

    private static boolean isBrewfestLeggings(ArmorItem armorItem) {
        return armorItem.m_40401_() == ArmorMaterialRegistry.BREWFEST_LEATHER || armorItem.m_40401_() == ArmorMaterialRegistry.BREWFEST_DRESS || armorItem.m_40401_() == ArmorMaterialRegistry.BREWFEST_ARMOR;
    }

    public static boolean hasBrewfestBreastplate(Player player) {
        if (player.m_150109_().m_36052_(2).m_41619_()) {
            return false;
        }
        Item item = player.m_150109_().m_36052_(2).m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return IBrewfestArmorSet.isBrewfestBreastplate(armorItem);
        }
        return false;
    }

    private static boolean isBrewfestBreastplate(ArmorItem armorItem) {
        return armorItem.m_40401_() == ArmorMaterialRegistry.BREWFEST_ARMOR || armorItem.m_40401_() == ArmorMaterialRegistry.BREWFEST_DRESS || armorItem.m_40401_() == ArmorMaterialRegistry.BREWFEST_LEATHER;
    }

    public static boolean hasBrewfestHelmet(Player player) {
        if (player.m_150109_().m_36052_(3).m_41619_()) {
            return false;
        }
        Item item = player.m_150109_().m_36052_(3).m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return IBrewfestArmorSet.isBrewfestHelmet(armorItem);
        }
        return false;
    }

    private static boolean isBrewfestHelmet(ArmorItem armorItem) {
        return armorItem.m_40401_() == ArmorMaterialRegistry.BREWFEST_LEATHER || armorItem.m_40401_() == ArmorMaterialRegistry.BREWFEST_DRESS || armorItem.m_40401_() == ArmorMaterialRegistry.BREWFEST_LEATHER;
    }
}

